/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.jsf.support;

import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;

public class ParamBeanGenInfo {
    private Method method;
    private String beanInstanceName;
    private String instanceName;
    private String instanceClassName;
    private String[] paramNames = null;
    private String[] paramTypes = null;
    private List importList = new ArrayList();
    private EObjectContainmentEList paramList;

    public ParamBeanGenInfo(String beanInstanceName, String beanPath, Method method, JavaModel model) {
        this.beanInstanceName = beanInstanceName;
        this.method = method;
        this.generateParamBeanName(model, beanPath);
        this.paramList = (EObjectContainmentEList)method.getParameters();
        this.paramNames = new String[this.paramList.size()];
        this.paramTypes = new String[this.paramList.size()];
        int i = 0;
        while (i < this.paramList.size()) {
            JavaParameter param = (JavaParameter)this.paramList.get(i);
            this.paramNames[i] = param.getName();
            this.paramTypes[i] = param.getJavaType().getJavaName();
            if (param.getJavaType().isArray()) {
                String trimmedType = this.paramTypes[i];
                while (trimmedType.endsWith("[]")) {
                    trimmedType = trimmedType.substring(0, trimmedType.length() - 2);
                }
                if (trimmedType != null && !trimmedType.startsWith("java.lang.")) {
                    this.importList.add(trimmedType);
                }
            } else if (this.paramTypes[i] != null && !this.paramTypes[i].startsWith("java.lang.")) {
                this.importList.add(this.paramTypes[i]);
            }
            ++i;
        }
    }

    private void generateParamBeanName(JavaModel model, String beanPath) {
        this.instanceClassName = String.valueOf(JavaCodeUtil.capitalizeFirst((String)this.beanInstanceName)) + JavaCodeUtil.capitalizeFirst((String)this.method.getName()) + "ParamBean";
        int i = 1;
        while (!this.isClassGenerationRequired(beanPath, model)) {
            this.instanceClassName = String.valueOf(this.instanceClassName) + i++;
        }
        this.instanceName = this.instanceClassName;
        this.instanceName = Introspector.decapitalize(this.instanceName);
    }

    public String getClassName() {
        return this.instanceClassName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Method getMethod() {
        return this.method;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public String[] getParamTypes() {
        return this.paramTypes;
    }

    public String[] getRequiredImports() {
        return this.importList.toArray(new String[0]);
    }

    private IFolder getSourceFolder(JavaModel context) {
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)context.getProject());
        if (sources == null || sources.length == 0) {
            return null;
        }
        IPackageFragmentRoot root = sources[0];
        IResource res = root.getResource();
        return (IFolder)res;
    }

    public boolean isClassGenerationRequired(String beanPath, JavaModel model) {
        boolean create = true;
        beanPath = beanPath.replace('.', '/');
        String tempName = beanPath.concat(this.instanceClassName);
        IFile file = this.getSourceFolder(model).getFile(tempName.concat(".java"));
        if (file.exists()) {
            return false;
        }
        return create;
    }

    public boolean isRequired() {
        return this.paramList != null && this.paramList.size() > 0;
    }
}

