/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.jsf.pdm.internal;

import com.ibm.etools.webtools.codebehind.java.tasks.AddJavaBeanMethodTask;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.api.IPageTypeInspector;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.impl.internal.PageTypeInspectorsRegistryReader;
import com.ibm.etools.webtools.pagedataview.ui.internal.PageTypeHelper;
import com.ibm.etools.webtools.server.internal.JsfPageUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class TemporaryInitializationHelper
implements AddJavaBeanMethodTask.InitializationHelper {
    private boolean IS_TEST_MODE = false;

    @Override
    public byte getInitializationStyle(ICodeGenModel cgModel) {
        int init = 1;
        if (cgModel != null) {
            HashSet<ICodeGenModel> set = new HashSet<ICodeGenModel>();
            set.add(cgModel);
            ICodeGenModel sibling = cgModel.getPreviousModel();
            ICodeGenModel previous = cgModel;
            while (sibling != null && sibling != previous) {
                set.add(sibling);
                previous = sibling;
                sibling = sibling.getPreviousModel();
            }
            sibling = cgModel.getNextModel();
            previous = cgModel;
            while (sibling != null && sibling != previous) {
                set.add(sibling);
                previous = sibling;
                sibling = sibling.getNextModel();
            }
            if (set.size() == 1) {
                ICodeGenNode root = cgModel.getRoot();
                if (root != null) {
                    IPageDataNode rootPDN = root.getEnclosedNode();
                    if (rootPDN != null) {
                        IPageDataModel rootModel = rootPDN.getPageDataModel();
                        init = this.getInitializationStyle(rootModel);
                    }
                } else {
                    IPageDataNode cgPDN;
                    ICodeGenNode cgNode;
                    List cgNodes = cgModel.getCodeGenNodes();
                    if (cgNodes != null && cgNodes.size() > 0 && (cgNode = (ICodeGenNode)cgNodes.get(0)) != null && (cgPDN = cgNode.getEnclosedNode()) != null) {
                        IPageDataModel pdModel = cgPDN.getPageDataModel();
                        init = this.getInitializationStyle(pdModel);
                    }
                }
            } else {
                init = 4;
            }
        }
        return (byte)init;
    }

    @Override
    public byte getInitializationStyle(IDOMModel domModel) {
        String[] types;
        if (this.IS_TEST_MODE) {
            return 4;
        }
        if (domModel != null && (types = this.getPageTypes(domModel)) != null) {
            int i = 0;
            while (i < types.length) {
                String type = types[i];
                if (type != null && type.endsWith("PORTLET")) {
                    return 4;
                }
                ++i;
            }
        }
        return 1;
    }

    @Override
    public byte getInitializationStyle(IPageDataModel model) {
        if (this.IS_TEST_MODE) {
            return 4;
        }
        PageTypeHelper helper = new PageTypeHelper(model);
        String[] types = helper.getPageTypes((short)1);
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            if (type != null && type.endsWith("PORTLET")) {
                return 4;
            }
            ++i;
        }
        return 1;
    }

    @Override
    public byte getInitializationStyle(IPageDataModel source, IPageDataModel target) {
        return source != target ? (byte)4 : this.getInitializationStyle(source);
    }

    private String[] getPageTypes(IDOMModel domModel) {
        ArrayList<String> ret;
        block7: {
            ret = new ArrayList<String>(1);
            String temp = "HTML";
            try {
                IDOMDocument doc = domModel.getDocument();
                if (domModel.getContentTypeIdentifier().equals(ContentTypeIdForJSP.ContentTypeID_JSP)) {
                    temp = "JSP";
                }
                if (JsfPageUtil.isJsfPage((Document)doc)) {
                    temp = "JSF";
                }
                ret.add(temp);
                IPageTypeInspector[] inspectors = PageTypeInspectorsRegistryReader.getPageTypeInspectors((IProject)this.getResource(domModel).getProject());
                if (inspectors == null || inspectors.length <= 0) break block7;
                int i = 0;
                while (i < inspectors.length) {
                    String type = inspectors[i].getPageType((Document)doc);
                    if (type != null) {
                        if (inspectors[i].isExclusive((short)1)) {
                            ret.clear();
                            ret.add(type);
                            break;
                        }
                        ret.add(type);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        return ret.toArray(new String[ret.size()]);
    }

    private IFile getResource(IDOMModel domModel) {
        if (domModel == null) {
            return null;
        }
        String path = domModel.getBaseLocation();
        if (path == null || path.length() == 0) {
            String id = domModel.getId();
            if (id == null) {
                return null;
            }
            path = id.toString();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path resourcePath = new Path(path);
        IFile file = resourcePath.toFile().exists() ? root.getFileForLocation((IPath)resourcePath) : root.getFile((IPath)resourcePath);
        return file;
    }
}

