/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.tasks;

import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.webtools.codebehind.api.XMLElementInfo;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.java.PageCodeDocletSupport;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.java.tasks.SyncTaskDeleteFieldCommand;
import com.ibm.etools.webtools.codebehind.java.tasks.SyncTaskDeleteImportConditionallyCommand;
import com.ibm.etools.webtools.codebehind.java.tasks.SyncTaskDeleteMethodCommand;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.IJavaCommand;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.commands.CreateFieldCommand;
import com.ibm.etools.webtools.javamodel.commands.CreateImportCommand;
import com.ibm.etools.webtools.javamodel.commands.CreateMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.RenameJsfIdentifiersCommand;
import com.ibm.etools.webtools.pagedatamodel.util.JavaTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SyncXMLtoJavaTask
extends AbstractJavaModelTask {
    private List eventQueue = new ArrayList();
    private List incomingQueue = new ArrayList();
    private Map xmlNodeJavaElementMap;
    private Map nodeChangedMap;
    private Map deletedTypesMap = new HashMap();

    public SyncXMLtoJavaTask(Map xmlNodeJavaElementMap, List eventQueue, IDOMDocument document) {
        this.incomingQueue.addAll(eventQueue);
        this.xmlNodeJavaElementMap = xmlNodeJavaElementMap;
        this.setBackgroundJobFamily(new Object[]{CodeBehindCoreUtil.CODE_BEHIND_SYNC_XML_JOB_FAMILY, CodeBehindCoreUtil.CODE_BEHIND_CANCELEABLE_JOB_FAMILY});
    }

    private void addedJSFComponent(JavaModel model, IDOMElement element, IProgressMonitor monitor) throws JavaModelException {
        String fullyQualifiedType;
        String identifier = this.getJSFNodeId((IDOMNode)element);
        boolean valid = JavaCodeUtil.isJavaIdentifierNotDup((String)identifier, (IType)model.getType());
        if (valid && (fullyQualifiedType = JsfComponentUtil.getComponentClassName((Node)element)) != null) {
            String simpleType = Signature.getSimpleName((String)fullyQualifiedType);
            CreateImportCommand cmd = new CreateImportCommand();
            cmd.setFullyQualifiedType(fullyQualifiedType);
            cmd.execute(model, monitor);
            CreateFieldCommand field = new CreateFieldCommand();
            field.setFullyQualifiedType(simpleType);
            field.setIdentifier(identifier);
            field.setModifier("protected");
            PageCodeDocletSupport.addTagDoclet((IJavaCommand)field);
            field.execute(model, monitor);
            CreateMethodCommand getter = new CreateMethodCommand();
            getter.setIdentifier("get" + JavaCodeUtil.capitalizeFirst((String)identifier));
            getter.setModifier("protected");
            getter.setParameters(new String[0]);
            getter.setParameterNames(new String[0]);
            getter.setReturnType(simpleType);
            getter.setForce(true);
            StringBuffer buf = new StringBuffer();
            buf.append("if (");
            buf.append(identifier);
            buf.append(" == null) {");
            buf.append("    ");
            buf.append(identifier);
            buf.append(" = (");
            buf.append(simpleType);
            buf.append(") findComponentInRoot(\"");
            buf.append(identifier);
            buf.append("\");");
            buf.append("}");
            buf.append("return ");
            buf.append(identifier);
            buf.append(";");
            getter.setContents(buf.toString());
            PageCodeDocletSupport.addTagDoclet((IJavaCommand)getter);
            getter.execute(model, monitor);
            this.xmlNodeJavaElementMap.put(element, getter.getCreatedMethod());
        }
    }

    public synchronized void addEventsToQueue(List newEventQueue) {
        this.incomingQueue.addAll(newEventQueue);
    }

    private void changedJSFComponent(JavaModel model, XMLElementInfo eInfo, IProgressMonitor monitor) throws JavaModelException {
        IDOMElement element = eInfo.element;
        String newId = this.getJSFNodeId((IDOMNode)element);
        String oldId = this.getPreviousNodeId(element);
        if (newId == null || newId.equals("")) {
            this.removedJSFComponent(model, element, monitor);
        } else if (oldId == null || oldId.equals("")) {
            this.addedJSFComponent(model, element, monitor);
        } else if (!newId.equals(oldId)) {
            boolean valid = JavaConventions.validateIdentifier((String)newId).isOK();
            if (valid) {
                boolean dup = JavaCodeUtil.isIdentifierDuplicate((String)newId, (IType)model.getType());
                if (!dup) {
                    RenameJsfIdentifiersCommand renameCmd = new RenameJsfIdentifiersCommand();
                    renameCmd.setOldIdentifier(oldId);
                    renameCmd.setNewIdentifier(newId);
                    renameCmd.execute(model, monitor);
                    ReadMethodCommand cmd = new ReadMethodCommand();
                    cmd.setIdentifier("get" + JavaCodeUtil.capitalizeFirst((String)newId));
                    cmd.execute(model, monitor);
                    IMethod method = cmd.getMethod();
                    this.xmlNodeJavaElementMap.put(element, method);
                }
            } else {
                this.removedJSFComponent(model, element, monitor);
            }
        }
    }

    public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
        this.populateCurrentQueueFromIncoming();
        monitor.beginTask(null, this.eventQueue.size());
        int i = 0;
        while (i < this.eventQueue.size()) {
            XMLElementInfo info = (XMLElementInfo)this.eventQueue.get(i);
            switch (info.eventType) {
                case 2: {
                    if (!this.isJSFNode(info) || this.hasOpposite(info)) break;
                    this.addedJSFComponent(model, info.element, monitor);
                    break;
                }
                case 3: {
                    if (!this.isJSFNode(info) || this.hasOpposite(info)) break;
                    this.removedJSFComponent(model, info.element, monitor);
                    break;
                }
                case 1: {
                    Attr attribute;
                    String name;
                    if (!this.isJSFNode(info) || !(info.changedFeature instanceof Attr) || !"id".equalsIgnoreCase(name = (attribute = (Attr)info.changedFeature).getName())) break;
                    this.changedJSFComponent(model, info, monitor);
                }
            }
            monitor.worked(1);
            ++i;
        }
        if (this.nodeChangedMap != null) {
            Set keys = this.nodeChangedMap.keySet();
            for (Object oldElement : keys) {
                Object removedMethod = this.xmlNodeJavaElementMap.remove(oldElement);
                this.xmlNodeJavaElementMap.put(this.nodeChangedMap.get(oldElement), removedMethod);
            }
            this.nodeChangedMap = null;
        }
        if (!this.deletedTypesMap.isEmpty()) {
            String typeSig = "UIComponent";
            this.deletedTypesMap.put(typeSig, new Object());
            SyncTaskDeleteImportConditionallyCommand deleteImport = new SyncTaskDeleteImportConditionallyCommand();
            deleteImport.setDeletedTypes(this.deletedTypesMap);
            deleteImport.execute(model, monitor);
            this.deletedTypesMap.clear();
        }
        this.eventQueue.clear();
        monitor.done();
    }

    public String getDisplayName() {
        return Messages.SyncXMLtoJavaTask_0;
    }

    private String getJSFNodeId(IDOMNode node) {
        String identifier = null;
        if (node != null && node.getNodeType() == 1) {
            Element jsfElement = (Element)node;
            identifier = jsfElement.getAttribute("id");
        }
        return identifier;
    }

    private String getPreviousNodeId(IDOMElement element) {
        String ret = null;
        IMethod method = (IMethod)this.xmlNodeJavaElementMap.get(element);
        if (method != null) {
            String propName;
            ret = propName = JavaTypeUtil.getPropertyName((String)method.getElementName());
        }
        return ret;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private boolean hasOpposite(XMLElementInfo theinfo) {
        int addCount = 0;
        int removeCount = 0;
        for (XMLElementInfo info : this.eventQueue) {
            String removedIdentifier;
            String addedIdentifier;
            if (info.element == theinfo.element) {
                if (theinfo.eventType == 2 && info.eventType == 3) {
                    ++removeCount;
                    continue;
                }
                if (theinfo.eventType == 3 && info.eventType == 2) {
                    return true;
                }
                if (theinfo.eventType != 2 || info.eventType != 2) continue;
                ++addCount;
                continue;
            }
            if (!theinfo.element.getNodeName().equals(info.element.getNodeName())) continue;
            if (theinfo.eventType == 2 && info.eventType == 3) {
                addedIdentifier = this.getJSFNodeId((IDOMNode)theinfo.element);
                removedIdentifier = this.getPreviousNodeId(info.element);
                if (addedIdentifier == null || !addedIdentifier.equals(removedIdentifier)) continue;
                if (this.nodeChangedMap == null) {
                    this.nodeChangedMap = new HashMap();
                }
                this.nodeChangedMap.put(info.element, theinfo.element);
                return true;
            }
            if (theinfo.eventType != 3 || info.eventType != 2) continue;
            addedIdentifier = this.getJSFNodeId((IDOMNode)info.element);
            removedIdentifier = this.getPreviousNodeId(theinfo.element);
            if (addedIdentifier == null || !addedIdentifier.equals(removedIdentifier)) continue;
            if (this.nodeChangedMap == null) {
                this.nodeChangedMap = new HashMap();
            }
            this.nodeChangedMap.put(theinfo.element, info.element);
            return true;
        }
        if (addCount > 0 && addCount > removeCount) {
            return false;
        }
        return false;
    }

    private boolean isJSFNode(XMLElementInfo xmlInfo) {
        boolean ret = false;
        IDOMDocument doc = (IDOMDocument)xmlInfo.element.getOwnerDocument();
        if (JsfComponentUtil.isJsfPage((Document)doc)) {
            ret = JsfComponentUtil.isJsfTag((Node)xmlInfo.element);
        }
        return ret;
    }

    public boolean isSystem() {
        return false;
    }

    private synchronized void populateCurrentQueueFromIncoming() {
        this.eventQueue.addAll(this.incomingQueue);
        this.incomingQueue.clear();
    }

    private void removedJSFComponent(JavaModel model, IDOMElement element, IProgressMonitor monitor) throws JavaModelException {
        String identifier = this.getPreviousNodeId(element);
        if (identifier != null) {
            SyncTaskDeleteFieldCommand deleteField = new SyncTaskDeleteFieldCommand();
            deleteField.setIdentifier(identifier);
            deleteField.execute(model, monitor);
            String signature = deleteField.getTypeSignature();
            if (signature != null) {
                String typeSig = Signature.getSimpleName((String)Signature.toString((String)signature));
                this.deletedTypesMap.put(typeSig, new Object());
            }
            SyncTaskDeleteMethodCommand deleteMethod = new SyncTaskDeleteMethodCommand();
            deleteMethod.setIdentifier("get" + JavaCodeUtil.capitalizeFirst((String)identifier));
            deleteMethod.setParameters(new String[0]);
            deleteMethod.execute(model, monitor);
            String returnType = deleteMethod.getTypeSignature();
            if (returnType != null) {
                String typeSig = Signature.getSimpleName((String)Signature.toString((String)returnType));
                this.deletedTypesMap.put(typeSig, new Object());
            }
            this.xmlNodeJavaElementMap.remove(element);
        }
    }
}

