/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.tasks;

import com.ibm.etools.webtools.codebehind.api.CodeBehindPreferences;
import com.ibm.etools.webtools.codebehind.java.PageCodeDocletSupport;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.java.tasks.AbstractPageCodeTask;
import com.ibm.etools.webtools.codebehind.jsf.pdm.internal.TemporaryInitializationHelper;
import com.ibm.etools.webtools.codebehind.jsf.support.ParamBeanGenInfo;
import com.ibm.etools.webtools.codebehind.jsf.support.ResultBeanGenInfo;
import com.ibm.etools.webtools.codebehind.jsf.support.dialogs.MethodInvokingJBData;
import com.ibm.etools.webtools.javamodel.api.IJavaCommand;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.commands.CreateImportCommand;
import com.ibm.etools.webtools.javamodel.commands.CreateMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.JavaCommand;
import com.ibm.etools.webtools.javamodel.commands.PrepareTypeCommandEx;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.UpdateMethodCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class AddJavaBeanMethodTask
extends AbstractPageCodeTask {
    public static final InitializationHelper DEFAULT_HELPER = new TemporaryInitializationHelper();
    private List fImportList;
    protected IMethod fActionMethodCreated;
    @Deprecated
    protected Method fJEMMethod;
    protected IMethod fMethod;
    protected ParamBeanGenInfo fParamBeanGenInfo;
    protected ResultBeanGenInfo fResultBeanGenInfo;
    protected String fParamBeanInstanceName;
    protected String fResultBeanInstanceName;
    protected String fActionName;
    protected String fBeanName;
    protected String fBeanClassName;
    protected String fBeanGetterName;
    protected String fGetterMethodContents;
    protected Map fSuggestedIds;
    protected byte fInitializationStyle = 0;
    protected String fException = "Throwable";

    public AddJavaBeanMethodTask(Method method, String beanName, String beanClassName, String beanGetterName, String getterContents, Map suggestedIds) {
        this.fJEMMethod = method;
        this.fBeanName = beanName;
        this.fBeanClassName = beanClassName;
        this.fBeanGetterName = beanGetterName;
        this.fSuggestedIds = suggestedIds;
        this.fGetterMethodContents = getterContents;
    }

    public AddJavaBeanMethodTask(Method method, String beanName, String beanClassName, String beanGetterName, String getterContents, Map suggestedIds, String exc, String excImport) {
        this.fJEMMethod = method;
        this.fBeanName = beanName;
        this.fBeanClassName = beanClassName;
        this.fBeanGetterName = beanGetterName;
        this.fGetterMethodContents = getterContents;
        this.fSuggestedIds = suggestedIds;
        if (exc != null) {
            this.fException = exc;
        }
        if (excImport != null) {
            this.getImportList().add(excImport);
        }
    }

    public AddJavaBeanMethodTask(MethodInvokingJBData data, String beanGetterName, Map suggestedIds) {
        this(null, data.getPCData().getBeanName(), data.getPCData().getQualifiedName(), beanGetterName, data.getPCData().getGetterContents(), suggestedIds);
        this.fInitializationStyle = data.getInitializationStyle();
        this.fJEMMethod = data.getSelectedMethod();
    }

    protected void addPageDataChangeListeners() {
    }

    public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
        String beanPath = String.valueOf(CodeBehindPreferences.getCodebehindPackagePrefix((IProject)model.getProject())) + ".";
        this.fParamBeanGenInfo = new ParamBeanGenInfo(this.fBeanName, beanPath, this.fJEMMethod, model);
        this.fResultBeanGenInfo = new ResultBeanGenInfo(this.fBeanName, this.fJEMMethod, model);
        this.fActionName = String.valueOf(this.fBeanName) + JavaCodeUtil.capitalizeFirst((String)this.fJEMMethod.getName()) + "Action";
        this.fActionName = "do" + JavaCodeUtil.capitalizeFirst((String)this.fActionName);
        this.processParamBeanGeneration(beanPath, model, monitor);
        this.processResultBeanGeneration(model, monitor);
        this.processActionGeneration(model, monitor);
        try {
            for (String animport : this.getImportList()) {
                CreateImportCommand importCmd = new CreateImportCommand();
                importCmd.setFullyQualifiedType(animport);
                importCmd.execute(model, monitor);
            }
        }
        catch (JavaModelException je) {
            je.printStackTrace();
        }
        String methodID = this.fJEMMethod.getMethodElementSignature();
        String docletComment = "id=" + methodID + "/";
        if (this.fParamBeanGenInfo.isRequired()) {
            docletComment = docletComment.concat("paramBean=" + (String)this.fSuggestedIds.get("paramBean") + "/");
        }
        if (this.fResultBeanGenInfo.isRequired()) {
            docletComment = docletComment.concat("resultBean=" + (String)this.fSuggestedIds.get("resultBean") + "/");
        }
        docletComment = docletComment.concat("action=" + (String)this.fSuggestedIds.get("action"));
        try {
            String contents;
            ReadMethodCommand readMethodCmd = new ReadMethodCommand();
            readMethodCmd.setIdentifier(this.fBeanGetterName);
            readMethodCmd.execute(model, monitor);
            JavaDocInfo javadocUpdate = readMethodCmd.getJavadoc();
            UpdateMethodCommand updateMethod = new UpdateMethodCommand();
            updateMethod.setIdentifier(this.fBeanGetterName);
            updateMethod.setModifier("public");
            updateMethod.setParameters(new String[0]);
            updateMethod.setParameterNames(new String[0]);
            updateMethod.setReturnType(this.fBeanClassName);
            updateMethod.setForce(true);
            javadocUpdate.addJavaDocElement("methodEntry", docletComment);
            PageCodeDocletSupport.addDataDoclet((IJavaCommand)updateMethod);
            updateMethod.setJavadoc(javadocUpdate);
            if (this.fGetterMethodContents == null) {
                StringBuffer buf = new StringBuffer(64).append("if (").append(this.fBeanName).append(" == null){\n").append(this.fBeanName).append(" = new ").append(this.fBeanClassName).append("();\n}\nreturn ").append(this.fBeanName).append(";");
                this.fGetterMethodContents = buf.toString();
            }
            updateMethod.setContents((contents = readMethodCmd.getContents()) == null || contents.equals("") || contents.equals("READ ERROR!!") ? this.fGetterMethodContents : contents);
            updateMethod.execute(model, monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IMethod getActionMethodCreated() {
        return this.fActionMethodCreated;
    }

    protected CreateMethodCommand getCreateActionMethodCommand(byte initialization) {
        String actionId = (String)this.fSuggestedIds.get("action");
        String paramBeanGetter = "get" + JavaCodeUtil.capitalizeFirst((String)this.fParamBeanGenInfo.getInstanceName());
        String[] paramNames = this.fParamBeanGenInfo.getParamNames();
        StringBuffer[] params = new StringBuffer[paramNames.length];
        int i = 0;
        while (i < paramNames.length) {
            params[i] = new StringBuffer(paramBeanGetter).append("().").append("get").append(JavaCodeUtil.capitalizeFirst((String)paramNames[i])).append("()");
            ++i;
        }
        JavaDocInfo javadoc = new JavaDocInfo();
        javadoc.addJavaDocElement("action", "id=" + actionId);
        CreateMethodCommand cmd = new CreateMethodCommand();
        cmd.setIdentifier(this.fActionName);
        cmd.setModifier("public");
        cmd.setParameters(new String[0]);
        cmd.setParameterNames(new String[0]);
        cmd.setReturnType("String");
        cmd.setForce(true);
        cmd.setJavadoc(javadoc);
        PageCodeDocletSupport.addDataDoclet((IJavaCommand)cmd);
        StringBuffer buf = new StringBuffer(64).append("try {\n");
        if (!this.fJEMMethod.isVoid()) {
            buf.append(this.fResultBeanGenInfo.getInstanceName()).append(" = ").append(this.fBeanGetterName).append("().").append(this.fJEMMethod.getName()).append("(");
        } else {
            buf.append(this.fBeanGetterName).append("().").append(this.fJEMMethod.getName()).append("(");
        }
        int i2 = 0;
        while (i2 < params.length) {
            buf.append(params[i2]);
            if (i2 < params.length - 1) {
                buf.append(",");
            }
            ++i2;
        }
        buf.append(");\n");
        if (!this.fJEMMethod.isVoid()) {
            String scope;
            String string = initialization == 3 ? "Request" : (scope = initialization == 4 ? "Session" : null);
            if (scope != null) {
                String key;
                String object = key = this.fResultBeanGenInfo.getInstanceName();
                JavaHelpers returnType = this.fJEMMethod.getReturnType();
                if (returnType.isPrimitive()) {
                    String simpleName = returnType.getWrapper().getSimpleName();
                    object = "new " + simpleName + "(" + object + ")";
                }
                buf.append("get").append(scope).append("Scope().put(").append("\"").append(key).append("\", ").append(object).append(");\n");
            }
        }
        buf.append("} catch (").append(this.fException).append(" e) {  \tlogException(e); }\nreturn \"\";");
        cmd.setContents(buf.toString());
        return cmd;
    }

    public String getDisplayName() {
        return Messages.AddJavaBeanMethodTask_11;
    }

    protected List getImportList() {
        if (this.fImportList == null) {
            this.fImportList = new ArrayList();
        }
        return this.fImportList;
    }

    public byte getInitializationStyle() {
        return this.fInitializationStyle;
    }

    public String getParamBeanInstanceName() {
        return this.fParamBeanInstanceName;
    }

    public String getResultBeanInstanceName() {
        return this.fResultBeanInstanceName;
    }

    protected CreateMethodCommand getUpdateJavaBeanMethodActionCommand() {
        CreateMethodCommand cmd = this.getCreateActionMethodCommand((byte)1);
        return cmd;
    }

    protected void processActionGeneration(JavaModel model, IProgressMonitor monitor) {
        CreateMethodCommand javaBeanMethodActionCmd = this.getCreateActionMethodCommand(this.getInitializationStyle());
        javaBeanMethodActionCmd.setForce(false);
        try {
            javaBeanMethodActionCmd.execute(model, monitor);
            this.fActionMethodCreated = javaBeanMethodActionCmd.getCreatedMethod();
        }
        catch (JavaModelException je) {
            je.printStackTrace();
        }
    }

    protected void processParamBeanGeneration(String beanPackage, JavaModel model, IProgressMonitor monitor) {
        if (this.fParamBeanGenInfo.isRequired()) {
            if (this.fParamBeanGenInfo.isClassGenerationRequired(beanPackage, model)) {
                PrepareTypeCommandEx cmd = (PrepareTypeCommandEx)this.getCreateParamClassCommand(this.fParamBeanGenInfo.getClassName(), model, beanPackage, this.fParamBeanGenInfo.getParamNames(), this.fParamBeanGenInfo.getParamTypes(), this.fParamBeanGenInfo.getRequiredImports());
                try {
                    cmd.setProject(model.getProject());
                    cmd.execute(model, monitor);
                }
                catch (JavaModelException je) {
                    je.printStackTrace();
                }
            }
            JavaCommand paramBeanFieldCmd = this.getCreateBeanFieldCommand(this.fParamBeanGenInfo.getInstanceName(), this.fParamBeanGenInfo.getClassName());
            try {
                paramBeanFieldCmd.execute(model, monitor);
            }
            catch (JavaModelException je) {
                je.printStackTrace();
            }
            String paramBeanId = (String)this.fSuggestedIds.get("paramBean");
            JavaDocInfo paramBeanJdInfo = new JavaDocInfo();
            paramBeanJdInfo.addJavaDocElement("paramBean", "id=" + paramBeanId);
            this.fParamBeanInstanceName = this.fParamBeanGenInfo.getInstanceName();
            JavaCommand beanGetterCmd = this.getCreateBeanGetterCommand(this.fParamBeanInstanceName, this.fParamBeanGenInfo.getClassName(), true, paramBeanJdInfo);
            try {
                beanGetterCmd.execute(model, monitor);
            }
            catch (JavaModelException je) {
                je.printStackTrace();
            }
        }
    }

    protected void processResultBeanGeneration(JavaModel model, IProgressMonitor monitor) {
        if (this.fResultBeanGenInfo.isRequired()) {
            JavaCommand resultBeanFieldCmd = this.getCreateBeanFieldCommand(this.fResultBeanGenInfo.getInstanceName(), this.fResultBeanGenInfo.getInstanceClass());
            try {
                resultBeanFieldCmd.execute(model, monitor);
            }
            catch (JavaModelException je) {
                je.printStackTrace();
            }
            JavaDocInfo resultBeanJdInfo = new JavaDocInfo();
            String resultBeanId = (String)this.fSuggestedIds.get("resultBean");
            resultBeanJdInfo.addJavaDocElement("resultBean", "id=" + resultBeanId);
            this.fResultBeanInstanceName = this.fResultBeanGenInfo.getInstanceName();
            String wrapperType = null;
            JavaHelpers returnType = this.fJEMMethod.getReturnType();
            if (returnType.isPrimitive()) {
                wrapperType = returnType.getWrapper().getSimpleName();
            }
            JavaCommand resultBeanGetterCmd = this.getCreateBeanGetterCommand(this.fResultBeanInstanceName, this.fResultBeanGenInfo.getInstanceClass(), resultBeanJdInfo, this.getInitializationStyle(), null, wrapperType);
            try {
                resultBeanGetterCmd.execute(model, monitor);
                if (this.fResultBeanGenInfo.getRequiredImport() != null && !this.fResultBeanGenInfo.getRequiredImport().startsWith("java.lang.")) {
                    CreateImportCommand importCmd = new CreateImportCommand();
                    importCmd.setFullyQualifiedType(this.fResultBeanGenInfo.getRequiredImport());
                    importCmd.execute(model, monitor);
                }
            }
            catch (JavaModelException je) {
                je.printStackTrace();
            }
        }
    }

    protected void setImportList(List importList) {
        this.fImportList = importList;
    }

    public void setInitializationStyle(byte style) {
        this.fInitializationStyle = style;
    }

    public void setMethod(IMethod method) {
        this.fMethod = method;
    }

    public static interface InitializationHelper {
        public byte getInitializationStyle(ICodeGenModel var1);

        public byte getInitializationStyle(IDOMModel var1);

        public byte getInitializationStyle(IPageDataModel var1);

        public byte getInitializationStyle(IPageDataModel var1, IPageDataModel var2);
    }
}

