/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.refactoring.changes;

import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.internal.CBLanguageAdapterFactoryProvider;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class UpdateFacesMetadataChange
extends Change {
    private IFile jspFile;
    private IPath newCodebehindPath;
    private IPath oldCodebehindPath;

    public UpdateFacesMetadataChange(IFile jspFile, IPath oldCodebehindPath, IPath newCodebehindPath) {
        this.jspFile = jspFile;
        this.oldCodebehindPath = oldCodebehindPath;
        this.newCodebehindPath = newCodebehindPath;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return NLS.bind((String)Messages.UpdateFacesMetadataChange_0, (Object[])new String[]{this.jspFile.getName(), this.oldCodebehindPath.toString(), this.newCodebehindPath.toString()});
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        block11: {
            IModelManager manager = StructuredModelManager.getModelManager();
            IStructuredModel model = null;
            try {
                CBLanguageAdapterFactoryProvider adapterFactoryProvider;
                model = manager.getModelForEdit(this.jspFile);
                IDOMDocument xmldoc = ((IDOMModel)model).getDocument();
                ICBLanguage language = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmldoc);
                if (language == null && (adapterFactoryProvider = new CBLanguageAdapterFactoryProvider()).isFor((IDocumentTypeHandler)model.getModelHandler())) {
                    adapterFactoryProvider.addAdapterFactories(model);
                    language = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmldoc);
                }
                if (language != null) {
                    language.switchLanguage(language.getCBInfo().language, this.newCodebehindPath, false);
                    model.save();
                }
            }
            catch (IOException iOException) {
                if (model != null) {
                    model.releaseFromEdit();
                }
                break block11;
            }
            catch (CoreException e) {
                try {
                    e.printStackTrace();
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (model != null) {
                        model.releaseFromEdit();
                    }
                }
            }
            if (model == null) break block11;
            model.releaseFromEdit();
        }
        return new UpdateFacesMetadataChange(this.jspFile, this.newCodebehindPath, this.oldCodebehindPath);
    }
}

