/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.refactoring.changes;

import com.ibm.etools.webtools.codebehind.java.extensions.MoveCBModelTask;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class MovePageCodeChange
extends Change {
    private IFile fromFile;
    private IFolder destination;
    private String newName;

    public MovePageCodeChange(IFile fromFile, IFolder destination, String newName) {
        this.fromFile = fromFile;
        this.destination = destination;
        this.newName = newName;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        String name = "";
        if (this.destination.equals((Object)this.fromFile.getParent())) {
            IFile file = this.destination.getFile(this.newName);
            name = NLS.bind((String)Messages.MovePageCodeChange_0, (Object)this.fromFile.getProjectRelativePath().toString(), (Object)file.getProjectRelativePath().toString());
        } else {
            name = NLS.bind((String)Messages.MovePageCodeChange_1, (Object)this.fromFile.getProjectRelativePath().toString(), (Object)this.destination.getProjectRelativePath().toString());
        }
        return name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IPath codebehindPath = this.fromFile.getProjectRelativePath().makeAbsolute();
        IPackageFragment destinationPackage = (IPackageFragment)JavaCore.create((IFolder)this.destination);
        if (destinationPackage != null) {
            JavaModel jmodel = JavaModelManager.getInstance().getModel("codebehind", this.fromFile.getProject(), codebehindPath);
            MoveCBModelTask moveCmd = new MoveCBModelTask();
            moveCmd.setDestination(destinationPackage);
            moveCmd.setNewName(this.newName);
            try {
                jmodel.runBlockingJavaTask((AbstractJavaModelTask)moveCmd, null, pm);
            }
            finally {
                jmodel.release();
            }
            pm.worked(1);
        }
        IFile newFile = this.destination.getFile(this.newName);
        return new MovePageCodeChange(newFile, (IFolder)this.fromFile.getParent(), this.fromFile.getName());
    }
}

