/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.refactoring;

import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.java.FacesConfigUtil;
import com.ibm.etools.webtools.codebehind.java.JavaLocationGenerator;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.java.refactoring.changes.MovePageCodeChange;
import com.ibm.etools.webtools.codebehind.java.refactoring.changes.RenamePageCodeReferencesChange;
import com.ibm.etools.webtools.codebehind.java.refactoring.changes.UpdateFacesMetadataChange;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class PageCodeRefactoringUtil {
    private PageCodeRefactoringUtil() {
    }

    public static IPath legalizePath(IPath jsfPath) {
        Path mangledPath = new Path("");
        int i = 0;
        while (i < jsfPath.segmentCount()) {
            String segment = jsfPath.segment(i);
            mangledPath = mangledPath.append(JavaCodeUtil.legalizeJavaIdentifier((String)segment));
            ++i;
        }
        return mangledPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Change renameJSP(IFile renamedFile, IFile toFile) {
        CompositeChange change = null;
        IModelManager manager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            try {
                Change updateMeta;
                model = manager.getModelForRead(renamedFile);
                IDOMDocument xmldoc = ((IDOMModel)model).getDocument();
                IFile pageCode = CodeBehindUtil.getPageCodeFile((IDOMDocument)xmldoc);
                if (pageCode == null) return change;
                IVirtualComponent component = ComponentCore.createComponent((IProject)toFile.getProject());
                IPath newPath = JavaCodeUtil.getWebContentRelativePath((IVirtualComponent)component, (IPath)toFile.getFullPath());
                newPath = PageCodeRefactoringUtil.legalizePath(newPath);
                IFolder destination = JavaLocationGenerator.getDestinationFolder(toFile.getProject(), newPath);
                if (destination == null) return change;
                change = new CompositeChange(NLS.bind((String)Messages.PageCodeRefactoringUtil_0, (Object)renamedFile.getProjectRelativePath().toString()));
                String newName = toFile.getName();
                int i = newName.lastIndexOf(46);
                if (i >= 0) {
                    newName = newName.substring(0, i);
                }
                newName = JavaCodeUtil.capitalizeFirst((String)newName);
                newName = JavaCodeUtil.legalizeJavaIdentifier((String)newName);
                newName = String.valueOf(newName) + ".java";
                change.add((Change)new MovePageCodeChange(pageCode, destination, newName));
                IJavaElement e = (IJavaElement)pageCode.getAdapter(IJavaElement.class);
                if (e == null || e.getElementType() != 5) return change;
                ICompilationUnit cu = (ICompilationUnit)e;
                newPath = newPath.append(newName);
                Change updateRef = PageCodeRefactoringUtil.updateRefs(renamedFile.getProject(), (IResource)toFile, newPath, cu);
                if (updateRef != null) {
                    change.add(updateRef);
                }
                if ((updateMeta = PageCodeRefactoringUtil.updateMetadata(renamedFile, toFile, destination, cu)) == null) return change;
                change.add(updateMeta);
                return change;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (model == null) return change;
                model.releaseFromRead();
                return change;
            }
            catch (CoreException e) {
                e.printStackTrace();
                if (model == null) return change;
                model.releaseFromRead();
                return change;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static Change updateMetadata(IFile renamedFile, IFile toFile, IFolder destination, ICompilationUnit cu) {
        UpdateFacesMetadataChange change = null;
        IPath apath = renamedFile.getFullPath().removeFileExtension();
        if (apath != null) {
            IFile newSpot;
            String name = toFile.getFullPath().removeFileExtension().lastSegment();
            name = JavaCodeUtil.legalizeJavaIdentifier((String)name);
            if ((name = JavaCodeUtil.capitalizeFirst((String)name)) != null && (newSpot = destination.getFile(name)) != null) {
                Object oldPath = null;
                try {
                    IFile file = (IFile)cu.getUnderlyingResource();
                    oldPath = file != null ? file.getProjectRelativePath().makeAbsolute() : new Path("");
                    IPath thePath = newSpot.getProjectRelativePath().makeAbsolute().addFileExtension("java");
                    if (!oldPath.equals((Object)thePath)) {
                        change = new UpdateFacesMetadataChange(toFile, (IPath)oldPath, thePath);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        return change;
    }

    public static Change updateRefs(IProject project, IResource sourceResource, IPath newPath, ICompilationUnit cu) {
        String oldName;
        RenamePageCodeReferencesChange change = null;
        IType type = cu.findPrimaryType();
        if (type != null && FacesConfigUtil.isManagedBeanClass(project, sourceResource, oldName = type.getFullyQualifiedName())) {
            String newTypeName;
            IPackageFragment d = JavaLocationGenerator.getDestinationPackage(project, newPath.removeLastSegments(1), false);
            String newPackName = d.getElementName();
            if (newPackName == null) {
                newPackName = "";
            }
            String string = newTypeName = newPackName.length() == 0 ? type.getElementName() : String.valueOf(newPackName) + "." + newPath.removeFileExtension().lastSegment();
            if (!oldName.equals(newTypeName)) {
                change = new RenamePageCodeReferencesChange(project, sourceResource, oldName, newTypeName);
            }
        }
        return change;
    }

    public static Change updateRefsFullPath(IProject project, IResource sourceResource, IPath newPath, ICompilationUnit cu) {
        String oldName;
        RenamePageCodeReferencesChange change = null;
        IType type = cu.findPrimaryType();
        if (type != null && FacesConfigUtil.isManagedBeanClass(project, sourceResource, oldName = type.getFullyQualifiedName())) {
            String newTypeName;
            IPackageFragment d = JavaLocationGenerator.getDestinationPackageFullPath(project, newPath.removeLastSegments(1), false);
            String newPackName = d.getElementName();
            if (newPackName == null) {
                newPackName = "";
            }
            String string = newTypeName = newPackName.length() == 0 ? type.getElementName() : String.valueOf(newPackName) + "." + newPath.removeFileExtension().lastSegment();
            if (!oldName.equals(newTypeName)) {
                change = new RenamePageCodeReferencesChange(project, sourceResource, oldName, newTypeName);
            }
        }
        return change;
    }
}

