/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.refactoring;

import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.java.JavaCodeBehindUtil;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.java.refactoring.PageCodeRefactoringUtil;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class FacesRenameParticipant
extends RenameParticipant {
    private Object renamedObject;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RenameArguments arguments = this.getArguments();
        String originalNewName = arguments.getNewName();
        String newName = originalNewName;
        int i = newName.lastIndexOf(46);
        if (i >= 0) {
            newName = newName.substring(0, i);
        }
        newName = JavaCodeUtil.legalizeJavaIdentifier((String)newName);
        newName = JavaCodeUtil.capitalizeFirst((String)newName);
        CompositeChange renameChange = new CompositeChange(Messages.FacesRenameParticipant_1);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.renamedObject);
        while (!list.isEmpty()) {
            CompositeChange containerChange;
            IJavaElement je;
            IContainer container;
            Object o;
            block14: {
                o = list.remove(0);
                if (!(o instanceof IAdaptable)) continue;
                IFile renamedFile = (IFile)((IAdaptable)o).getAdapter(IFile.class);
                if (renamedFile != null) {
                    IFile toFile = renamedFile.getParent().getFile((IPath)new Path(originalNewName));
                    try {
                        if (!JsfComponentUtil.isJsfPage((IFile)renamedFile) || !JsfComponentUtil.isJSP((IFile)toFile)) break block14;
                        IModelManager manager = StructuredModelManager.getModelManager();
                        IStructuredModel smodel = null;
                        try {
                            smodel = manager.getModelForRead(renamedFile);
                            IDOMDocument xmldoc = ((IDOMModel)smodel).getDocument();
                            ICBLanguage cbAdapter = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmldoc);
                            CBLanguageInfo cbInfo = cbAdapter.getCBInfo();
                            if (cbInfo.language.equalsIgnoreCase("java")) {
                                Change change;
                                IPath cbpath = JavaCodeBehindUtil.getCodebehindRelativePath(toFile.getProject(), cbInfo.location);
                                IVirtualComponent component = ComponentCore.createComponent((IProject)toFile.getProject());
                                IPath jsfPath = JavaCodeUtil.getWebContentRelativePath((IVirtualComponent)component, (IPath)renamedFile.getFullPath());
                                if (cbpath.equals((Object)(jsfPath = PageCodeRefactoringUtil.legalizePath(jsfPath))) && (change = PageCodeRefactoringUtil.renameJSP(renamedFile, toFile)) != null) {
                                    renameChange.add(change);
                                }
                            }
                        }
                        finally {
                            if (smodel != null) {
                                smodel.releaseFromRead();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((container = (IContainer)((IAdaptable)o).getAdapter(IContainer.class)) == null || (je = (IJavaElement)((IAdaptable)o).getAdapter(IJavaElement.class)) != null || (containerChange = this.processContainer(container, originalNewName)) == null) continue;
            Change[] changes = containerChange.getChildren();
            int j = 0;
            while (j < changes.length) {
                Change childChange = changes[j];
                containerChange.remove(childChange);
                ++j;
            }
            renameChange.addAll(changes);
        }
        if (renameChange.getChildren() == null || renameChange.getChildren().length == 0) {
            renameChange = null;
        }
        return renameChange;
    }

    public String getName() {
        return Messages.FacesRenameParticipant_0;
    }

    protected boolean initialize(Object element) {
        this.renamedObject = element;
        return true;
    }

    protected CompositeChange processContainer(IContainer container, String newContainerName) throws CoreException {
        CompositeChange ret = new CompositeChange("");
        ArrayList<IResource> children = new ArrayList<IResource>(Arrays.asList(container.members()));
        while (!children.isEmpty()) {
            IResource resource = (IResource)children.remove(0);
            if (resource.getType() == 1) {
                IFile renamedFile = (IFile)resource;
                if (!JsfComponentUtil.isJsfPage((IFile)renamedFile)) continue;
                IPath path = renamedFile.getFullPath().removeFirstSegments(renamedFile.getFullPath().matchingFirstSegments(container.getFullPath()));
                IFolder destinationContainer = container.getParent().getFolder((IPath)new Path(newContainerName));
                IFile toFile = destinationContainer.getFile(path);
                Change renameChange = PageCodeRefactoringUtil.renameJSP(renamedFile, toFile);
                if (renameChange == null) continue;
                ret.add(renameChange);
                continue;
            }
            if (resource.getType() != 2) continue;
            children.addAll(Arrays.asList(((IFolder)resource).members()));
        }
        if (ret.getChildren() == null || ret.getChildren().length == 0) {
            ret = null;
        }
        return ret;
    }
}

