/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.qev;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.events.api.AbstractJsfEvent;
import com.ibm.etools.qev.edit.IExtendedDesignEditor;
import com.ibm.etools.qev.model.impl.AbstractDOMEventUpdater;
import com.ibm.etools.qev.model.impl.ITagEvent;
import com.ibm.etools.qev.registry.EventDefinition;
import com.ibm.etools.qev.view.QEVView;
import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.java.JavaCodeBehindPlugin;
import com.ibm.etools.webtools.codebehind.java.PageCodeDocletSupport;
import com.ibm.etools.webtools.codebehind.java.qev.JavaBaseEvent;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.IJavaCommand;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.CreateMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.DeleteMethodCommand;
import com.ibm.etools.webtools.javamodel.commands.JavaCommand;
import com.ibm.etools.webtools.javamodel.tasks.ExecuteSingleJavaCommandTask;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class JavaEventUpdater
extends AbstractDOMEventUpdater {
    public JavaEventUpdater(IExtendedDesignEditor editor) {
        super(editor);
    }

    protected void create(ITagEvent tagEvent, Element tag, EventDefinition eventDef, String newEventScript, IStructuredModel model) {
        String newScript = null;
        if (newEventScript.length() == 0) {
            JavaBaseEvent jsfTagEvent = (JavaBaseEvent)tagEvent;
            newScript = jsfTagEvent.getInitialContents();
        } else {
            newScript = newEventScript;
        }
        this.createMethod(tagEvent, eventDef, newScript, model);
        Element el = (Element)tagEvent.getNode();
        String beanName = JavaCodeBehindPlugin.getCodeBehindBeanName((IDOMDocument)tag.getOwnerDocument());
        String methodName = tagEvent.getFunctionName();
        JavaBaseEvent jsfTagEvent = (JavaBaseEvent)tagEvent;
        String refAttribute = jsfTagEvent.getDOMAttribute();
        el.setAttribute(refAttribute, BindingUtil.makeVbl((String)(String.valueOf(beanName) + "." + methodName)));
    }

    private void createMethod(ITagEvent tagEvent, EventDefinition eventDef, String newEventScript, IStructuredModel s_model) {
        IDOMDocument xmlDoc = (IDOMDocument)tagEvent.getNode().getOwnerDocument();
        ICBLanguage language = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
        CBLanguageInfo cbInfo = language.getCBInfo();
        IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
        JavaModel model = JavaModelManager.getInstance().getModel("codebehind", jspFile.getProject(), cbInfo.location);
        JavaBaseEvent jsfTagEvent = (JavaBaseEvent)tagEvent;
        String methodNameHint = jsfTagEvent.getMethodNameHint();
        CreateMethodCommand createCmd = new CreateMethodCommand();
        PageCodeDocletSupport.addActionDoclet((IJavaCommand)createCmd);
        createCmd.setIdentifier(methodNameHint);
        createCmd.setModifier("public");
        createCmd.setReturnType(jsfTagEvent.getReturnType());
        createCmd.setParameters(jsfTagEvent.getParameterTypes());
        createCmd.setParameterNames(jsfTagEvent.getParameterNames());
        createCmd.setContents(newEventScript);
        if (jsfTagEvent.getThrowsClause() != null) {
            createCmd.setThrowsClause(jsfTagEvent.getThrowsClause());
        }
        ExecuteSingleJavaCommandTask task = new ExecuteSingleJavaCommandTask((JavaCommand)createCmd);
        try {
            QEVView view = QEVView.getViewInstance();
            if (view != null) {
                view.getEditManager().setIgnoreOneCycle(true);
            }
            model.runBlockingUIJavaTaskWithBusyIndicatorContext((AbstractJavaModelTask)task);
        }
        finally {
            model.release();
        }
        String methodName = createCmd.getActualIdentifer();
        tagEvent.setFunctionName(methodName);
    }

    protected void remove(ITagEvent tagEvent, Element tag, EventDefinition eventDef) {
        this.removeMethod(tagEvent);
        AbstractJsfEvent jsfEvent = (AbstractJsfEvent)tagEvent;
        jsfEvent.removeEventBinding();
        jsfEvent.setFunctionName(null);
        jsfEvent.setScripted(false);
    }

    private void removeMethod(ITagEvent tagEvent) {
        String methodName = tagEvent.getFunctionName();
        IDOMDocument xmlDoc = (IDOMDocument)tagEvent.getNode().getOwnerDocument();
        ICBLanguage language = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
        CBLanguageInfo cbInfo = language.getCBInfo();
        IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
        JavaModel model = JavaModelManager.getInstance().getModel("codebehind", jspFile.getProject(), cbInfo.location);
        JavaBaseEvent jsfTagEvent = (JavaBaseEvent)tagEvent;
        DeleteMethodCommand deleteCmd = new DeleteMethodCommand();
        deleteCmd.setIdentifier(methodName);
        deleteCmd.setParameters(jsfTagEvent.getParameterTypes());
        try {
            model.runBackgroundJavaTaskAsJob((AbstractJavaModelTask)new ExecuteSingleJavaCommandTask((JavaCommand)deleteCmd), null);
        }
        finally {
            model.release();
        }
    }

    protected void update(ITagEvent tagEvent, Element tag, EventDefinition eventDef, String newEventScript, IStructuredModel model) {
        IDOMNode node;
        QEVView eview = QEVView.getViewInstance();
        if (eview != null && eview.isQEVDirty() && (node = tagEvent.getNode()) != null) {
            IDOMModel xmlmodel;
            block7: {
                try {
                    ICompilationUnit cUnit;
                    JavaBaseEvent jsfTagEvent = (JavaBaseEvent)tagEvent;
                    IFile beanFile = jsfTagEvent.getCodeBehindBeanIFile();
                    if (beanFile == null || !beanFile.exists() || (cUnit = JavaCore.createCompilationUnitFrom((IFile)beanFile)) == null) break block7;
                    try {
                        if (!cUnit.isConsistent()) {
                            cUnit.reconcile(0, false, null, null);
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((xmlmodel = node.getModel()) != null) {
                xmlmodel.setDirtyState(true);
            }
        }
    }
}

