/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.qev;

import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.events.api.AbstractJsfEvent;
import com.ibm.etools.qev.EventsConstants;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.CreateMethodMarkerCommand;
import com.ibm.etools.webtools.javamodel.commands.JavaCommand;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.javamodel.tasks.ExecuteSingleJavaCommandTask;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.Position;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public abstract class JavaBaseEvent
extends AbstractJsfEvent {
    private ILink targetLink;

    public boolean checkLink(ILink link) {
        String attribute = link.getParameter("attrname");
        return attribute != null && attribute.equals(this.getDOMAttribute());
    }

    public void doPostEditorOpen(IEditorPart editor) {
        IMarker marker;
        if (editor != null && (marker = this.getEventSourceMarker()) != null) {
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        }
    }

    public void doPreEditorOpen() {
    }

    public String getActualMethodName() {
        int index;
        String actionRef = ((IDOMElement)this.getNode()).getAttribute(this.getDOMAttribute());
        if (actionRef != null && actionRef.length() > 0 && (index = (actionRef = BindingUtil.removeVbl((String)actionRef)).lastIndexOf(".")) > -1 && index != actionRef.length()) {
            return actionRef.substring(index + 1);
        }
        return null;
    }

    public IFile getCodeBehindBeanIFile() {
        ILink javaMethod = this.getTargetLink();
        if (javaMethod != null) {
            LinkNode javafile = javaMethod.getContainer();
            if (javafile == null) {
                return null;
            }
            return (IFile)javafile.getResource();
        }
        return null;
    }

    public abstract String getDOMAttribute();

    public IEditorInput getEditorInput() {
        this.targetLink = null;
        IFile file = this.getCodeBehindBeanIFile();
        if (file != null) {
            return new FileEditorInput(file);
        }
        return super.getEditorInput();
    }

    private IMarker getEventSourceMarker() {
        IDOMDocument xmlDoc = (IDOMDocument)this.getNode().getOwnerDocument();
        IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
        IPath beanPath = null;
        IFile beanFile = this.getCodeBehindBeanIFile();
        if (beanFile == null) {
            ICBLanguage language = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
            CBLanguageInfo cbInfo = language.getCBInfo();
            beanPath = cbInfo.location;
        } else {
            beanPath = beanFile.getProjectRelativePath();
        }
        JavaModel model = JavaModelManager.getInstance().getModel("codebehind", jspFile.getProject(), beanPath);
        CreateMethodMarkerCommand createCmd = new CreateMethodMarkerCommand();
        createCmd.setIdentifier(this.getActualMethodName());
        createCmd.setParameters(this.getParameterTypes());
        createCmd.setParameterNames(this.getParameterNames());
        try {
            model.runBlockingUIJavaTaskWithBusyIndicatorContext((AbstractJavaModelTask)new ExecuteSingleJavaCommandTask((JavaCommand)createCmd));
        }
        finally {
            model.release();
        }
        return createCmd.getMethodMarker();
    }

    public abstract String getInitialContents();

    protected String getManagedBeanForNode() {
        int index;
        IDOMElement element;
        String methodRef;
        String managedBean = null;
        IDOMNode node = this.getNode();
        if (node != null && node.getNodeType() == 1 && (methodRef = (element = (IDOMElement)node).getAttribute(this.getDOMAttribute())) != null && !methodRef.equals("") && (index = methodRef.lastIndexOf(".")) > -1 && index != methodRef.length()) {
            String beanName = methodRef.substring(0, index);
            managedBean = beanName.startsWith("#{") ? beanName.substring(2) : beanName;
        }
        return managedBean;
    }

    private String getMethodContents() {
        String methodName = this.getActualMethodName();
        if (methodName != null) {
            IDOMDocument xmlDoc = (IDOMDocument)this.getNode().getOwnerDocument();
            IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
            IPath beanPath = null;
            IFile beanFile = this.getCodeBehindBeanIFile();
            if (beanFile == null) {
                ICBLanguage language = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
                CBLanguageInfo cbInfo = language.getCBInfo();
                beanPath = cbInfo.location;
            } else {
                beanPath = beanFile.getProjectRelativePath();
            }
            JavaModel model = JavaModelManager.getInstance().getModel("codebehind", jspFile.getProject(), beanPath);
            ReadMethodCommand readCmd = new ReadMethodCommand();
            readCmd.setIdentifier(methodName);
            readCmd.setParameters(this.getParameterTypes());
            readCmd.setParameterNames(this.getParameterNames());
            try {
                model.runBlockingUIJavaTaskWithBusyIndicatorContext((AbstractJavaModelTask)new ExecuteSingleJavaCommandTask((JavaCommand)readCmd));
            }
            finally {
                model.release();
            }
            return readCmd.getContents();
        }
        return null;
    }

    protected abstract String getMethodHint(String var1);

    public String getMethodNameHint() {
        Element elem = (Element)this.getNode();
        String hint = elem.getAttribute("id");
        if (hint == null || hint.length() < 1) {
            hint = elem.getLocalName();
        }
        String firstChar = hint.substring(0, 1);
        hint = String.valueOf(firstChar.toUpperCase()) + hint.substring(1);
        return this.getMethodHint(hint);
    }

    public abstract String[] getParameterNames();

    public abstract String[] getParameterTypes();

    public abstract String getReturnType();

    public Position getScriptPosition() {
        IMarker marker;
        Position result = null;
        if (this.isInsideCodebehindBean(this.getNode()) && (marker = this.getEventSourceMarker()) != null) {
            int offset = MarkerUtilities.getCharStart((IMarker)marker);
            int length = marker.getAttribute("length", 0);
            result = new Position(offset, length);
        }
        return result;
    }

    public ILink getTargetLink() {
        if (this.targetLink == null) {
            IDOMNode node = this.getNode();
            IDOMDocument xmlDoc = (IDOMDocument)node.getOwnerDocument();
            IFile jspPage = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
            LinkNode fileNode = ReferenceManager.getReferenceManager().getLinkNode(jspPage);
            Collection<ILink> links = fileNode.getLinks(ReferenceManager.getReferenceManager().getLinkType("jsf.action.link"), SpecializedType.Depth.ZERO, null);
            TextRange range = new TextRange(node.getStartOffset(), node.getEndOffset() - node.getStartOffset(), 0);
            if (!(links = this.rangeFilter(links, range)).isEmpty()) {
                for (ILink link : links) {
                    IResolvedReference rr;
                    if (!this.checkLink(link)) continue;
                    Collection rrs = link.resolveReference("jdt.reference", null);
                    if (rrs.isEmpty() || (rr = (IResolvedReference)rrs.iterator().next()).getTarget() == null) break;
                    this.targetLink = rr.getTarget();
                    break;
                }
            }
        }
        return this.targetLink;
    }

    public String getThrowsClause() {
        return null;
    }

    public boolean isEditableManagedBean() {
        return this.isInsideCodebehindBean(this.getNode()) && !super.isInsideCodebehindBean(this.getNode());
    }

    protected boolean isInsideCodebehindBean(IDOMNode element) {
        IFile file;
        boolean isInside = super.isInsideCodebehindBean(element);
        if (!isInside && (file = this.getCodeBehindBeanIFile()) != null && file.exists()) {
            isInside = true;
        }
        return isInside;
    }

    public boolean isScripted() {
        String attribute = ((IDOMElement)this.getNode()).getAttribute(this.getDOMAttribute());
        return attribute != null;
    }

    private Collection<ILink> rangeFilter(Collection<ILink> links, TextRange container) {
        Iterator<ILink> iterator = links.iterator();
        while (iterator.hasNext()) {
            ILink link = iterator.next();
            if (container.contains(link.getContextLocation())) continue;
            iterator.remove();
        }
        return links;
    }

    public void removeEventBinding() {
        Element el = (Element)this.getNode();
        el.removeAttribute(this.getDOMAttribute());
    }

    protected String retrieveEventContents(IDOMNode node) {
        String eventContents = null;
        if (!this.isScripted()) {
            eventContents = this.getInitialContents();
        } else if (this.isInsideCodebehindBean(node)) {
            eventContents = this.getMethodContents();
        } else {
            String actionRef = ((IDOMElement)this.getNode()).getAttribute(this.getDOMAttribute());
            if (actionRef != null) {
                eventContents = actionRef.equals("") ? EventsConstants.PROBLEMS_ENCOUNTERED_WITH_THIS_SCRIPT : (!actionRef.startsWith("#{") ? NLS.bind((String)Messages.JavaBaseEvent_Static_String, (Object)actionRef) : EventsConstants.PROBLEMS_ENCOUNTERED_WITH_THIS_SCRIPT);
                this.setReadOnly(true);
            }
        }
        if (eventContents == null) {
            eventContents = EventsConstants.PROBLEMS_ENCOUNTERED_WITH_THIS_SCRIPT;
            this.setReadOnly(true);
        }
        return eventContents;
    }
}

