/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.internal.migration;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.references.search.DefaultSearchRequestor;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchPattern;
import com.ibm.etools.references.search.SearchRequestor;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.search.SearchType;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class SourceFolderLinkMigrationOperation
extends AbstractDataModelOperation {
    private static final String OLD_JAVA_SOURCE_FOLDER = "JavaSource";

    private static String getCurrentSourceFolderName(IProject project) {
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources != null && sources.length > 0) {
            IPackageFragmentRoot root = sources[0];
            IResource res = root.getResource();
            return res.getName();
        }
        return null;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
        IStatus status = OK_STATUS;
        try {
            IProject proj;
            String projName = (String)this.model.getProperty("IProjectCreationPropertiesNew.PROJECT_NAME");
            if (projName != null && (proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName)) != null) {
                try {
                    this.migrate(proj);
                }
                catch (Exception e) {
                    status = new Status(4, "com.ibm.etools.webtools.codebehind.java", 4, Messages.SourceFolderLinkMigrationOperation_0, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public boolean migrate(IProject project) {
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            SourceFolderLinkMigrationJob runnable = new SourceFolderLinkMigrationJob("Source Folder Link Migration Job", project);
            runnable.setSystem(true);
            runnable.schedule();
        }
        return true;
    }

    static class SourceFolderLinkMigrationJob
    extends Job {
        private final IProject project;

        public SourceFolderLinkMigrationJob(String name, IProject project) {
            super(name);
            this.project = project;
        }

        public IStatus run(IProgressMonitor monitor) {
            String currentSourceName = SourceFolderLinkMigrationOperation.getCurrentSourceFolderName(this.project);
            if (currentSourceName == null || currentSourceName.equals(SourceFolderLinkMigrationOperation.OLD_JAVA_SOURCE_FOLDER)) {
                return Status.OK_STATUS;
            }
            SearchPattern filePattern = SearchPattern.createPattern((String)"jsf.pagecode", (SearchType)SearchType.BY_TYPE, (IReferenceElement.ElementType)IReferenceElement.ElementType.LINK, (int)0);
            DefaultSearchRequestor requestor = new DefaultSearchRequestor();
            SearchScope scope = SearchEngine.createSearchScope((IResource[])new IResource[]{this.project});
            new SearchEngine().search(filePattern, scope, (SearchRequestor)requestor, monitor);
            Set matches = requestor.getMatches();
            if (matches != null && matches.size() > 0) {
                RefactoringSupport support = new RefactoringSupport();
                for (ILink link : matches) {
                    String originalUriValue = link.getLinkText();
                    if (originalUriValue.indexOf("/JavaSource") == 0) {
                        String newValue = "/" + currentSourceName + originalUriValue.substring("/JavaSource".length());
                        Collection refs = link.resolveReference("web.reference.workspacePath", monitor);
                        for (IResolvedReference resolvedReference : refs) {
                            newValue = this.project.getFullPath().makeAbsolute().append(newValue).toString();
                            HashMap<String, String> targetDescription = new HashMap<String, String>();
                            targetDescription.put("web.ref.abs.path.id", newValue);
                            support.createEdits(resolvedReference, targetDescription);
                        }
                        continue;
                    }
                    if (originalUriValue.indexOf("/" + currentSourceName) != 0) continue;
                    return Status.OK_STATUS;
                }
                this.saveChanges(monitor, support);
            }
            return Status.OK_STATUS;
        }

        private void saveChanges(IProgressMonitor monitor, RefactoringSupport support) {
            Change change = support.createChange("Update references");
            if (change != null) {
                Object[] obs = change.getAffectedObjects();
                ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
                Object[] objectArray = obs;
                int n = obs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof IResource) {
                        rules.add(ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)o));
                    }
                    ++n2;
                }
                ISchedulingRule schedulingRule = MultiRule.combine((ISchedulingRule[])rules.toArray(new ISchedulingRule[rules.size()]));
                change.initializeValidationData(monitor);
                PerformChangeOperation op = new PerformChangeOperation(change);
                op.setUndoManager(RefactoringCore.getUndoManager(), "Fix Broken Links");
                op.setSchedulingRule(schedulingRule);
                try {
                    op.run(monitor);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    static class StopMigratingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        StopMigratingException() {
        }
    }
}

