/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java.extensions;

import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webtools.codebehind.api.CodeBehindPreferences;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.javamodel.JavaModelPlugin;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.tasks.PrepareModelTask;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class PrepareCBModelTask
extends PrepareModelTask {
    public static boolean isMinimumFacetDefinedOnProject(IProject project, String facetName, String versionExpression) {
        boolean isDefined;
        block5: {
            isDefined = ProjectFacetsManager.isProjectFacetDefined((String)facetName);
            if (isDefined) {
                isDefined = false;
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetName);
                    if (facetedProject == null || facet == null) break block5;
                    Set versions = facet.getVersions(versionExpression);
                    for (IProjectFacetVersion projectFacetVersion : versions) {
                        isDefined = facetedProject.hasProjectFacet(projectFacetVersion);
                        if (!isDefined) {
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    isDefined = false;
                }
            }
        }
        return isDefined;
    }

    protected void addImportsToNewType(ICompilationUnit workingCopy, IProgressMonitor monitor) {
        super.addImportsToNewType(workingCopy, monitor);
        if (workingCopy != null) {
            IPackageDeclaration cbPack = workingCopy.getPackageDeclaration(CodeBehindPreferences.getCodebehindPackagePrefix((IProject)workingCopy.getJavaProject().getProject()));
            IJavaProject javaProject = workingCopy.getJavaProject();
            String codebehindBaseType = CodeBehindPreferences.getCodebehindQualifiedType((IProject)javaProject.getProject());
            if (!cbPack.exists()) {
                try {
                    IType type;
                    if (javaProject != null && (type = javaProject.findType(codebehindBaseType)) == null && !"pagecode.PageCodeBase".equals(codebehindBaseType) && (type = javaProject.findType("pagecode.PageCodeBase")) != null) {
                        codebehindBaseType = "pagecode.PageCodeBase";
                    }
                    workingCopy.createImport(codebehindBaseType, null, monitor);
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    IType type;
                    if (javaProject != null && (type = javaProject.findType(codebehindBaseType)) == null && !"pagecode.PageCodeBase".equals(codebehindBaseType) && (type = javaProject.findType("pagecode.PageCodeBase")) != null) {
                        workingCopy.createImport("pagecode.PageCodeBase", null, monitor);
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected IType createPageCodeBaseType(JavaModel context, IProgressMonitor monitor) {
        IType cbbaseType = null;
        try {
            String codebehindQualifiedType = CodeBehindPreferences.getCodebehindQualifiedType((IProject)context.getProject());
            cbbaseType = this.getJavaProject(context).findType(codebehindQualifiedType);
            if (cbbaseType == null && !"pagecode.PageCodeBase".equals(codebehindQualifiedType)) {
                cbbaseType = this.getJavaProject(context).findType("pagecode.PageCodeBase");
            }
            if (cbbaseType == null || !cbbaseType.exists() || cbbaseType.getJavaProject().getProject() != context.getProject()) {
                monitor.subTask(Messages.PrepareCBModelTask_0);
                IPackageFragmentRoot root = this.getPackageFragmentRoot(context);
                if (root != null) {
                    String cbPathPrefix = CodeBehindPreferences.getCodebehindPackagePrefix((IProject)context.getProject());
                    String cbBaseName = String.valueOf(CodeBehindPreferences.getCodebehindBaseClass()) + ".java";
                    IPath javaPath = root.getPath().append(cbPathPrefix).append(cbBaseName);
                    if (javaPath.segment(0).equals(context.getProject().getName())) {
                        javaPath = javaPath.removeFirstSegments(1);
                    }
                    if (JavaModelPlugin.handleValidateEdit((IProject)context.getProject(), (IPath)javaPath, null)) {
                        try {
                            String jsfVersion;
                            String codeBehindBase = null;
                            IPackageFragment pack = root.createPackageFragment(cbPathPrefix, false, monitor);
                            codeBehindBase = PrepareCBModelTask.isMinimumFacetDefinedOnProject(context.getProject(), "jst.java", "[5.0") ? ((jsfVersion = JsfProjectUtil.getJsfFacetVersion((IProject)context.getProject())) != null && jsfVersion.equals("1.2") ? this.readTemplateFile("com/ibm/etools/webtools/codebehind/java/extensions/PageCodeBase12.template") : this.readTemplateFile("com/ibm/etools/webtools/codebehind/java/extensions/PageCodeBaseJava5.template")) : this.readTemplateFile("com/ibm/etools/webtools/codebehind/java/extensions/PageCodeBase.template");
                            codeBehindBase = this.replaceTemplateValues(context.getProject(), codeBehindBase, CodeBehindPreferences.getCodebehindBaseClass());
                            ICompilationUnit compUnit = pack.createCompilationUnit(cbBaseName, codeBehindBase, true, monitor);
                            cbbaseType = compUnit.findPrimaryType();
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return cbbaseType;
    }

    protected IType createType(JavaModel context, IProgressMonitor monitor) {
        IType type1 = super.createType(context, monitor);
        this.createPageCodeBaseType(context, monitor);
        return type1;
    }

    protected String getCUTemplate() {
        return this.readTemplateFile("com/ibm/etools/webtools/codebehind/java/extensions/PageCode.template");
    }

    protected String replaceTemplateValues(IProject project, String template, String typeName) {
        String contents = super.replaceTemplateValues(project, template, typeName);
        contents = JavaCodeUtil.replace((String)contents, (String)"${PageCodeBaseTypeName}", (String)CodeBehindPreferences.getCodebehindBaseClass());
        contents = JavaCodeUtil.replace((String)contents, (String)"${PageCodeBasePackage}", (String)CodeBehindPreferences.getCodebehindPackagePrefix((IProject)project));
        return contents;
    }
}

