/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java;

import com.ibm.etools.webtools.codebehind.api.CodeBehindPreferences;
import com.ibm.etools.webtools.codebehind.api.ILocationGenerator;
import com.ibm.etools.webtools.codebehind.java.CreateManagedBeanEntryTask;
import com.ibm.etools.webtools.codebehind.java.JavaCodeBehindPlugin;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class JavaLocationGenerator
implements ILocationGenerator {
    public static IFolder getDestinationFolder(IProject project, IPath newPath) {
        IFolder folder;
        IPackageFragmentRoot root;
        IFolder ret = null;
        List list = JemProjectUtilities.getSourceContainers((IProject)project.getProject());
        if (list.size() >= 1 && (root = (IPackageFragmentRoot)JavaCore.create((IFolder)(folder = (IFolder)list.get(0)))) != null) {
            String newPathString = "";
            String[] segments = newPath.segments();
            int i = 0;
            while (i < segments.length) {
                String segment = segments[i];
                if (segment.length() > 0) {
                    newPathString = String.valueOf(newPathString) + JavaCodeUtil.legalizeJavaIdentifier((String)segment);
                }
                if (i < segments.length - 1) {
                    newPathString = String.valueOf(newPathString) + "/";
                }
                ++i;
            }
            String name = null;
            name = newPathString.length() > 0 ? String.valueOf(CodeBehindPreferences.getCodebehindPackagePrefix((IProject)project).replace('.', '/')) + "/" + newPathString : CodeBehindPreferences.getCodebehindPackagePrefix((IProject)project).replace('.', '/');
            ret = folder.getFolder((IPath)new Path(name));
        }
        return ret;
    }

    public static IFolder getDestinationFolderFullPath(IProject project, IPath newPath) {
        IFolder folder;
        IPackageFragmentRoot root;
        IFolder ret = null;
        List list = JemProjectUtilities.getSourceContainers((IProject)project.getProject());
        if (list.size() >= 1 && (root = (IPackageFragmentRoot)JavaCore.create((IFolder)(folder = (IFolder)list.get(0)))) != null) {
            String newPathString = "";
            String[] segments = newPath.segments();
            int i = 0;
            while (i < segments.length) {
                String segment = segments[i];
                if (segment.length() > 0) {
                    newPathString = String.valueOf(newPathString) + JavaCodeUtil.legalizeJavaIdentifier((String)segment);
                }
                if (i < segments.length - 1) {
                    newPathString = String.valueOf(newPathString) + "/";
                }
                ++i;
            }
            String name = newPathString;
            if (newPathString.length() == 0) {
                return folder;
            }
            ret = folder.getFolder((IPath)new Path(name));
        }
        return ret;
    }

    public static IPackageFragment getDestinationPackage(IProject project, IPath newPath) {
        return JavaLocationGenerator.getDestinationPackage(project, newPath, true);
    }

    public static IPackageFragment getDestinationPackage(IProject project, IPath newPath, boolean create) {
        IPackageFragmentRoot root;
        IPackageFragment ret = null;
        IFolder result = JavaLocationGenerator.getDestinationFolder(project, newPath);
        if (result != null && (ret = (IPackageFragment)JavaCore.create((IFolder)result)) != null && create && (root = (IPackageFragmentRoot)ret.getParent()) != null) {
            try {
                ret = root.createPackageFragment(ret.getElementName(), true, null);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static IPackageFragment getDestinationPackageFullPath(IProject project, IPath newPath, boolean create) {
        IPackageFragmentRoot root;
        IPackageFragment ret = null;
        IFolder result = JavaLocationGenerator.getDestinationFolderFullPath(project, newPath);
        if (result != null && (ret = (IPackageFragment)JavaCore.create((IFolder)result)) != null && create && (root = (IPackageFragmentRoot)ret.getParent()) != null) {
            try {
                ret = root.createPackageFragment(ret.getElementName(), true, null);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public void createCodebehindFile(IResource sourceResource, IPath location) {
        JavaModel model = JavaModelManager.getInstance().getModel("codebehind", sourceResource.getProject(), location);
        try {
            model.saveNow(null);
        }
        finally {
            model.release();
        }
        this.createManagedBeanEntry(sourceResource, location);
    }

    public void createManagedBeanEntry(IResource sourceResource, IPath location) {
        JavaModel model = JavaModelManager.getInstance().getModel("codebehind", sourceResource.getProject(), location);
        try {
            model.runBlockingJavaTask((AbstractJavaModelTask)new CreateManagedBeanEntryTask(sourceResource), null, null);
        }
        finally {
            model.release();
        }
    }

    public IFile getCodeBehindFileForNode(IDOMNode element) {
        return null;
    }

    public IPath getLocationForJSP(IFile jspFile) {
        String packagePath = this.getPackageName(jspFile.getProject(), jspFile, CodeBehindPreferences.getCodebehindPackagePrefix((IProject)jspFile.getProject())).replace('.', '/');
        int i = packagePath.lastIndexOf(47);
        if (i != -1) {
            String packName = packagePath.substring(0, i);
            String fName = packagePath.substring(i + 1);
            if ((fName = JavaCodeUtil.capitalizeFirst((String)fName)).equals("List")) {
                fName = JavaCodeUtil.increment((String)fName);
            }
            packagePath = String.valueOf(packName) + '/' + fName;
        }
        IPath path = null;
        while (path == null) {
            IFile file = this.getSourceFolder(jspFile.getProject()).getFile(String.valueOf(packagePath) + ".java");
            try {
                file.refreshLocal(0, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (file.exists()) {
                packagePath = JavaCodeUtil.increment((String)packagePath);
                continue;
            }
            path = file.getProjectRelativePath().makeAbsolute();
        }
        return path;
    }

    public String getManagedBeanName(IDOMDocument document) {
        return JavaCodeBehindPlugin.getCodeBehindBeanName(document);
    }

    private String getPackageName(IProject project, IFile jspFile, String prefix) {
        IContainer webcontentFolder;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder folder = component.getRootFolder();
        if (folder != null && (webcontentFolder = folder.getUnderlyingFolder()) != null) {
            IPath webcontent = webcontentFolder.getFullPath();
            IPath cbpath = jspFile.getFullPath();
            cbpath = cbpath.removeFileExtension();
            cbpath = cbpath.removeFirstSegments(webcontent.matchingFirstSegments(cbpath));
            String typenamequalified = JavaCodeUtil.getPackageFromPath((IPath)cbpath, (IProject)project, (String)prefix);
            return typenamequalified;
        }
        return null;
    }

    private IFolder getSourceFolder(IProject project) {
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources == null || sources.length == 0) {
            return null;
        }
        IPackageFragmentRoot root = sources[0];
        IResource res = root.getResource();
        return (IFolder)res;
    }
}

