/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java;

import com.ibm.etools.webtools.codebehind.api.CodeBehindPreferences;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.java.FacesConfigUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.osgi.framework.BundleContext;

public class JavaCodeBehindPlugin
extends AbstractUIPlugin {
    private static JavaCodeBehindPlugin SINGLETON;

    public JavaCodeBehindPlugin() {
        SINGLETON = this;
    }

    public static String getCodeBehindBeanClassName(IDOMDocument xmlDoc) {
        ICompilationUnit cu;
        IFile pageCode;
        String beanName = null;
        String language = CodeBehindUtil.getCodebehindLanguage((IDOMDocument)xmlDoc);
        if ("java".equals(language) && (pageCode = CodeBehindUtil.getPageCodeFile((IDOMDocument)xmlDoc)) != null && (cu = JavaCore.createCompilationUnitFrom((IFile)pageCode)) != null) {
            IType type;
            String className = cu.getElementName();
            if (className != null) {
                className = className.substring(0, className.indexOf(46));
            }
            if ((type = cu.getType(className)) != null) {
                beanName = type.getFullyQualifiedName();
            }
        }
        return beanName;
    }

    public static String getCodeBehindBeanName(IDOMDocument xmlDoc) {
        String beanName = null;
        String fullyQualifiedName = JavaCodeBehindPlugin.getCodeBehindBeanClassName(xmlDoc);
        if (fullyQualifiedName != null) {
            IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
            beanName = FacesConfigUtil.managedBeanNameForClass(jspFile.getProject(), (IResource)jspFile, fullyQualifiedName);
        }
        return beanName;
    }

    public static JavaCodeBehindPlugin getDefault() {
        return SINGLETON;
    }

    public static final String getPluginID() {
        return JavaCodeBehindPlugin.getDefault().getBundle().getSymbolicName();
    }

    public Image getImage(String key) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            imageRegistry.put(key, this.getImageDescriptor(key));
            image = imageRegistry.get(key);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)this.getBundle().getEntry("icons/" + key + ".gif"));
        return imageDescriptor;
    }

    public JavaModel getSuperModel(IProject project) {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
        IType type = null;
        try {
            IFile codebehindbase;
            String codebehindQualifiedType = CodeBehindPreferences.getCodebehindQualifiedType((IProject)project);
            type = javaProject.findType(CodeBehindPreferences.getCodebehindQualifiedType((IProject)project));
            if (type == null && !"pagecode.PageCodeBase".equals(codebehindQualifiedType)) {
                type = javaProject.findType("pagecode.PageCodeBase");
            }
            if (type != null && (codebehindbase = (IFile)type.getUnderlyingResource()) != null) {
                IPath prjRelPath = codebehindbase.getProjectRelativePath().makeAbsolute();
                return JavaModelManager.getInstance().getModel("defaultjavamodel", project, prjRelPath);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }
}

