/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java;

import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.webtools.codebehind.api.CodeBehindPreferences;
import com.ibm.etools.webtools.codebehind.api.IJsfTagListener;
import com.ibm.etools.webtools.codebehind.java.CreateManagedBeanEntryTask;
import com.ibm.etools.webtools.codebehind.java.FacesConfigUtil;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.java.tasks.SyncXMLtoJavaTask;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.ReadMethodCommand;
import com.ibm.etools.webtools.javamodel.jobs.JavaModelJob;
import com.ibm.etools.webtools.javamodel.jobs.JavaModelTaskJob;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;

public class JavaCBTagListener
implements IJsfTagListener {
    private JavaModel model;
    Map xmlNodeJavaElementMap = new HashMap();
    SyncXMLtoJavaTask syncTask;
    JavaModelJob taskJob;

    public void addJSFComponentOnLoad(IDOMNode addedChild) {
    }

    public void dispose() {
        this.model.release();
        if (this.taskJob != null) {
            this.taskJob.cancel();
        }
    }

    public void elementChanged(List eventQueue, IDOMDocument document) {
        if (this.syncTask == null) {
            this.syncTask = new SyncXMLtoJavaTask(this.xmlNodeJavaElementMap, eventQueue, document);
            this.syncTask.setJavaModel(this.model);
            this.model.prepareCompilationUnitInBackground();
            this.taskJob = new JavaModelTaskJob(this.model, (AbstractJavaModelTask)this.syncTask);
        } else {
            this.syncTask.addEventsToQueue(eventQueue);
        }
        if (this.taskJob.getState() == 2 || this.taskJob.getState() == 1) {
            this.taskJob.cancel();
        }
        this.taskJob.schedule(1000L);
    }

    public void initialize(IFile file, IPath location, IDOMDocument doc) {
        this.model = JavaModelManager.getInstance().getModel("codebehind", file.getProject(), location);
        IPath loc = location.removeFirstSegments(1).removeFileExtension();
        String fullyQualifiedClass = loc.toString().replace('/', '.');
        if (!FacesConfigUtil.isManagedBeanClass(file.getProject(), (IResource)file, fullyQualifiedClass)) {
            this.model.runBlockingJavaTask((AbstractJavaModelTask)new CreateManagedBeanEntryTask((IResource)file), null, null);
        }
        if (CodeBehindPreferences.isAutoGenerate()) {
            this.mapNodes(JsfComponentUtil.findJsfNodes((Document)doc));
        }
    }

    public void mapNodes(final List list) {
        if (list.size() > 0) {
            AbstractJavaModelTask task = new AbstractJavaModelTask(){

                public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
                    monitor.beginTask(null, list.size());
                    for (IDOMNode node : list) {
                        monitor.subTask("Mapping node " + node.getNodeName());
                        if (node.getNodeType() == 1) {
                            IDOMElement element = (IDOMElement)node;
                            String id = element.getAttribute("id");
                            if (id == null || id.length() == 0) continue;
                            ReadMethodCommand command = new ReadMethodCommand();
                            command.setIdentifier("get" + JavaCodeUtil.capitalizeFirst((String)element.getAttribute("id")));
                            command.execute(model, monitor);
                            IMethod method = command.getMethod();
                            if (method != null) {
                                JavaCBTagListener.this.xmlNodeJavaElementMap.put(element, method);
                            }
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }

                public String getDisplayName() {
                    return Messages.JavaCBTagListener_0;
                }

                public boolean isSystem() {
                    return true;
                }
            };
            this.model.runBackgroundJavaTaskAsJob(task, null);
        }
    }
}

