/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java;

import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.api.ICBSavePreparation;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.internal.CBLanguageAdapter;
import com.ibm.etools.webtools.codebehind.internal.commands.SwitchCBBindingsCommand;
import com.ibm.etools.webtools.codebehind.java.CreateManagedBeanEntryTask;
import com.ibm.etools.webtools.codebehind.java.FacesConfigUtil;
import com.ibm.etools.webtools.codebehind.java.JavaLocationGenerator;
import com.ibm.etools.webtools.codebehind.java.extensions.CopyCBModelTask;
import com.ibm.etools.webtools.codebehind.java.extensions.MoveCBModelTask;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class JavaCBSavePrep
implements ICBSavePreparation {
    public CBLanguageInfo copyCodeBehindFile(IFile currentFile, IFile targetFile, CBLanguageInfo currentInfo, CBLanguageInfo targetInfo) {
        CBLanguageInfo switchTo = new CBLanguageInfo();
        JavaModel currentModel = JavaModelManager.getInstance().getModel("codebehind", currentFile.getProject(), currentInfo.location);
        IVirtualComponent component = ComponentCore.createComponent((IProject)targetFile.getProject());
        IPath jsfPath = JavaCodeUtil.getWebContentRelativePath((IVirtualComponent)component, (IPath)targetFile.getFullPath());
        IPackageFragment destination = JavaLocationGenerator.getDestinationPackage(targetFile.getProject(), jsfPath, false);
        if (destination != null) {
            CopyCBModelTask copyCmd = new CopyCBModelTask();
            copyCmd.setDestination(destination);
            copyCmd.setNewName(targetFile.getName());
            copyCmd.setForce(false);
            try {
                currentModel.runBackgroundJavaTaskAsJob((AbstractJavaModelTask)copyCmd, null);
            }
            finally {
                currentModel.release();
            }
            IFolder destinationFolder = JavaLocationGenerator.getDestinationFolder(targetFile.getProject(), jsfPath);
            IFile newCBFile = JavaCodeUtil.getNewCUName((IFolder)destinationFolder, (String)targetFile.getName());
            if (newCBFile != null) {
                IPath newFilePath = newCBFile.getProjectRelativePath().makeAbsolute();
                currentModel = JavaModelManager.getInstance().getModel("codebehind", newCBFile.getProject(), newFilePath);
                CreateManagedBeanEntryTask createBeanCmd = new CreateManagedBeanEntryTask((IResource)targetFile);
                try {
                    currentModel.runBackgroundJavaTaskAsJob((AbstractJavaModelTask)createBeanCmd, null);
                }
                finally {
                    currentModel.release();
                }
                switchTo.language = targetInfo.language;
                switchTo.location = newFilePath;
            }
        }
        return switchTo;
    }

    public CBLanguageInfo handleSaveAsTemplate(IFile currentFile, IFile targetFile, IDOMDocument targetXmlDoc, ICBLanguage targetCbAdapter) {
        CBLanguageInfo switchTo;
        block10: {
            switchTo = new CBLanguageInfo();
            CBLanguageInfo targetInfo = targetCbAdapter.getCBInfo();
            try {
                if (!JsfComponentUtil.isJSP((IFile)currentFile)) break block10;
                IModelManager manager = StructuredModelManager.getModelManager();
                IStructuredModel currentModel = null;
                try {
                    currentModel = manager.getModelForRead(currentFile);
                    IDOMDocument currentXmlDoc = ((IDOMModel)currentModel).getDocument();
                    ICBLanguage currentCBAdapter = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)currentXmlDoc);
                    CBLanguageInfo currentInfo = ((CBLanguageAdapter)currentCBAdapter).getRawCBInfo();
                    if (currentInfo != null) {
                        if (currentInfo.equals((Object)targetInfo) && currentInfo.language.equalsIgnoreCase("java")) {
                            switchTo = this.copyCodeBehindFile(currentFile, targetFile, currentInfo, targetInfo);
                            String oldBean = CodeBehindUtil.getManagedBeanName((IDOMDocument)currentXmlDoc);
                            String newBean = FacesConfigUtil.createManagedBean(targetFile.getProject(), (IResource)targetFile, oldBean, null, null, false);
                            SwitchCBBindingsCommand rebind = new SwitchCBBindingsCommand(targetXmlDoc, oldBean, newBean);
                            rebind.execute();
                        }
                    } else {
                        switchTo = targetInfo.language.equalsIgnoreCase("java") ? this.moveCodeBehindFile(currentFile, targetFile, targetInfo) : targetInfo;
                    }
                }
                finally {
                    if (currentModel != null) {
                        currentModel.releaseFromRead();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return switchTo;
    }

    public CBLanguageInfo moveCodeBehindFile(IFile currentFile, IFile targetFile, CBLanguageInfo currentInfo) {
        CBLanguageInfo switchTo = new CBLanguageInfo();
        JavaModel model = JavaModelManager.getInstance().getModel("codebehind", currentFile.getProject(), currentInfo.location);
        try {
            IVirtualComponent component = ComponentCore.createComponent((IProject)targetFile.getProject());
            IPath jsfPath = JavaCodeUtil.getWebContentRelativePath((IVirtualComponent)component, (IPath)targetFile.getFullPath());
            IPackageFragment destination = JavaLocationGenerator.getDestinationPackage(targetFile.getProject(), jsfPath);
            if (destination != null) {
                MoveCBModelTask moveCmd = new MoveCBModelTask();
                moveCmd.setDestination(destination);
                model.runBackgroundJavaTaskAsJob((AbstractJavaModelTask)moveCmd, null);
                IFolder folder = null;
                try {
                    folder = (IFolder)destination.getCorrespondingResource();
                    String cbFileName = model.getJavaFile().getName();
                    IFile newCbFile = (IFile)folder.findMember(cbFileName);
                    switchTo.location = newCbFile.getProjectRelativePath().makeAbsolute();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
            switchTo.language = currentInfo.language;
        }
        finally {
            model.release();
        }
        return switchTo;
    }

    public boolean shouldBeSaved(IDOMDocument targetXmlDoc) {
        boolean isJsfPage = false;
        isJsfPage = JsfComponentUtil.isJsfPage((Document)targetXmlDoc);
        return isJsfPage;
    }
}

