/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.codebehind.java;

import com.ibm.etools.webtools.codebehind.api.CBLanguageInfo;
import com.ibm.etools.webtools.codebehind.api.CodeBehindLanguageRegistry;
import com.ibm.etools.webtools.codebehind.api.CodeBehindUtil;
import com.ibm.etools.webtools.codebehind.api.ICBLanguage;
import com.ibm.etools.webtools.codebehind.api.ICBLanguageFactory;
import com.ibm.etools.webtools.codebehind.api.ILocationGenerator;
import com.ibm.etools.webtools.codebehind.core.api.CodeBehindCoreUtil;
import com.ibm.etools.webtools.codebehind.java.JavaCodeBehindPlugin;
import com.ibm.etools.webtools.codebehind.java.extensions.MockJavaCBModel;
import com.ibm.etools.webtools.codebehind.java.extensions.PageCodeBaseGetManagedBeanMethod;
import com.ibm.etools.webtools.codebehind.java.nls.Messages;
import com.ibm.etools.webtools.codebehind.pdm.data.SyncAllPageCodeMethodsToPageDataTask;
import com.ibm.etools.webtools.javamodel.api.AbstractJavaModelTask;
import com.ibm.etools.webtools.javamodel.api.JavaCodeUtil;
import com.ibm.etools.webtools.javamodel.api.JavaDocInfo;
import com.ibm.etools.webtools.javamodel.api.JavaModel;
import com.ibm.etools.webtools.javamodel.api.JavaModelManager;
import com.ibm.etools.webtools.javamodel.commands.CreateEntireMethodFromContentsCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.icu.util.StringTokenizer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class CBModelUtil {
    public static final String JavaDoc_metatdataFileName = "metadataFileName=";
    public static final String JavaDoc_mediatorProperties = "mediatorProperties";
    public static final String JavaDoc_mediatorFactory = "mediatorFactory";
    public static final String JavaDoc_mediatorProps_delimiter = ",";
    public static final String JavaDoc_graphId_params = "params";
    public static final String JavaDoc_graphId_result = "result";
    public static final String JavaDoc_subPath = "subPath=";
    public static final String JavaDoc_action = "action";

    public static void addGetManagedBeanMethodToPageCodeBase(IProject project, IProgressMonitor monitor) {
        final JavaModel pagecodeBaseFileModel = JavaCodeBehindPlugin.getDefault().getSuperModel(project);
        if (pagecodeBaseFileModel != null) {
            try {
                pagecodeBaseFileModel.runBlockingJavaTask(new AbstractJavaModelTask(){

                    public void executeTask(JavaModel model, IProgressMonitor monitor) throws JavaModelException {
                        block2: {
                            CreateEntireMethodFromContentsCommand cmd = new CreateEntireMethodFromContentsCommand();
                            cmd.setContents(new PageCodeBaseGetManagedBeanMethod().generate(null));
                            try {
                                cmd.execute(pagecodeBaseFileModel, monitor);
                                pagecodeBaseFileModel.save();
                            }
                            catch (JavaModelException e) {
                                if (e.getJavaModelStatus() != null && e.getJavaModelStatus().getCode() == 977) break block2;
                                e.printStackTrace();
                            }
                        }
                    }
                }, null, monitor);
            }
            finally {
                if (pagecodeBaseFileModel != null) {
                    pagecodeBaseFileModel.release();
                }
            }
        }
    }

    public static IInitializer findFieldInitializer(String fieldName, JavaModel model) throws JavaModelException {
        IInitializer[] initializers = model.getType().getInitializers();
        IInitializer target = null;
        int i = 0;
        while (i < initializers.length) {
            String source = initializers[i].getSource();
            if (source.indexOf(String.valueOf(fieldName) + ".put(") >= 0) {
                target = initializers[i];
                break;
            }
            ++i;
        }
        return target;
    }

    public static String fixupFieldName(String fieldname) {
        return fieldname.replace(' ', '_');
    }

    public static JavaModel getCBModel(IDOMDocument xmlDoc) {
        JavaModel model = null;
        ICBLanguage cbAdapter = CodeBehindCoreUtil.getICBLanguage((IDOMDocument)xmlDoc);
        CBLanguageInfo cbInfo = cbAdapter.getCBInfo();
        if (cbInfo.language.equalsIgnoreCase("none")) {
            ICBLanguageFactory javaFactory = CodeBehindLanguageRegistry.getRegistry().getCodeBehindLanguageFactory("java");
            ILocationGenerator locGen = javaFactory.getLocationGenerator();
            IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
            IPath newPath = locGen.getLocationForJSP(jspFile);
            cbAdapter.switchLanguage("java", newPath, false);
            cbInfo = cbAdapter.getCBInfo();
        }
        if (cbInfo.language.equals("java")) {
            IFile jspFile = CodeBehindUtil.getFileForPage((IDOMDocument)xmlDoc);
            model = JavaModelManager.getInstance().getModel("codebehind", jspFile.getProject(), cbInfo.location);
        } else {
            MessageDialog.openError(null, (String)"Error", (String)(String.valueOf(Messages.CBModelUtil_E_language) + cbInfo.language));
            model = new MockJavaCBModel(null, null);
        }
        return model;
    }

    public static JavaModel getSuperModel(JavaModel cbModel) {
        return JavaCodeBehindPlugin.getDefault().getSuperModel(cbModel.getProject());
    }

    private static Map parseFieldInitializer(String fieldName, JavaModel model) throws JavaModelException {
        IInitializer target = CBModelUtil.findFieldInitializer(fieldName, model);
        if (target != null) {
            HashMap ret = new HashMap(1);
            String source = target.getSource();
            int beginindex = source.indexOf(123);
            int endindex = source.lastIndexOf(125);
            source = source.substring(beginindex + 1, endindex);
            CBModelUtil.parseMapEntries(source, ret);
            return ret;
        }
        return null;
    }

    private static void parseMapEntries(String contents, Map ret) {
        StringTokenizer values = new StringTokenizer(contents, ";");
        while (values != null && values.hasMoreTokens()) {
            String line = values.nextToken();
            int start = line.indexOf(".put(");
            int end = line.lastIndexOf(")");
            if (start < 0 || end < 0) continue;
            String params = line.substring(start + 5, end);
            int idx = params.indexOf(JavaDoc_mediatorProps_delimiter);
            String key = CBModelUtil.trim(params.substring(0, idx));
            String value = CBModelUtil.trim(params.substring(idx + 1));
            ret.put(key, value);
        }
    }

    public static JavaDocInfo readJavaDoc(IMethod method) throws JavaModelException {
        return JavaCodeUtil.parseJavaDoc((String)method.getSource());
    }

    public static Map readParameters(String paramsFieldName, JavaModel model) throws JavaModelException {
        return CBModelUtil.parseFieldInitializer(paramsFieldName, model);
    }

    public static void synchronizePageCodeToPageData(IPageDataModel pdModel, IProject project, IPath location) {
        SyncAllPageCodeMethodsToPageDataTask syncTask = new SyncAllPageCodeMethodsToPageDataTask(pdModel);
        JavaModel javaModel = JavaModelManager.getInstance().getModel("codebehind", project, location);
        try {
            javaModel.runJavaTask(8, (AbstractJavaModelTask)syncTask, null, null, null);
        }
        finally {
            javaModel.release();
        }
    }

    public static void synchronizePageCodeToPageData(IPageDataModel pdModel, JavaModel javaModel) {
        SyncAllPageCodeMethodsToPageDataTask syncTask = new SyncAllPageCodeMethodsToPageDataTask(pdModel);
        javaModel.runJavaTask(8, (AbstractJavaModelTask)syncTask, null, null, null);
    }

    private static String trim(String input) {
        String ret = input.trim();
        if (ret.startsWith("\"") && ret.endsWith("\"")) {
            ret = ret.substring(1);
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }
}

