/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions;

import com.ibm.etools.webedit.commands.ImportSourceCommand;
import com.ibm.etools.webedit.common.actions.CommandAction;
import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.palette.PaletteItemInfo;
import com.ibm.etools.webedit.palette.PaletteItemInfoRegistry;
import com.ibm.etools.webtools.ajax.library.Logger;
import com.ibm.etools.webtools.ajax.library.internal.ResourceHandler;
import com.ibm.etools.webtools.ajax.library.internal.palette.AJAXLibraryManagerHelper;
import com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions.ImportDojoRequiresSourceCommand;
import com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions.InsertDojoIncludesCommand;
import com.ibm.etools.webtools.dojo.core.DojoSettings;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IAction;

public class DojoDropAction
extends CommandAction {
    public DojoDropAction() {
        super(null, null);
    }

    protected Command getCommandForExec() {
        PaletteItemInfo paletteItem = PaletteItemInfoRegistry.getInstance().getPaletteItemInfo((IAction)this);
        Map properties = paletteItem.getProperties();
        if (properties == null || !properties.containsKey(AJAXLibraryManagerHelper.HTML_CONTENT)) {
            Logger.log(4, ResourceHandler._UI_Error_missing_html_content);
            return null;
        }
        String htmlSource = (String)properties.get(AJAXLibraryManagerHelper.HTML_CONTENT);
        if (htmlSource == null || htmlSource.length() == 0) {
            Logger.log(4, ResourceHandler._UI_Error_empty_html_content);
            return null;
        }
        htmlSource = this.processHtmlSource(htmlSource);
        String htmlRequires = (String)properties.get(AJAXLibraryManagerHelper.HTML_REQUIRE_PRELOAD);
        String[] htmlRequire = htmlRequires.split("\n");
        CompoundHTMLCommand retCommand = new CompoundHTMLCommand(ResourceHandler.bind((String)ResourceHandler._UI_palette_insert_command_name, (Object)paletteItem.getLabel()));
        retCommand.append((HTMLCommand)new InsertDojoIncludesCommand());
        retCommand.append((HTMLCommand)new ImportSourceCommand(htmlSource));
        String[] stringArray = htmlRequire;
        int n = htmlRequire.length;
        int n2 = 0;
        while (n2 < n) {
            String reqStmt = stringArray[n2];
            retCommand.append((HTMLCommand)new ImportDojoRequiresSourceCommand(reqStmt));
            ++n2;
        }
        return retCommand;
    }

    protected Command getCommandForUpdate() {
        return null;
    }

    protected String processHtmlSource(String htmlSource) {
        String themeName;
        String BODY_OPEN = "<body";
        String BODY_CLOSE = "</body>";
        String TAG_END = ">";
        String SIMPLE_BODY_TAG_OPEN = BODY_OPEN.concat(TAG_END);
        String SIMPLE_BODY_TAG_CLOSE = BODY_CLOSE;
        String CLASS_ATTRIBUTE = " class";
        if (htmlSource == null || htmlSource.length() == 0) {
            return htmlSource;
        }
        if (!htmlSource.toLowerCase().contains(BODY_OPEN)) {
            htmlSource = SIMPLE_BODY_TAG_OPEN.concat(htmlSource).concat(SIMPLE_BODY_TAG_CLOSE);
        }
        if ((themeName = this.getDojoThemeName()) != null && !themeName.isEmpty()) {
            int bodyStart = htmlSource.indexOf(BODY_OPEN);
            String bodyTagString = htmlSource.substring(bodyStart, htmlSource.indexOf(TAG_END, bodyStart) + 1);
            String newBodyTagString = "";
            int insert = bodyTagString.indexOf(BODY_OPEN) + BODY_OPEN.length();
            String classAttrValue = CLASS_ATTRIBUTE.concat("=\"" + themeName + "\"");
            newBodyTagString = bodyTagString.substring(0, insert).concat(classAttrValue).concat(bodyTagString.substring(insert));
            htmlSource = htmlSource.replace(bodyTagString, newBodyTagString);
        }
        return htmlSource;
    }

    protected String getDojoThemeName() {
        String themeName = null;
        HTMLEditDomain target = this.getTarget();
        themeName = DojoDropAction.getDojoThemeName(target);
        return themeName;
    }

    public static String getDojoThemeName(HTMLEditDomain editDomain) {
        String themeName = null;
        if (editDomain == null) {
            return null;
        }
        String targetLocation = editDomain.getActiveModel().getBaseLocation();
        if (targetLocation == null || targetLocation.isEmpty()) {
            return null;
        }
        IResource targetFile = ResourcesPlugin.getWorkspace().getRoot().findMember(targetLocation);
        if (targetFile == null || !targetFile.exists()) {
            return null;
        }
        IProject targetProject = targetFile.getProject();
        try {
            Path themeCSSPath;
            String themeCSS = DojoSettings.getThemeCSS((IProject)targetProject);
            if (themeCSS != null && (themeCSSPath = new Path(themeCSS)).isValidPath(themeCSS)) {
                themeCSSPath = themeCSSPath.removeFileExtension();
                themeName = themeCSSPath.lastSegment();
            }
        }
        catch (CoreException coreException) {}
        return themeName;
    }
}

