/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajax.library.internal.palette.dojo;

import com.ibm.etools.palette.model.PaletteData;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.palette.view.AbstractHTMLPaletteVisibilityInspector;
import com.ibm.etools.webtools.ajax.library.Logger;
import com.ibm.etools.webtools.ajax.library.internal.palette.AJAXLibraryManagerHelper;
import com.ibm.etools.webtools.dojo.core.DojoSettings;
import com.ibm.etools.webtools.dojo.core.DojoVersion;
import com.ibm.etools.webtools.scriptgrammar.core.internal.ScriptGrammarHack;
import java.net.MalformedURLException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class DojoPaletteVisibilityInspector
extends AbstractHTMLPaletteVisibilityInspector {
    public boolean isItemVisible(PaletteData item, HTMLEditDomain domain) {
        boolean hasDojoFacet;
        boolean hasCorrectDojoVersion;
        block5: {
            hasCorrectDojoVersion = true;
            hasDojoFacet = false;
            try {
                Set facets;
                IProject project;
                IResource file;
                String modelLocation = domain.getActiveModel().getBaseLocation();
                if (modelLocation == null || (file = ResourcesPlugin.getWorkspace().getRoot().findMember(modelLocation)) == null || !file.exists() || (project = file.getProject()) == null) break block5;
                IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
                Set set = facets = fp == null ? null : fp.getProjectFacets();
                if (facets == null) break block5;
                for (IProjectFacetVersion facet : facets) {
                    if (!facet.getProjectFacet().getId().equals("rad.dojo")) continue;
                    hasDojoFacet = true;
                    DojoVersion paletteItemVer = this.getDojoVersionFromPaletteItem(item.getId());
                    DojoVersion projectVer = DojoSettings.getDojoVersion((IProject)project);
                    if (paletteItemVer != null && projectVer != null && projectVer.compareTo(paletteItemVer) < 0) {
                        hasCorrectDojoVersion = false;
                    }
                    break;
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
                hasCorrectDojoVersion = false;
            }
            catch (MalformedURLException malformedURLException) {
                hasCorrectDojoVersion = false;
            }
        }
        return hasCorrectDojoVersion && (hasDojoFacet || ScriptGrammarHack.isDOJOEnabled((IDOMDocument)domain.getActiveModel().getDocument()));
    }

    private DojoVersion getDojoVersionFromPaletteItem(String id) {
        DojoVersion ver = null;
        String verString = AJAXLibraryManagerHelper.getInstance().getVersionFromCategoryID(id);
        if (verString == null) {
            return null;
        }
        try {
            ver = new DojoVersion(verString.trim());
        }
        catch (NumberFormatException numberFormatException) {
            ver = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ver = null;
        }
        return ver;
    }
}

