/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajax.library.internal.palette;

import com.ibm.etools.palette.model.PaletteCategoryData;
import com.ibm.etools.palette.model.PaletteData;
import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.palette.customize.PaletteLibraryProvider;
import com.ibm.etools.webtools.ajax.library.AJAXLibraryPlugin;
import com.ibm.etools.webtools.ajax.library.Logger;
import com.ibm.etools.webtools.ajax.library.internal.palette.AJAXLibraryManager;
import com.ibm.etools.webtools.scriptgrammar.core.widget.IWidgetCategory;
import com.ibm.etools.webtools.scriptgrammar.core.widget.IWidgetDescription;
import com.ibm.etools.webtools.scriptgrammar.core.widget.IWidgetRequirements;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class AJAXLibraryManagerHelper {
    private static AJAXLibraryManagerHelper _instance = null;
    public static String HTML_CONTENT = "htmlContent";
    public static String HTML_REQUIRE_PRELOAD = "htmlRequire";
    public static String IS_USER_DEFINED_PALETTE_ITEM = "isUserDefinedPaletteItem";
    private Map<AJAXLibraryManager, List<PaletteData>> paletteItemsMap = new HashMap<AJAXLibraryManager, List<PaletteData>>();

    private AJAXLibraryManagerHelper() {
    }

    public static synchronized AJAXLibraryManagerHelper getInstance() {
        if (_instance == null) {
            _instance = new AJAXLibraryManagerHelper();
        }
        return _instance;
    }

    public void registerLibraryManager(AJAXLibraryManager mgr) {
        if (!this.paletteItemsMap.containsKey(mgr)) {
            this.paletteItemsMap.put(mgr, null);
        }
    }

    public Set<AJAXLibraryManager> getLibraryManagers() {
        return this.paletteItemsMap.keySet();
    }

    public void resetPaletteItemsMap() {
        this.paletteItemsMap.clear();
    }

    public List<PaletteData> buildLibraryPalette(AJAXLibraryManager libraryMgr) {
        List<PaletteData> listOfPaletteItems = this.getPaletteItemsListFromMap(libraryMgr);
        IWidgetDescription[] widgets = libraryMgr.getLibraryWidgets(this.getPathToCurrentProject());
        int i = 0;
        while (i < widgets.length) {
            IWidgetDescription widget = widgets[i];
            PaletteItemData paletteItem = this.findExistingPaletteItem(widget, libraryMgr);
            if (paletteItem == null) {
                this.buildPaletteItem(widget, listOfPaletteItems, libraryMgr);
            }
            ++i;
        }
        return listOfPaletteItems;
    }

    public List<PaletteData> updateUserDefinedPaletteItems(AJAXLibraryManager libraryMgr, HTMLEditDomain domain) {
        List<PaletteData> existingPaletteItems = this.getPaletteItemsListFromMap(libraryMgr);
        ArrayList<PaletteData> newPaletteCategories = new ArrayList<PaletteData>();
        IWidgetDescription[] widgets = libraryMgr.getUserDefinedWidgets(domain);
        int i = 0;
        while (i < widgets.length) {
            IWidgetDescription widget = widgets[i];
            PaletteItemData paletteItem = this.findExistingPaletteItem(widget, libraryMgr);
            if (paletteItem == null) {
                boolean isNewCategory = true;
                PaletteCategoryData paletteCat = this.getExistingPaletteCategory(widget, libraryMgr);
                if (paletteCat != null) {
                    isNewCategory = false;
                }
                if ((paletteItem = this.buildPaletteItem(widget, existingPaletteItems, libraryMgr)) != null) {
                    paletteItem.setId(this.getPathToProject(domain) + "." + widget.getAttribute("name"));
                    paletteItem.setVisibilityData(libraryMgr.getUserDefinedItemVisibilityData(domain));
                    paletteItem.addProperty(IS_USER_DEFINED_PALETTE_ITEM, IS_USER_DEFINED_PALETTE_ITEM);
                    if (isNewCategory) {
                        newPaletteCategories.add((PaletteData)paletteItem.getCategory());
                    }
                }
            }
            ++i;
        }
        this.removeStalePaletteItems(existingPaletteItems, widgets, libraryMgr);
        return newPaletteCategories;
    }

    protected List<PaletteData> getPaletteItemsListFromMap(AJAXLibraryManager libraryMgr) {
        List<PaletteData> listOfPaletteItems = this.paletteItemsMap.get(libraryMgr);
        if (listOfPaletteItems == null) {
            listOfPaletteItems = new ArrayList<PaletteData>();
            this.paletteItemsMap.put(libraryMgr, listOfPaletteItems);
        }
        return listOfPaletteItems;
    }

    protected PaletteItemData buildPaletteItem(IWidgetDescription widget, List<PaletteData> listOfPaletteItems, AJAXLibraryManager libraryMgr) {
        PaletteItemData paletteItem = PaletteLibraryProvider.getInstance().createItemData();
        paletteItem.setLabel(this.getPaletteItemName(widget));
        paletteItem.setId(widget.getAttribute("name"));
        paletteItem.setDescription(widget.getAttribute("description"));
        String iconPath = widget.getAttribute("value");
        URL iconURL = this.getIconURL(iconPath, libraryMgr);
        if (iconURL != null) {
            paletteItem.setSmallIcon(iconURL);
            paletteItem.setLargeIcon(iconURL);
        }
        paletteItem.addProperty(HTML_CONTENT, widget.getContent());
        IWidgetRequirements[] reqs = widget.getRequirements();
        if (reqs != null && reqs.length > 0 && reqs[0] != null) {
            String preloadSection = "";
            String[] preloads = reqs[0].getPreloads();
            if (preloads != null) {
                int i = 0;
                while (i < preloads.length) {
                    String preload = preloads[i];
                    preloadSection = preloadSection.concat(preload.trim());
                    if (i + 1 < preloads.length) {
                        preloadSection = preloadSection.concat("\n");
                    }
                    ++i;
                }
            }
            paletteItem.addProperty(HTML_REQUIRE_PRELOAD, preloadSection);
        }
        paletteItem.addAttribute("bundle", libraryMgr.getActionClassBundleName());
        paletteItem.addAttribute("actionclass", libraryMgr.getActionClassName());
        PaletteCategoryData paletteCat = this.getPaletteCategory(widget, listOfPaletteItems, libraryMgr);
        if (paletteCat != null) {
            paletteCat.add(paletteItem);
            if (!listOfPaletteItems.contains(paletteCat)) {
                listOfPaletteItems.add((PaletteData)paletteCat);
            }
        }
        return paletteItem;
    }

    protected String getPaletteCategoryName(IWidgetDescription widget, AJAXLibraryManager libraryMgr) {
        IWidgetCategory[] categories = widget.getCategories();
        String categoryName = null;
        IWidgetCategory[] iWidgetCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IWidgetCategory category = iWidgetCategoryArray[n2];
            String id = category.getId();
            if (id != null && id.startsWith("palette.")) {
                categoryName = category.getLabel();
            }
            ++n2;
        }
        if (categoryName == null || categoryName.length() == 0) {
            categoryName = libraryMgr.getDefaultCategoryName();
        }
        if (categoryName == null || categoryName.length() == 0) {
            return null;
        }
        String libraryName = null;
        IWidgetRequirements[] reqs = widget.getRequirements();
        if (reqs != null && reqs.length > 0 && reqs[0] != null) {
            libraryName = reqs[0].getName();
        }
        if (libraryName != null && !libraryName.isEmpty()) {
            categoryName = libraryName.trim().concat(" - ").concat(categoryName);
        }
        return categoryName;
    }

    protected String getPaletteItemName(IWidgetDescription widget) {
        String label = widget.getAttribute("title");
        return label != null ? label : widget.getAttribute("name");
    }

    protected String getPaletteCategoryId(IWidgetDescription widget, AJAXLibraryManager libraryMgr) {
        IWidgetCategory[] categories = widget.getCategories();
        String categoryName = null;
        IWidgetCategory[] iWidgetCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IWidgetCategory category = iWidgetCategoryArray[n2];
            String id = category.getId();
            if (id != null && id.startsWith("palette.")) {
                categoryName = id;
            }
            ++n2;
        }
        if (categoryName == null || categoryName.length() == 0) {
            categoryName = libraryMgr.getDefaultCategoryName();
        }
        if (categoryName == null || categoryName.length() == 0) {
            return null;
        }
        String libraryName = null;
        String libraryVersion = null;
        IWidgetRequirements[] reqs = widget.getRequirements();
        if (reqs != null && reqs.length > 0 && reqs[0] != null) {
            libraryName = reqs[0].getName();
            libraryVersion = reqs[0].getMinVersion();
        }
        if (libraryName != null && !libraryName.isEmpty()) {
            categoryName = " - ".concat(categoryName);
            if (libraryVersion != null && !libraryVersion.isEmpty()) {
                categoryName = " ".concat(libraryVersion.trim()).concat(categoryName);
            }
            categoryName = libraryName.trim().concat(categoryName);
        }
        return categoryName;
    }

    protected PaletteCategoryData getExistingPaletteCategory(IWidgetDescription widget, AJAXLibraryManager libraryMgr) {
        List<PaletteData> listOfPaletteItems = this.getPaletteItemsListFromMap(libraryMgr);
        String categoryName = this.getPaletteCategoryName(widget, libraryMgr);
        for (PaletteData item : listOfPaletteItems) {
            if (categoryName.compareTo(item.getLabel()) != 0 || !(item instanceof PaletteCategoryData)) continue;
            return (PaletteCategoryData)item;
        }
        return null;
    }

    protected PaletteCategoryData getPaletteCategory(IWidgetDescription widget, List<PaletteData> listOfPaletteItems, AJAXLibraryManager libraryMgr) {
        PaletteCategoryData paletteCat = this.getExistingPaletteCategory(widget, libraryMgr);
        if (paletteCat != null) {
            String paletteCategoryVersion = this.getVersionFromCategoryID(paletteCat.getId());
            String widgetVersion = null;
            IWidgetRequirements[] reqs = widget.getRequirements();
            if (reqs != null && reqs.length > 0 && reqs[0] != null) {
                widgetVersion = reqs[0].getMinVersion();
            }
            if (paletteCategoryVersion != null && widgetVersion != null && libraryMgr.compareVersion(widgetVersion, paletteCategoryVersion) < 0) {
                paletteCat.setId(this.getPaletteCategoryId(widget, libraryMgr));
            }
            return paletteCat;
        }
        String categoryName = this.getPaletteCategoryName(widget, libraryMgr);
        String categoryId = this.getPaletteCategoryId(widget, libraryMgr);
        return this.createPaletteCategory(categoryName, categoryId, libraryMgr);
    }

    public String getVersionFromCategoryID(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        String[] words = id.split(" ");
        if (words == null || words.length == 0) {
            return null;
        }
        String verString = null;
        int i = 0;
        block0: while (i < words.length) {
            if (words[i].trim().compareTo("-") == 0) {
                int j = i - 1;
                while (j > 0) {
                    if (!words[j].trim().isEmpty()) {
                        verString = words[j];
                        break block0;
                    }
                    --j;
                }
                break;
            }
            ++i;
        }
        return verString;
    }

    protected PaletteCategoryData createPaletteCategory(String name, String id, AJAXLibraryManager libraryMgr) {
        PaletteCategoryData paletteCat = PaletteLibraryProvider.getInstance().createCategoryData();
        paletteCat.setLabel(name);
        paletteCat.setId(id);
        paletteCat.setSmallIcon(FileLocator.find((Bundle)AJAXLibraryPlugin.getDefault().getBundle(), (IPath)new Path(libraryMgr.getCategoryIconPath()), null));
        paletteCat.setVisibilityData(libraryMgr.getPaletteVisibilityData());
        return paletteCat;
    }

    protected PaletteItemData findExistingPaletteItem(IWidgetDescription widget, AJAXLibraryManager libraryMgr) {
        PaletteCategoryData paletteCat = this.getExistingPaletteCategory(widget, libraryMgr);
        if (paletteCat != null) {
            return this.findExistingPaletteItemInCategory(widget, paletteCat, libraryMgr);
        }
        List<PaletteData> listOfPaletteItems = this.getPaletteItemsListFromMap(libraryMgr);
        for (PaletteData item : listOfPaletteItems) {
            if (!(item instanceof PaletteItemData) || !this.matchesPaletteItem(widget, (PaletteItemData)item, libraryMgr)) continue;
            return (PaletteItemData)item;
        }
        return null;
    }

    private PaletteItemData findExistingPaletteItemInCategory(IWidgetDescription widget, PaletteCategoryData category, AJAXLibraryManager libraryMgr) {
        if (category == null) {
            return null;
        }
        for (PaletteItemData item : category.getChildren()) {
            if (!this.matchesPaletteItem(widget, item, libraryMgr)) continue;
            return item;
        }
        return null;
    }

    private boolean matchesPaletteItem(IWidgetDescription widget, PaletteItemData item, AJAXLibraryManager libraryMgr) {
        String widgetId1 = widget.getAttribute("name");
        String widgetId2 = this.getPathToCurrentProject() + "." + widgetId1;
        String paletteItemId = item.getId();
        if (paletteItemId.compareTo(widgetId1) == 0 || paletteItemId.compareTo(widgetId2) == 0) {
            String widgetLabel = this.getPaletteItemName(widget);
            String paletteItemLabel = item.getLabel();
            if (paletteItemLabel != null && widgetLabel != null && paletteItemLabel.compareTo(widgetLabel) == 0) {
                String widgetCategoryName = this.getPaletteCategoryName(widget, libraryMgr);
                String paletteCategoryName = item.getCategory().getLabel();
                if (widgetCategoryName != null && paletteCategoryName != null && paletteCategoryName.compareTo(widgetCategoryName) == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private IPath getPathToProject(HTMLEditDomain domain) {
        IProject project;
        IResource file;
        String modelLocation = domain.getActiveModel().getBaseLocation();
        if (modelLocation != null && (file = ResourcesPlugin.getWorkspace().getRoot().findMember(modelLocation)) != null && file.exists() && (project = file.getProject()) != null) {
            return project.getFullPath();
        }
        return null;
    }

    private IPath getPathToCurrentProject() {
        IEditorPart editor;
        IWorkbenchWindow window;
        IWorkbench workbench;
        if (PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null && (window = workbench.getActiveWorkbenchWindow()) != null && (editor = window.getActivePage().getActiveEditor()) instanceof HTMLEditDomain) {
            return this.getPathToProject((HTMLEditDomain)editor);
        }
        return null;
    }

    private void removeStalePaletteItems(List<? extends PaletteData> existingPaletteItems, IWidgetDescription[] userDefinedWidgets, AJAXLibraryManager libraryMgr) {
        for (PaletteData paletteData : existingPaletteItems) {
            PaletteItemData thePaletteItem;
            Map properties;
            if (paletteData instanceof PaletteCategoryData) {
                List children = ((PaletteCategoryData)paletteData).getChildren();
                this.removeStalePaletteItems(children, userDefinedWidgets, libraryMgr);
                continue;
            }
            if (!(paletteData instanceof PaletteItemData) || (properties = (thePaletteItem = (PaletteItemData)paletteData).getProperties()) == null || !properties.containsKey(IS_USER_DEFINED_PALETTE_ITEM)) continue;
            boolean isNeeded = false;
            IWidgetDescription[] iWidgetDescriptionArray = userDefinedWidgets;
            int n = userDefinedWidgets.length;
            int n2 = 0;
            while (n2 < n) {
                IWidgetDescription widget = iWidgetDescriptionArray[n2];
                if (this.matchesPaletteItem(widget, thePaletteItem, libraryMgr)) {
                    isNeeded = true;
                }
                ++n2;
            }
            if (isNeeded) continue;
            thePaletteItem.getCategory().remove(thePaletteItem);
        }
    }

    private URL getIconURL(String iconPath, AJAXLibraryManager libraryMgr) {
        URL iconURL = null;
        if (iconPath == null || iconPath.isEmpty()) {
            iconPath = libraryMgr.getDefaultIconPath();
            iconURL = FileLocator.find((Bundle)AJAXLibraryPlugin.getDefault().getBundle(), (IPath)new Path(iconPath), null);
        } else {
            try {
                iconURL = new URL(iconPath);
            }
            catch (MalformedURLException e) {
                Logger.logException(e);
                iconURL = null;
            }
            if (iconURL != null) {
                URL simpleURL = iconURL;
                try {
                    if (ResourcesPlugin.getWorkspace().getRoot().exists((IPath)new Path(iconURL.getFile()))) {
                        iconURL = new URL("file:///" + ResourcesPlugin.getWorkspace().getRoot().findMember(iconURL.getFile()).getLocation().toString());
                    }
                }
                catch (MalformedURLException e) {
                    Logger.logException(e);
                    iconURL = simpleURL;
                }
            }
        }
        return iconURL;
    }
}

