/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.v511.consumption.j2ee13.command;

import com.ibm.etools.environment.command.Command;
import com.ibm.etools.webservice.WebServiceWASInit;
import com.ibm.etools.webservice.command.adapter.CommandToCommand;
import com.ibm.etools.webservice.was.consumption.command.AbstractEmitterCommand;
import com.ibm.etools.webservice.was.consumption.command.AbstractWSDL2JavaCommand;
import com.ibm.etools.webservice.was.consumption.command.CopyGeneratedJavaFilesCommand;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.PlatformUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.was.v51.emitterdata.j2ee13.JavaWSDLParameter;
import com.ibm.etools.webservice.was.v511.consumption.j2ee13.command.util.Logger;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.tools.wsad.WSDL2Java;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;

public class WSDL2JavaCommand
extends AbstractEmitterCommand
implements AbstractWSDL2JavaCommand {
    private ResourceBundle resource = ResourceBundle.getBundle("com.ibm.etools.webservice.was.consumption.consumption");

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus modifiedEmitterStatus;
        block71: {
            IStatus copyCmdStatus;
            CopyGeneratedJavaFilesCommand copyCmd;
            String javaOutput;
            String developServerJavaOutput;
            JavaWSDLParameter javaWSDLParam = (JavaWSDLParameter)this.emitterData_;
            IEnvironment environment = super.getEnvironment();
            if (javaWSDLParam == null) {
                return StatusUtils.errorStatus((String)this.getMessage("MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET"));
            }
            boolean isMetaInfOnly = javaWSDLParam.isMetaInfOnly();
            byte serverSideParameter = javaWSDLParam.getServerSide();
            String optimizedRole = null;
            String developRole = null;
            String deployRole = null;
            String container = null;
            switch (serverSideParameter) {
                case 0: {
                    optimizedRole = "client";
                    container = "bean";
                    if (!javaWSDLParam.getDevelopCodeGenOnly()) break;
                    developRole = "develop-client";
                    break;
                }
                case 1: {
                    developRole = "develop-server";
                    deployRole = "deploy-server";
                    container = "bean";
                    break;
                }
                case 2: {
                    developRole = "develop-server";
                    deployRole = "deploy-server";
                    container = "ejb";
                    break;
                }
                case 3: {
                    optimizedRole = "client";
                    container = "none";
                    if (!javaWSDLParam.getDevelopCodeGenOnly()) break;
                    developRole = "develop-client";
                    break;
                }
                case 4: {
                    optimizedRole = "client";
                    container = "ejb";
                    if (!javaWSDLParam.getDevelopCodeGenOnly()) break;
                    developRole = "develop-client";
                    break;
                }
                case 5: {
                    optimizedRole = "client";
                    container = "client";
                    if (!javaWSDLParam.getDevelopCodeGenOnly()) break;
                    developRole = "develop-client";
                }
            }
            IProject project = javaWSDLParam.getProject();
            String location = javaWSDLParam.getJavaOutput();
            environment.getLog().log(1, 6999, (Object)this, "execute", (Object)("Java Output Location = " + location));
            String wsdlURI = javaWSDLParam.getInputWsdlLocation();
            environment.getLog().log(1, 6999, (Object)this, "execute", (Object)("WSDL URL Location = " + wsdlURI));
            if (javaWSDLParam.getDevelopCodeGenOnly() && developRole != null) {
                javaWSDLParam.setRole(developRole);
            } else if (javaWSDLParam.projectHasAnnotationSupport() && developRole != null) {
                javaWSDLParam.setRole(developRole);
            } else if (optimizedRole != null) {
                javaWSDLParam.setRole(optimizedRole);
            } else {
                javaWSDLParam.setRole(developRole);
            }
            environment.getLog().log(1, 6999, (Object)this, "execute", (Object)("Role = " + javaWSDLParam.getRole()));
            javaWSDLParam.setContainer(container);
            environment.getLog().log(1, 6999, (Object)this, "execute", (Object)("Container = " + container));
            WSDL2Java wsdl2Java = new WSDL2Java();
            if (PlatformUtils.isPlatformURL((String)wsdlURI)) {
                wsdlURI = PlatformUtils.getFileURLFromPlatform((String)wsdlURI);
            }
            Logger.printLine("Calling '" + WSDL2Java.class.getName() + "' from '" + ((Object)((Object)this)).getClass().getName() + "' on URI '" + wsdlURI + "'.");
            wsdl2Java.setUrl(wsdlURI);
            wsdl2Java.setTimeout(-1L);
            Logger.printIndentedLine("-timeout -1");
            wsdl2Java.setRole(javaWSDLParam.getRole());
            Logger.printIndentedLine("-role " + javaWSDLParam.getRole());
            wsdl2Java.setContainer(container);
            Logger.printIndentedLine("-container " + container);
            boolean allEnabled = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isGenAllJavaTypes();
            wsdl2Java.setAll(allEnabled);
            if (allEnabled) {
                Logger.printIndentedLine("-all");
            }
            if ((developServerJavaOutput = javaWSDLParam.getDevelopServerJavaOutput()) != null) {
                environment.getLog().log(1, 6999, (Object)this, "execute", (Object)("Java Output Location = " + developServerJavaOutput));
                javaOutput = developServerJavaOutput;
            } else {
                environment.getLog().log(1, 6999, (Object)this, "execute", (Object)("Java Output Location = " + location));
                javaOutput = location;
            }
            File tmpJavaOutputDir = PlatformUtils.createTempDir((IProject)project);
            String tmpJavaOutputURL = PlatformUtils.getFileURL((File)tmpJavaOutputDir);
            wsdl2Java.setJavaOutput(tmpJavaOutputURL);
            Logger.printIndentedLine("setJavaOutput() value: " + tmpJavaOutputURL);
            if (javaWSDLParam.getTempJavaOutput() != null) {
                wsdl2Java.setJavaOutput(javaWSDLParam.getTempJavaOutput());
                Logger.printIndentedLine("setJavaOutput() value: " + tmpJavaOutputURL);
            }
            if (javaWSDLParam.getWebsphereLevel().startsWith("5.0.2") || !WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isUseWas511Emitter()) {
                wsdl2Java.setCompat("510");
                Logger.printIndentedLine("setCompat() value: 510");
                environment.getLog().log(1, 6999, (Object)this, "execute", (Object)"Compat = 510");
            }
            if (container != null && container.equals("none")) {
                javaWSDLParam.setTempOutput(J2EEUtils.getFileURL((File)J2EEUtils.createTempDir()));
                wsdl2Java.setContainer("client");
                Logger.printIndentedLine("-container client");
            }
            String output = javaWSDLParam.getOutput();
            if (javaWSDLParam.getTempOutput() != null) {
                output = javaWSDLParam.getTempOutput();
            }
            wsdl2Java.setOutput(output);
            Logger.printIndentedLine("-output " + output);
            boolean nowrap = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isNoWrappedOps();
            boolean forceDoNotOverwriteLoadableClasses = false;
            if (optimizedRole != null && optimizedRole.equals("client")) {
                wsdl2Java.setGenJava("Overwrite");
                Logger.printIndentedLine("-genJava Overwrite");
            } else if (javaWSDLParam.isMetaInfOnly()) {
                wsdl2Java.setGenJava("IfNotExist");
                Logger.printIndentedLine("-genJava IfNotExist");
                forceDoNotOverwriteLoadableClasses = true;
                nowrap = false;
            } else {
                wsdl2Java.setGenJava("Overwrite");
                Logger.printIndentedLine("-genJava Overwrite");
            }
            wsdl2Java.setGenXML("Overwrite");
            Logger.printIndentedLine("-genXML Overwrite");
            wsdl2Java.setNoWrappedOperations(nowrap);
            if (nowrap) {
                Logger.printIndentedLine("-noWrappedOperations");
            }
            HashMap mappings = javaWSDLParam.getMappings();
            if (isMetaInfOnly) {
                HashMap reversedMappings = this.reverseMap(mappings);
                wsdl2Java.setMapping((Map)reversedMappings);
                if (reversedMappings != null && Logger.isDebugging()) {
                    Logger.printIndentedLine("setMapping() values: ");
                    Logger.printIndentedLine(reversedMappings);
                }
            } else {
                wsdl2Java.setMapping((Map)mappings);
                if (Logger.isDebugging()) {
                    Logger.printIndentedLine("setMapping() values: ");
                    Logger.printIndentedLine(mappings);
                }
            }
            if (javaWSDLParam.getDeployScope() != null) {
                wsdl2Java.setDeployScope(javaWSDLParam.getDeployScope());
                Logger.printIndentedLine("-deployScope javaWSDLParam.getDeployScope()");
            }
            String httpUsername = javaWSDLParam.getHTTPUsername();
            String httpPassword = javaWSDLParam.getHTTPPassword();
            if (httpUsername != null && httpPassword != null) {
                wsdl2Java.setUser(httpUsername);
                Logger.printIndentedLine("-user " + httpUsername);
                wsdl2Java.setPassword(httpPassword);
                Logger.printIndentedLine("-password ***** (The password has been set but is hidden for logging)");
            }
            wsdl2Java.setNoDataBinding(javaWSDLParam.isNoDataBinding());
            if (javaWSDLParam.isNoDataBinding()) {
                Logger.printIndentedLine("-noDataBinding");
            }
            WebServiceWASInit.init();
            environment.getLog().log(1, 6999, (Object)this, "execute", (Object)("Calling WSDL2Java with role = " + javaWSDLParam.getRole() + " container = " + container + " for WSDL file " + wsdlURI));
            if (monitor != null) {
                monitor.beginTask(this.getMessage("MSG_PARSING_WSDL", wsdlURI), -1);
            }
            CommandToCommand newCmd = new CommandToCommand((Command)wsdl2Java, true, forceDoNotOverwriteLoadableClasses);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            IStatus emitterStatus = null;
            try {
                Thread.currentThread().setContextClassLoader(wsdl2Java.getClass().getClassLoader());
                newCmd.setEnvironment(environment);
                emitterStatus = newCmd.execute(monitor, adaptable);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            modifiedEmitterStatus = this.getModifiedEmitterStatus(emitterStatus);
            if (modifiedEmitterStatus.getSeverity() != 4 && javaWSDLParam.getTempJavaOutput() == null) {
                copyCmd = new CopyGeneratedJavaFilesCommand();
                copyCmd.setEnvironment(environment);
                copyCmd.setTargetPath(javaOutput);
                copyCmd.setSourceDir(tmpJavaOutputDir);
                copyCmd.setOmitFileList(javaWSDLParam.getIgnoredClassList());
                copyCmd.setProject(project);
                if (optimizedRole != null && optimizedRole.equals("client")) {
                    if (!WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isNoOverwriteLoadableClasses()) {
                        copyCmd.setOverwriteFile(true);
                    } else {
                        copyCmd.setPhysicalFileCheck(true);
                        copyCmd.setOverwriteFile(false);
                        copyCmd.setLoadableCheck(true);
                    }
                } else if (javaWSDLParam.isMetaInfOnly()) {
                    copyCmd.setPhysicalFileCheck(true);
                    copyCmd.setOverwriteFile(false);
                    copyCmd.setLoadableCheck(true);
                } else if (!WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isNoOverwriteLoadableClasses()) {
                    copyCmd.setOverwriteFile(true);
                } else {
                    copyCmd.setPhysicalFileCheck(true);
                    copyCmd.setOverwriteFile(false);
                    copyCmd.setLoadableCheck(true);
                }
                copyCmdStatus = copyCmd.execute(monitor, adaptable);
                try {
                    J2EEUtils.deleteTempDir((File)tmpJavaOutputDir);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                if (copyCmdStatus.getSeverity() == 4) {
                    return copyCmdStatus;
                }
            }
            if (modifiedEmitterStatus.getSeverity() != 0 && !"".equals(modifiedEmitterStatus.getMessage())) {
                block69: {
                    try {
                        environment.getStatusHandler().report(modifiedEmitterStatus);
                    }
                    catch (StatusException statusException) {
                        if (modifiedEmitterStatus.getSeverity() != 2) break block69;
                        return StatusUtils.errorStatus((String)"");
                    }
                }
                if (modifiedEmitterStatus.getSeverity() == 4) {
                    return modifiedEmitterStatus;
                }
            }
            if (javaWSDLParam.getDevelopCodeGenOnly()) {
                return modifiedEmitterStatus;
            }
            if (javaWSDLParam.getRole() == optimizedRole || javaWSDLParam.getScenario() != null) {
                return modifiedEmitterStatus;
            }
            wsdl2Java.setRole(deployRole);
            wsdl2Java.setGenJava("Overwrite");
            javaOutput = location;
            tmpJavaOutputDir = PlatformUtils.createTempDir((IProject)project);
            tmpJavaOutputURL = PlatformUtils.getFileURL((File)tmpJavaOutputDir);
            wsdl2Java.setJavaOutput(tmpJavaOutputURL);
            if (javaWSDLParam.getTempJavaOutput() != null) {
                wsdl2Java.setJavaOutput(javaWSDLParam.getTempJavaOutput());
            }
            try {
                Thread.currentThread().setContextClassLoader(wsdl2Java.getClass().getClassLoader());
                newCmd.setEnvironment(environment);
                emitterStatus = newCmd.execute(monitor, adaptable);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            modifiedEmitterStatus = this.getModifiedEmitterStatus(emitterStatus);
            if (modifiedEmitterStatus.getSeverity() != 4 && javaWSDLParam.getTempJavaOutput() == null) {
                copyCmd = new CopyGeneratedJavaFilesCommand();
                copyCmd.setEnvironment(environment);
                copyCmd.setTargetPath(javaOutput);
                copyCmd.setSourceDir(tmpJavaOutputDir);
                copyCmd.setOmitFileList(javaWSDLParam.getIgnoredClassList());
                copyCmd.setProject(project);
                copyCmd.setDerivedFile(true);
                copyCmdStatus = copyCmd.execute(monitor, adaptable);
                try {
                    J2EEUtils.deleteTempDir((File)tmpJavaOutputDir);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                if (copyCmdStatus.getSeverity() == 4) {
                    return copyCmdStatus;
                }
            }
            if (modifiedEmitterStatus.getSeverity() != 0 && !"".equals(modifiedEmitterStatus.getMessage())) {
                try {
                    environment.getStatusHandler().report(modifiedEmitterStatus);
                }
                catch (StatusException statusException) {
                    if (modifiedEmitterStatus.getSeverity() != 2) break block71;
                    return StatusUtils.errorStatus((String)"");
                }
            }
        }
        return modifiedEmitterStatus;
    }

    private IStatus getModifiedEmitterStatus(IStatus emitterStatus) {
        Object modifiedEmitterStatus = emitterStatus;
        if (emitterStatus != null && emitterStatus.getSeverity() != 0) {
            if (emitterStatus.getSeverity() == 8) {
                modifiedEmitterStatus = StatusUtils.errorStatus((String)"");
            }
            if (emitterStatus.getSeverity() == 4) {
                Throwable throwable = emitterStatus.getException();
                if (throwable != null) {
                    if (throwable instanceof IOException && ((IOException)throwable).getMessage().equals("ABORT")) {
                        modifiedEmitterStatus = StatusUtils.errorStatus((String)"");
                    } else {
                        String modifiedMessage = this.getMessage("MSG_ERROR_WSDL_JAVA_GENERATE");
                        modifiedEmitterStatus = emitterStatus.isMultiStatus() ? new MultiStatus(emitterStatus.getPlugin(), emitterStatus.getSeverity(), emitterStatus.getChildren(), modifiedMessage, null) : new Status(emitterStatus.getSeverity(), emitterStatus.getPlugin(), 0, modifiedMessage, emitterStatus.getException());
                    }
                } else if (emitterStatus.getPlugin() != null) {
                    String modifiedMessage = this.getMessage("MSG_ERROR_WSDL_JAVA_GENERATE");
                    modifiedEmitterStatus = emitterStatus.isMultiStatus() ? new MultiStatus(emitterStatus.getPlugin(), emitterStatus.getSeverity(), emitterStatus.getChildren(), modifiedMessage, null) : new Status(emitterStatus.getSeverity(), emitterStatus.getPlugin(), 0, modifiedMessage, null);
                }
            }
        }
        return modifiedEmitterStatus;
    }

    private HashMap reverseMap(HashMap originalMap) {
        if (originalMap == null) {
            return originalMap;
        }
        HashMap<String, String> newMap = new HashMap<String, String>();
        Set keys = originalMap.keySet();
        for (String packageName : keys) {
            String nameSpace = (String)originalMap.get(packageName);
            newMap.put(nameSpace, packageName);
        }
        return newMap;
    }

    private String getMessage(String messageId, String parm1) {
        String message = this.resource.getString(messageId);
        return MessageFormat.format(message, parm1);
    }

    private String getMessage(String key) {
        return this.resource.getString(key);
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParm) {
        this.emitterData_ = javaWSDLParm;
    }

    public String xmlNameToJava(String xmlName) {
        try {
            return JavaUtils.xmlNameToJava((String)xmlName);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

