/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.samples;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.webservice.was.samples.EARInfo;
import com.ibm.etools.webservice.was.samples.SamplesPlugin;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SetWASServerTargetOperation
extends WTPOperation {
    protected static final String NEW_RUNTIME_TYPE_ID = "com.ibm.ws.ast.st.runtime";
    private EARInfo[] earInfos_;
    private String j2eeLevel_;

    protected final void setEARInfos(EARInfo[] earInfos) {
        this.earInfos_ = new EARInfo[earInfos.length];
        System.arraycopy(earInfos, 0, this.earInfos_, 0, earInfos.length);
    }

    protected final void setJ2EELevel(String j2eeLevel) {
        this.j2eeLevel_ = j2eeLevel;
    }

    private final void collectProjectsForServerTargeting(Hashtable<String, IProject> targetedProjects, EARInfo earInfo) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String projectName = earInfo.getProjectName();
        IProject project = root.getProject(projectName);
        targetedProjects.put(projectName, project);
        EARArtifactEdit earArtifactEdit = null;
        try {
            earArtifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)project);
            IVirtualReference[] j2eeModuleReferences = earArtifactEdit.getJ2EEModuleReferences();
            int i = 0;
            while (i < j2eeModuleReferences.length) {
                IVirtualComponent j2eeComponent = j2eeModuleReferences[i].getReferencedComponent();
                project = j2eeComponent.getProject();
                targetedProjects.put(project.getName(), project);
                ++i;
            }
            IVirtualReference[] utilityReferences = earArtifactEdit.getUtilityModuleReferences();
            int i2 = 0;
            while (i2 < utilityReferences.length) {
                IVirtualComponent utilityComponent = utilityReferences[i2].getReferencedComponent();
                project = utilityComponent.getProject();
                targetedProjects.put(project.getName(), project);
                ++i2;
            }
        }
        finally {
            if (earArtifactEdit != null) {
                earArtifactEdit.dispose();
            }
        }
    }

    protected final void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IRuntime[] runtimes = ServerUtil.getRuntimes((String)"jst.ear", (String)this.j2eeLevel_);
        IRuntime nonStubServerRuntime = null;
        IRuntime stubServerRuntime = null;
        int i = 0;
        while (i < runtimes.length) {
            IRuntime serverRuntime = runtimes[i];
            if (WASRuntimeUtil.isWASv70Runtime((IRuntime)serverRuntime)) {
                if (!serverRuntime.isStub()) {
                    nonStubServerRuntime = serverRuntime;
                    break;
                }
                stubServerRuntime = serverRuntime;
            }
            ++i;
        }
        if (nonStubServerRuntime == null) {
            if (stubServerRuntime == null) {
                this.issueNoWASServerWarning();
            } else {
                this.setWASTarget(stubServerRuntime);
            }
        } else {
            this.setWASTarget(nonStubServerRuntime);
        }
    }

    private void setWASTarget(IRuntime serverRuntime) throws CoreException {
        Hashtable<String, IProject> targetedProjects = new Hashtable<String, IProject>();
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = FacetUtil.getRuntime((IRuntime)serverRuntime);
        HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> rtSet = new HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime>();
        rtSet.add(facetRuntime);
        int j = 0;
        while (j < this.earInfos_.length) {
            targetedProjects.clear();
            this.collectProjectsForServerTargeting(targetedProjects, this.earInfos_[j]);
            for (IProject project : targetedProjects.values()) {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null) {
                    facetedProject.setTargetedRuntimes(rtSet, (IProgressMonitor)new NullProgressMonitor());
                }
                facetedProject.setPrimaryRuntime(facetRuntime, (IProgressMonitor)new NullProgressMonitor());
            }
            ++j;
        }
    }

    private void issueNoWASServerWarning() {
        SamplesPlugin samplesPlugin = SamplesPlugin.getDefault();
        MessageBox mb = new MessageBox(samplesPlugin.getWorkbench().getActiveWorkbenchWindow().getShell(), 8);
        mb.setText(SamplesPlugin.getResourceString("TITLE_WARNING"));
        mb.setMessage(SamplesPlugin.getResourceString("MSG_WARNING_WASV70_SERVERTARGET_UNAVAILABLE"));
        mb.open();
    }
}

