/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.widgets;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBBindingsHelper;
import com.ibm.ejs.models.base.bindings.ejbbnd.EnterpriseBeanBinding;
import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.creation.ejb.common.util.EJBRouterComboUtil;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerHelper;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.SessionImpl;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.ejb.SessionType;
import org.eclipse.jst.javaee.ejb.TransactionType;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IContext;

public class BUEJBDefaultingCommand
extends AbstractDataModelOperation {
    private boolean isEJB = true;
    private byte mode = 1;
    private JavaWSDLParameterBase javaWSDLParam;
    private boolean forceBuild = true;
    private boolean customizeServiceMappings = false;
    private IProject ejbProject;
    private String homeInterfaceName;
    private String remoteInterfaceName;
    private String serviceEndpointName;
    private String ejbClassName;
    private String serviceProjectName;
    private String earProjectName;
    private String ejbName;
    private String ejbJndiName;
    private boolean isAnnotatedBean = false;
    private IContext ctx;
    private Boolean isProxyProject = Boolean.FALSE;

    public BUEJBDefaultingCommand() {
    }

    public BUEJBDefaultingCommand(IContext ctx) {
        this();
        this.ctx = ctx;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        return this.getEJBProjectFromInitialSelection(env, monitor);
    }

    private IStatus getEJBFromEJBArtifactEdit() {
        block13: {
            EJBArtifactEdit artifactEdit = null;
            try {
                artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)this.ejbProject);
                org.eclipse.jst.j2ee.ejb.EJBJar ejbJar = artifactEdit.getEJBJar();
                if (ejbJar == null) break block13;
                EList ejbs = ejbJar.getEnterpriseBeans();
                EnterpriseBean ejb = null;
                int i = 0;
                while (i < ejbs.size()) {
                    EnterpriseBean tmpEjb = (EnterpriseBean)ejbs.get(i);
                    if (tmpEjb.getName().equals(this.ejbName)) {
                        ejb = tmpEjb;
                    }
                    ++i;
                }
                this.isAnnotatedBean = AnnotationsControllerHelper.INSTANCE.isAnnotated(ejb);
                if (!ejb.isSession()) {
                    IStatus iStatus = StatusUtils.errorStatus((String)"MSG_EJB_NOT_SESSION");
                    return iStatus;
                }
                if (((SessionImpl)ejb).getSessionType() != org.eclipse.jst.j2ee.ejb.SessionType.STATELESS_LITERAL) {
                    IStatus iStatus = StatusUtils.errorStatus((String)"Selected EJB is not stateless EJB.");
                    return iStatus;
                }
                try {
                    this.ejbClassName = ejb.getEjbClassName();
                    this.serviceEndpointName = ((SessionImpl)ejb).getServiceEndpointName();
                    EnterpriseBeanBinding ejbBnd = EJBBindingsHelper.getEjbBinding((EnterpriseBean)ejb);
                    if (ejbBnd != null) {
                        this.ejbJndiName = ejbBnd.getJndiName();
                    }
                    this.homeInterfaceName = ejb.getHomeInterfaceName();
                    this.remoteInterfaceName = ejb.getRemoteInterfaceName();
                }
                catch (Exception exception) {}
            }
            finally {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus getEJBProjectFromInitialSelection(IEnvironment env, IProgressMonitor monitor) {
        IStatus status;
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.ejbProject);
        Object model = provider.getModelObject();
        if (model instanceof EJBJar) {
            EnterpriseBeans beans = ((EJBJar)model).getEnterpriseBeans();
            if (beans != null) {
                for (Object object : beans.getSessionBeans()) {
                    SessionBean ejb = (SessionBean)object;
                    if (!this.ejbName.equals(ejb.getEjbName())) continue;
                    this.ejbClassName = ejb.getEjbClass();
                    this.serviceEndpointName = ejb.getServiceEndpoint();
                    this.homeInterfaceName = ejb.getHome();
                    this.remoteInterfaceName = ejb.getRemote();
                }
            }
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)BUEJBDefaultingCommand.this.ejbProject);
                        Object model = provider.getModelObject((IPath)new Path("META-INF/ejb-jar.xml"));
                        final EJBJar ejbJar = (EJBJar)model;
                        provider.modify(new Runnable(){

                            public void run() {
                                if (ejbJar.getEnterpriseBeans() == null) {
                                    ejbJar.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
                                    SessionBean ejb = EjbFactory.eINSTANCE.createSessionBean();
                                    ejb.setEjbName(BUEJBDefaultingCommand.this.ejbName);
                                    ejb.setEjbClass(BUEJBDefaultingCommand.this.ejbClassName);
                                    ejb.setSessionType(SessionType.STATELESS_LITERAL);
                                    ejb.setTransactionType(TransactionType.CONTAINER_LITERAL);
                                    ejbJar.getEnterpriseBeans().getSessionBeans().add(ejb);
                                }
                            }
                        }, IModelProvider.FORCESAVE);
                    }
                }, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((status = this.getEJBFromEJBArtifactEdit()) != Status.OK_STATUS) {
            return status;
        }
        if (this.serviceEndpointName != null && this.serviceEndpointName.trim().length() >= 0) {
            this.javaWSDLParam.setSEIName(this.serviceEndpointName);
            this.javaWSDLParam.setGenerateSEIFile(false);
        }
        System.out.println("homeInterfaceName = " + this.homeInterfaceName);
        System.out.println("remoteInterfaceName = " + this.remoteInterfaceName);
        System.out.println("serviceEndpointName = " + this.serviceEndpointName);
        System.out.println("ejbJndiName = " + this.ejbJndiName);
        System.out.println("ejbClassName = " + this.ejbClassName);
        return Status.OK_STATUS;
    }

    public boolean getIsEJB() {
        return this.isEJB;
    }

    public String getEJBProjectName() {
        return this.serviceProjectName;
    }

    public boolean getCustomizeServiceMappings() {
        return false;
    }

    public boolean isCustomizeServiceMappings() {
        return this.customizeServiceMappings;
    }

    public Boolean getIsProxyProject() {
        return this.isProxyProject;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        if (this.ctx != null && !this.ctx.getDeploy()) {
            this.javaWSDLParam.setDevelopCodeGenOnly(true);
        }
        int styleAndUse = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().getSyleAndUse();
        switch (styleAndUse) {
            case 0: {
                this.javaWSDLParam.setStyle("DOCUMENT");
                this.javaWSDLParam.setUse("LITERAL");
                break;
            }
            case 1: {
                this.javaWSDLParam.setStyle("RPC");
                this.javaWSDLParam.setUse("LITERAL");
                break;
            }
            case 2: {
                this.javaWSDLParam.setStyle("RPC");
                this.javaWSDLParam.setUse("ENCODED");
                break;
            }
            default: {
                this.javaWSDLParam.setStyle("DOCUMENT");
                this.javaWSDLParam.setUse("LITERAL");
            }
        }
        int voidReturn = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().getVoidReturn();
        switch (voidReturn) {
            case 1: {
                this.javaWSDLParam.setVoidReturn("TWOWAY");
                break;
            }
            case 0: {
                this.javaWSDLParam.setVoidReturn("ONEWAY");
            }
        }
        int soapAction = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().getSoapAction();
        switch (soapAction) {
            case 2: {
                this.javaWSDLParam.setSoapAction("DEFAULT");
                break;
            }
            case 1: {
                this.javaWSDLParam.setSoapAction("NONE");
                break;
            }
            case 0: {
                this.javaWSDLParam.setSoapAction("OPERATION");
            }
        }
        boolean isMimeAttachment = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isMIME();
        if (isMimeAttachment) {
            this.javaWSDLParam.setMimeStyle("WSDL11");
        } else {
            this.javaWSDLParam.setMimeStyle("swaRef");
        }
        boolean httpBinding = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isHTTPBinding();
        boolean jmsBinding = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isJMSBinding();
        boolean ejbBinding = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isEJBBinding();
        StringBuffer bindingTypes = new StringBuffer();
        if (httpBinding) {
            bindingTypes.append("http");
        }
        if (jmsBinding) {
            if (bindingTypes.length() != 0) {
                bindingTypes.append(",");
            }
            bindingTypes.append("jms");
        }
        if (ejbBinding) {
            if (bindingTypes.length() != 0) {
                bindingTypes.append(",");
            }
            bindingTypes.append("ejb");
        }
        if (bindingTypes.length() == 0) {
            bindingTypes.append("http");
        }
        this.javaWSDLParam.setBindingTypes(bindingTypes.toString());
        String nameSpace = WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().getTargetNamespace();
        if (nameSpace != null && nameSpace.trim().length() > 0) {
            this.javaWSDLParam.setNamespace(nameSpace.trim());
        }
        this.javaWSDLParam.setWrapped(WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isWrapped());
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaParam) {
        this.javaWSDLParam = javaParam;
    }

    public IProject getEJBProject() {
        return this.ejbProject;
    }

    public String getHomeInterfaceName() {
        return this.homeInterfaceName;
    }

    public String getRemoteInterfaceName() {
        return this.remoteInterfaceName;
    }

    public String getServiceEndpointName() {
        return this.serviceEndpointName;
    }

    public String getServiceProject() {
        return this.serviceProjectName;
    }

    public void setServiceProject(String serviceProjectName) {
        this.serviceProjectName = serviceProjectName;
    }

    public byte getMode() {
        return this.mode;
    }

    public String getEarProjectName() {
        return this.earProjectName;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName = earProjectName;
    }

    public String getDefaultHttpRouterProjectName() {
        List httpComponents = EJBRouterComboUtil.getAppropriateHttpRouterProjects(this.earProjectName, this.getEJBProjectName());
        if (httpComponents.size() > 0) {
            return ((IVirtualComponent)httpComponents.get(0)).getProject().getName();
        }
        return String.valueOf(this.getEJBProjectName()) + "HttpRouter";
    }

    public String getDefaultJmsRouterProjectName() {
        List jmsComponents = EJBRouterComboUtil.getAppropriateJmsRouterProjects(this.earProjectName, this.getEJBProjectName());
        if (jmsComponents.size() > 0) {
            return ((IVirtualComponent)jmsComponents.get(0)).getProject().getName();
        }
        return String.valueOf(this.getEJBProjectName()) + "JmsRouter";
    }

    public String getEjbClassName() {
        return this.ejbClassName;
    }

    public String getEjbJndiName() {
        return this.ejbJndiName;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public void setEjbProject(IProject ejbProject) {
        this.ejbProject = ejbProject;
    }
}

