/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.util;

import com.ibm.etools.webservice.was.ext.model.WsbndArtifactEdit;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.wsbnd.RouterModule;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EJBRouterComboUtil {
    public static Combo createCombo(Composite parent, String labelText, String tooltipText) {
        String string = tooltipText = tooltipText == null ? labelText : tooltipText;
        if (labelText != null) {
            Label label = new Label(parent, 64);
            label.setText(labelText);
            label.setToolTipText(tooltipText);
        }
        Combo combo = new Combo(parent, 0);
        GridData griddata = new GridData(768);
        combo.setLayoutData((Object)griddata);
        combo.setToolTipText(tooltipText);
        return combo;
    }

    public static List getAvailableHttpRouterComponents(String earProjectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        return EJBRouterComboUtil.getAvailableHttpRouterComponents(earProject);
    }

    public static List getAvailableHttpRouterComponents(IProject earProject) {
        EARArtifactEdit artifactEdit = null;
        ArrayList<IVirtualComponent> compList = null;
        try {
            try {
                artifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
                IVirtualReference[] refList = artifactEdit.getJ2EEModuleReferences();
                compList = new ArrayList<IVirtualComponent>(refList.length);
                int i = 0;
                while (i < refList.length) {
                    IVirtualComponent referencedComponent = refList[i].getReferencedComponent();
                    if (J2EEUtils.isWebComponent((IVirtualComponent)referencedComponent)) {
                        compList.add(referencedComponent);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                Vector vector = new Vector();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
                return vector;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return compList;
    }

    public static List getAppropriateHttpRouterProjects(String earProjectName, String ejbProjectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        IProject ejbProject = root.getProject(ejbProjectName);
        return EJBRouterComboUtil.getAppropriateHttpRouterProjects(earProject, ejbProject);
    }

    public static List getAppropriateJmsRouterProjects(String earProjectName, String ejbProjectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        IProject ejbProject = root.getProject(ejbProjectName);
        return EJBRouterComboUtil.getAppropriateJmsRouterProjects(earProject, ejbProject);
    }

    public static Hashtable getRoutersForOtherEjbProjects(String earProjectName, String ejbProjectName, String transport) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        IProject ejbProject = root.getProject(ejbProjectName);
        return EJBRouterComboUtil.getRoutersForOtherEjbProjects(earProject, ejbProject, transport);
    }

    public static Hashtable getRoutersForOtherEjbProjects(IProject earProject, IProject ejbProject, String transport) {
        Hashtable<String, IVirtualComponent> routerForOtherEjbProject = new Hashtable<String, IVirtualComponent>();
        List allEjbProjects = EJBRouterComboUtil.getAvailableJmsRouterComponents(earProject);
        int i = 0;
        while (i < allEjbProjects.size()) {
            if (((IVirtualComponent)allEjbProjects.get(i)).getProject() != ejbProject) {
                String tmpRouterURI = EJBRouterComboUtil.getDefinedRouter(((IVirtualComponent)allEjbProjects.get(i)).getProject(), transport);
                IVirtualComponent router = null;
                if (tmpRouterURI != null && (router = EJBRouterComboUtil.getComponentByURI(earProject, tmpRouterURI)) != null) {
                    routerForOtherEjbProject.put(router.getProject().getName(), router);
                }
            }
            ++i;
        }
        return routerForOtherEjbProject;
    }

    public static List getAppropriateHttpRouterProjects(IProject earProject, IProject ejbProject) {
        Vector<IVirtualComponent> returnRouterList = new Vector<IVirtualComponent>();
        String routerURI = EJBRouterComboUtil.getDefinedRouter(ejbProject, "http");
        IVirtualComponent definedRouter = null;
        if (routerURI != null && (definedRouter = EJBRouterComboUtil.getComponentByURI(earProject, routerURI)) != null) {
            returnRouterList.add(definedRouter);
        }
        List allHttpRouters = EJBRouterComboUtil.getAvailableHttpRouterComponents(earProject);
        Hashtable routerForOtherEjbProject = EJBRouterComboUtil.getRoutersForOtherEjbProjects(earProject, ejbProject, "http");
        int i = 0;
        while (i < allHttpRouters.size()) {
            IVirtualComponent curRouter = (IVirtualComponent)allHttpRouters.get(i);
            if (!(definedRouter != null && definedRouter.getProject() == curRouter.getProject() || routerForOtherEjbProject.containsKey(curRouter.getProject().getName()))) {
                returnRouterList.add(curRouter);
            }
            ++i;
        }
        return returnRouterList;
    }

    public static List getAppropriateJmsRouterProjects(IProject earProject, IProject ejbProject) {
        Vector<IVirtualComponent> returnRouterList = new Vector<IVirtualComponent>();
        String routerURI = EJBRouterComboUtil.getDefinedRouter(ejbProject, "jms");
        IVirtualComponent definedRouter = null;
        if (routerURI != null && (definedRouter = EJBRouterComboUtil.getComponentByURI(earProject, routerURI)) != null) {
            returnRouterList.add(definedRouter);
        }
        List allJmsRouters = EJBRouterComboUtil.getAvailableJmsRouterComponents(earProject);
        Hashtable routerForOtherEjbProject = EJBRouterComboUtil.getRoutersForOtherEjbProjects(earProject, ejbProject, "jms");
        int i = 0;
        while (i < allJmsRouters.size()) {
            IVirtualComponent curRouter = (IVirtualComponent)allJmsRouters.get(i);
            if (!(definedRouter != null && definedRouter.getProject() == curRouter.getProject() || routerForOtherEjbProject.containsKey(curRouter.getProject().getName()) || ejbProject == null || ejbProject == curRouter.getProject())) {
                returnRouterList.add(curRouter);
            }
            ++i;
        }
        return returnRouterList;
    }

    public static IVirtualComponent getComponentByURI(IProject earProject, String uri) {
        EARArtifactEdit artifactEdit = null;
        IVirtualComponent comp = null;
        try {
            try {
                artifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
                comp = artifactEdit.getModuleByManifestURI(uri);
            }
            catch (Exception exception) {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return comp;
    }

    public static String getDefinedRouter(IProject ejbProject, String transport) {
        WsbndArtifactEdit artifactEdit = null;
        String routerURI = null;
        try {
            try {
                artifactEdit = WsbndArtifactEdit.getWSBNDArtifactEditForRead((IProject)ejbProject);
                WSBinding wsbnd = (WSBinding)artifactEdit.getDeploymentDescriptorRoot();
                EList routers = wsbnd.getRouterModules();
                int i = 0;
                while (i < routers.size()) {
                    RouterModule router = (RouterModule)routers.get(i);
                    if (transport.equals(router.getTransport())) {
                        routerURI = router.getName();
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return routerURI;
    }

    public static List getAvailableJmsRouterComponents(String earProjectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject earProject = root.getProject(earProjectName);
        return EJBRouterComboUtil.getAvailableJmsRouterComponents(earProject);
    }

    public static List getAvailableJmsRouterComponents(IProject earProject) {
        EARArtifactEdit artifactEdit = null;
        ArrayList<IVirtualComponent> compList = null;
        try {
            try {
                artifactEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
                IVirtualReference[] refList = artifactEdit.getJ2EEModuleReferences();
                compList = new ArrayList<IVirtualComponent>(refList.length);
                int i = 0;
                while (i < refList.length) {
                    IVirtualComponent referencedComponent = refList[i].getReferencedComponent();
                    if (J2EEUtils.isEJBComponent((IVirtualComponent)referencedComponent)) {
                        compList.add(referencedComponent);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                Vector vector = new Vector();
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
                return vector;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return compList;
    }

    public static String getSelectedRoutername(Combo routerCombo) {
        return routerCombo.getText();
    }

    public static IProject getSelectedAsProject(Combo routerCombo) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(routerCombo.getText());
        return project;
    }

    public static boolean isSelectedValidRouterProject(Combo routerCombo) {
        return true;
    }

    public static boolean isSelectedvalidRouterProject(Combo routerCombo, int type) {
        return true;
    }
}

