/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.task;

import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import com.ibm.etools.webservice.was.creation.ejb.common.messages.Messages;
import com.ibm.etools.webservice.was.creation.ejb.common.task.JMSURLParser;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.PlatformUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import com.ibm.etools.webservice.was.utils.WSDLCopierUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.util.WSDLCopier;
import org.eclipse.wst.wsdl.binding.soap.SOAPAddress;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;
import org.w3c.dom.Element;

public class WSDLEJBConfigArrivalTask
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaParameter_;
    private WebServicesParser wSParser;
    private String wSDLServiceURL;
    private String wSDLServicePathname;
    private String eJBProjectName;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        Status status;
        String wsPath = this.wSDLServiceURL;
        if (this.wSDLServiceURL != null && PlatformUtils.isPlatformURL((String)this.wSDLServiceURL)) {
            wsPath = PlatformUtils.getFileURLFromPlatform((String)this.wSDLServiceURL);
        }
        Port port2 = null;
        Definition definition = this.wSParser.getWSDLDefinition(wsPath);
        JMSURLParser jmsParser = null;
        if (definition == null) {
            return Status.OK_STATUS;
        }
        Collection services = definition.getServices().values();
        this.javaParameter_.setInputWsdlLocation(wsPath);
        this.javaParameter_.setServerSide((byte)2);
        this.javaParameter_.setJmsLocation(null);
        if (services.size() >= 1) {
            Service service = (Service)services.iterator().next();
            Collection ports = service.getPorts().values();
            boolean httpBinding = false;
            boolean jmsBinding = false;
            boolean ejbBinding = false;
            for (Port port2 : ports) {
                javax.wsdl.extensions.soap.SOAPAddress soapAddress = null;
                String ejbAddress = null;
                for (Object object : port2.getExtensibilityElements()) {
                    Element ele;
                    if (object instanceof javax.wsdl.extensions.soap.SOAPAddress) {
                        soapAddress = (javax.wsdl.extensions.soap.SOAPAddress)object;
                        break;
                    }
                    if (!(object instanceof UnknownExtensibilityElement) || (ele = ((UnknownExtensibilityElement)object).getElement()) == null || ele.getAttribute("location") == null) continue;
                    ejbAddress = ele.getAttribute("location");
                    break;
                }
                if (soapAddress != null) {
                    String location = soapAddress.getLocationURI();
                    if (location.startsWith("jms:")) {
                        jmsParser = new JMSURLParser();
                        try {
                            jmsParser.parse(location);
                            String serviceName = (String)jmsParser.get(jmsParser.TARGETSERVICE);
                            this.javaParameter_.setJmsLocation(location);
                            if (this.javaParameter_.getJ2eeLevel().equals("1.3")) {
                                this.javaParameter_.setMdbActivateName(String.valueOf(serviceName) + "Listener");
                            } else {
                                this.javaParameter_.setMdbActivateName("eis/" + serviceName + "ActivationSpec");
                            }
                            jmsBinding = true;
                            continue;
                        }
                        catch (MalformedURLException exc) {
                            return StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERROR_BAD_JMS_LOCATION, (Object[])new String[]{location}), (Throwable)exc);
                        }
                    }
                    httpBinding = true;
                    continue;
                }
                if (ejbAddress == null || !ejbAddress.startsWith("wsejb:")) continue;
                ejbBinding = true;
            }
            StringBuffer bindingTypes = new StringBuffer();
            if (httpBinding) {
                bindingTypes.append("http");
            }
            if (jmsBinding) {
                if (bindingTypes.length() != 0) {
                    bindingTypes.append(",");
                }
                bindingTypes.append("jms");
            }
            if (ejbBinding) {
                if (bindingTypes.length() != 0) {
                    bindingTypes.append(",");
                }
                bindingTypes.append("ejb");
            }
            if (bindingTypes.length() > 0) {
                this.javaParameter_.setInputWsdlLocation(wsPath);
                this.javaParameter_.setBindingTypes(bindingTypes.toString());
            }
            if (ports.size() == 0) {
                PortType portType = (PortType)definition.getPortTypes().values().iterator().next();
                Binding binding = (Binding)definition.getBindings().values().iterator().next();
                port2 = this.createPortInService(definition, service, binding, portType.getQName().getLocalPart());
                IProject project = ResourceUtils.getWorkspaceRoot().getProject(this.eJBProjectName);
                IStatus status2 = this.copyWSDLToTmp(wsPath, project, definition, monitor, adaptable);
                if (status2.getSeverity() == 0) {
                    this.javaParameter_.setBindingTypes("http");
                    this.javaParameter_.setInputWsdlLocation(status2.getMessage());
                }
            }
        } else {
            PortType portType = (PortType)definition.getPortTypes().values().iterator().next();
            Binding binding = (Binding)definition.getBindings().values().iterator().next();
            Service service = definition.createService();
            QName serviceQName = new QName(definition.getTargetNamespace(), String.valueOf(portType.getQName().getLocalPart()) + "Service");
            service.setQName(serviceQName);
            definition.addService(service);
            port2 = this.createPortInService(definition, service, binding, portType.getQName().getLocalPart());
            IProject project = ResourceUtils.getWorkspaceRoot().getProject(this.eJBProjectName);
            IStatus status3 = this.copyWSDLToTmp(wsPath, project, definition, monitor, adaptable);
            if (status3.getSeverity() == 0) {
                this.javaParameter_.setBindingTypes("http");
                this.javaParameter_.setInputWsdlLocation(status3.getMessage());
            }
        }
        if ((status = this.setupWSDLOutputLocation(port2)) != null) {
            return status;
        }
        this.javaParameter_.setServerSide((byte)2);
        return Status.OK_STATUS;
    }

    private Port createPortInService(Definition definition, Service service, Binding binding, String portName) {
        Port port = definition.createPort();
        service.addPort(port);
        port.setBinding(binding);
        port.setName(portName);
        SOAPAddress soapAddress = SOAPFactory.eINSTANCE.createSOAPAddress();
        soapAddress.setLocationURI("http://localhost:9080/");
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        return port;
    }

    private IStatus copyWSDLToTmp(String wsdlURL, IProject project, Definition definition, IProgressMonitor monitor, IAdaptable adaptable) {
        IPath relativePath;
        String tmpOutputDir = "";
        String destWsdlURI = wsdlURL;
        try {
            File outputDir = PlatformUtils.createTempDir((IProject)project);
            StringBuffer sb = new StringBuffer(outputDir.toURL().toString());
            tmpOutputDir = sb.toString();
            sb.append(WSDLUtils.getWSDLName((String)wsdlURL));
            destWsdlURI = sb.toString();
        }
        catch (Exception exception) {}
        WSDLCopier wsdlCopier = new WSDLCopier(this.wSParser);
        wsdlCopier.setSourceURI(WSDLCopierUtil.uriCreate((String)wsdlURL), definition);
        wsdlCopier.setTargetFolderURI(WSDLCopierUtil.uriCreate((String)WSDLCopierUtil.getBaseURI((String)destWsdlURI)));
        wsdlCopier.setTargetFilename(WSDLCopierUtil.getLocalname((String)destWsdlURI));
        IStatus status = WSDLCopierUtil.run((WSDLCopier)wsdlCopier, (IProgressMonitor)monitor);
        if (status != null && status.getSeverity() == 4) {
            return status;
        }
        if (status.getSeverity() == 0 && (relativePath = wsdlCopier.getRelativePath()).segmentCount() > 1) {
            StringBuffer sb = new StringBuffer(tmpOutputDir);
            sb.append(relativePath.toString());
            destWsdlURI = sb.toString();
        }
        return new Status(0, "com.ibm.etools.webservice.was.creation.ejb.common", destWsdlURI);
    }

    private Status setupWSDLOutputLocation(Port port) {
        IProject project = ResourceUtils.getWorkspaceRoot().getProject(this.eJBProjectName);
        IPath wsdlPath = project.getFullPath();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        wsdlPath = wsdlPath.append(ivFolder.getProjectRelativePath());
        String portName = port == null ? "portName" : port.getName();
        wsdlPath = wsdlPath.append("wsdl").append(portName).addFileExtension("wsdl");
        String wsdlLocation = PlatformUtils.getPlatformURL((IPath)wsdlPath);
        this.javaParameter_.setOutputWsdlLocation(wsdlLocation);
        this.wSDLServicePathname = wsdlPath.toString();
        return null;
    }

    public String getOutputWSDLFile() {
        int index = this.wSDLServiceURL.lastIndexOf(47);
        if (index == -1) {
            index = this.wSDLServiceURL.lastIndexOf(92);
        }
        return this.wSDLServiceURL.substring(index + 1, this.wSDLServiceURL.length());
    }

    public String getWSDLServicePathname() {
        return this.wSDLServicePathname;
    }

    public void setWSDLServicePathname(String servicePathname) {
        this.wSDLServicePathname = servicePathname;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setWSDLServiceURL(String serviceURL) {
        this.wSDLServiceURL = serviceURL;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.wSParser = parser;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaParameter_;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaParameter_ = javaWSDLParam;
    }
}

