/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.task;

import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JMSURLParser
extends Hashtable {
    private static final long serialVersionUID = -7582238397533513686L;
    public final String SOAPJMSINTEROPURLPREFIX = "jms:jndi:";
    public final String DESTINATION = "destination";
    public final String CONNECTIONFACTORY = "connectionFactory";
    public final String TARGETSERVICE = "targetService";
    public final String INITIALCONTEXTFACTORY = "initialContextFactory";
    public final String JNDIPROVIDERURL = "jndiProviderURL";
    public final String DELIVERYMODE = "deliveryMode";
    public final String TIMETOLIVE = "timeToLive";
    public final String PRIORITY = "priority";
    public final String USERID = "userid";
    public final String PASSWORD = "password";
    public final String JNDIINITIALCONTEXTFACTORY = "jndiInitialContextFactory";
    public final String JNDICONNECTIONFACTORYNAME = "jndiConnectionFactoryName";
    public final String REPLYTONAME = "replyToName";
    private boolean isQueue_ = true;
    private boolean isSoapJMSInteropURL = false;

    public void parse(String jmsUrl) throws MalformedURLException {
        if (jmsUrl == null || !jmsUrl.startsWith("jms:")) {
            throw new MalformedURLException(jmsUrl);
        }
        if (jmsUrl.startsWith("jms:jndi:")) {
            this.isSoapJMSInteropURL = true;
            this.parseNewJMSURL(jmsUrl);
        } else if (jmsUrl.startsWith("jms:/")) {
            this.isSoapJMSInteropURL = false;
            this.parseOldJMSURL(jmsUrl);
        } else {
            throw new MalformedURLException(jmsUrl);
        }
    }

    private void parseNewJMSURL(String jmsUrl) throws MalformedURLException {
        String tmpUrl = jmsUrl;
        try {
            tmpUrl = URLDecoder.decode(jmsUrl, "UTF-8");
        }
        catch (Exception e) {
            throw new MalformedURLException(e.getMessage());
        }
        int qMarkIndex = tmpUrl.indexOf("?");
        if (qMarkIndex == -1 && tmpUrl.length() > "jms:jndi:".length()) {
            this.put("destination", tmpUrl.substring("jms:jndi:".length()));
            return;
        }
        this.put("destination", tmpUrl.substring("jms:jndi:".length(), qMarkIndex));
        StringTokenizer st = new StringTokenizer(tmpUrl.substring(qMarkIndex + 1), "&");
        while (st.hasMoreTokens()) {
            String propertyValuePair = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(propertyValuePair, "=");
            if (st2.countTokens() != 2) {
                throw new MalformedURLException(jmsUrl);
            }
            String keyName = st2.nextToken();
            String value = st2.nextToken();
            this.put(keyName, value);
        }
    }

    private void parseOldJMSURL(String jmsUrl) throws MalformedURLException {
        String queueKind = jmsUrl.substring(5, 10);
        if (queueKind.equals("queue")) {
            this.isQueue_ = true;
        } else if (queueKind.equals("topic")) {
            this.isQueue_ = false;
        } else {
            throw new MalformedURLException(jmsUrl);
        }
        if (jmsUrl.charAt(10) != '?') {
            throw new MalformedURLException(jmsUrl);
        }
        int startIndex = 11;
        int endIndex = jmsUrl.length() - 1;
        while (startIndex < endIndex) {
            int equalsIndex = jmsUrl.indexOf("=", startIndex);
            if (equalsIndex == -1) {
                throw new MalformedURLException(jmsUrl);
            }
            String property = jmsUrl.substring(startIndex, equalsIndex);
            String value = null;
            int barIndex = jmsUrl.indexOf("&", equalsIndex);
            if (barIndex == -1) {
                startIndex = endIndex + 1;
                value = jmsUrl.substring(equalsIndex + 1, startIndex);
            } else {
                startIndex = barIndex + 1;
                value = jmsUrl.substring(equalsIndex + 1, barIndex);
            }
            this.put(property, value);
        }
        if (this.get("destination") == null || this.get("connectionFactory") == null || this.get("targetService") == null) {
            throw new MalformedURLException(jmsUrl);
        }
    }

    public String getJmsUrl() {
        if (this.isSoapJMSInteropURL) {
            return this.getNewJMSUrl();
        }
        return this.getOldJMSUrl();
    }

    private String getNewJMSUrl() {
        StringBuffer buf = new StringBuffer("jms:jndi:");
        buf.append(this.get("destination"));
        Enumeration properties = this.keys();
        while (properties.hasMoreElements()) {
            String property = (String)properties.nextElement();
            if (property.equals("destination")) continue;
            String value = (String)this.get(property);
            buf.append(property);
            buf.append('=');
            buf.append(value);
            if (!properties.hasMoreElements()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    private String getOldJMSUrl() {
        StringBuffer buf = new StringBuffer();
        buf.append("jms:/");
        if (this.isQueue_) {
            buf.append("queue");
        } else {
            buf.append("topic");
        }
        buf.append('?');
        Enumeration properties = this.keys();
        while (properties.hasMoreElements()) {
            String property = (String)properties.nextElement();
            String value = (String)this.get(property);
            buf.append(property);
            buf.append('=');
            buf.append(value);
            if (!properties.hasMoreElements()) continue;
            buf.append('&');
        }
        return buf.toString();
    }

    public void setIsQueue(boolean value) {
        this.isQueue_ = value;
    }

    public boolean isQueue() {
        return this.isQueue_;
    }

    public boolean isSoapJMSInteropURL() {
        return this.isSoapJMSInteropURL;
    }
}

