/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.command;

import com.ibm.etools.webservice.was.creation.ejb.common.messages.Messages;
import com.ibm.etools.webservice.was.creation.ejb.common.util.EJBRouterComboUtil;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class VerifyRouterProjectCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    private String httpRouterProject;
    private String jmsRouterProject;
    private IProject project;
    private IProject httpProject;
    private IProject jmsProject;
    private IProject ejbProject;
    private boolean httpBinding = false;
    private boolean jmsBinding = false;
    private boolean ejbBinding = false;
    private String earProjectName;
    private String ejbProjectName;

    public VerifyRouterProjectCommand() {
    }

    public VerifyRouterProjectCommand(String id) {
        this();
        this.setID(id);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        if (this.ejbBinding && !this.httpBinding && !this.jmsBinding) {
            return Status.OK_STATUS;
        }
        if ((this.httpRouterProject == null || this.httpRouterProject.equals("")) && (this.jmsRouterProject == null || this.jmsRouterProject.equals(""))) {
            IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_SPECIFY_ROUTER_PROJECT);
            env.getStatusHandler().reportError(status);
            return status;
        }
        boolean httpProjectExists = this.checkProjectExists(this.httpRouterProject);
        this.httpProject = this.project;
        boolean jmsProjectExists = this.checkProjectExists(this.jmsRouterProject);
        this.jmsProject = this.project;
        if (this.javaWSDLParam == null) {
            if (!this.checkIsWebProject() && !this.checkIsEJBProject()) {
                IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_ROUTER_NOT_WEB_OR_EJB);
                env.getStatusHandler().reportError(status);
                return status;
            }
        } else {
            IStatus status;
            if (this.httpBinding) {
                if (httpProjectExists && !this.checkIsWebProject()) {
                    IStatus status2 = StatusUtils.errorStatus((String)Messages.MSG_ERROR_ROUTER_NOT_WEB);
                    env.getStatusHandler().reportError(status2);
                    return status2;
                }
                if (this.anotherRouterDefined("http", String.valueOf(this.httpRouterProject) + ".war")) {
                    status = StatusUtils.warningStatus((String)Messages.MSG_WARNING_ROUTER_ALREADY_EXIST);
                    try {
                        env.getStatusHandler().report(status);
                    }
                    catch (StatusException statusException) {
                        return StatusUtils.errorStatus((String)"");
                    }
                }
            }
            if (this.jmsBinding) {
                if (jmsProjectExists && !this.checkIsEJBProject()) {
                    status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_ROUTER_NOT_EJB);
                    env.getStatusHandler().reportError(status);
                    return status;
                }
                if (this.anotherRouterDefined("jms", String.valueOf(this.jmsRouterProject) + ".jar")) {
                    status = StatusUtils.warningStatus((String)Messages.MSG_WARNING_ROUTER_ALREADY_EXIST);
                    try {
                        env.getStatusHandler().report(status);
                    }
                    catch (StatusException statusException) {
                        return StatusUtils.errorStatus((String)"");
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    private boolean anotherRouterDefined(String transport, String newRouterURI) {
        String existingRouterURI = EJBRouterComboUtil.getDefinedRouter(this.ejbProject, transport);
        if (existingRouterURI == null) {
            return false;
        }
        return !existingRouterURI.equals(newRouterURI);
    }

    private boolean checkProjectExists(String projectName) {
        try {
            this.project = FileResourceUtils.getWorkspaceRoot().getProject(projectName);
        }
        catch (Exception exception) {
            return false;
        }
        return this.project.exists();
    }

    private boolean checkIsWebProject() {
        try {
            return J2EEUtils.isWebProject((IProject)this.httpProject);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkIsEJBProject() {
        try {
            return J2EEUtils.isEJBProject((IProject)this.jmsProject);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        this.httpBinding = false;
        this.jmsBinding = false;
        this.ejbBinding = false;
        if (javaWSDLParam.getBindingTypes() != null) {
            int indexHttp = javaWSDLParam.getBindingTypes().indexOf("http");
            int indexJms = javaWSDLParam.getBindingTypes().indexOf("jms");
            int indexEjb = javaWSDLParam.getBindingTypes().indexOf("ejb");
            if (indexHttp != -1) {
                if (javaWSDLParam.getSwitchBinding()) {
                    this.jmsBinding = true;
                } else {
                    this.httpBinding = true;
                }
            }
            if (indexJms != -1) {
                if (javaWSDLParam.getSwitchBinding()) {
                    this.httpBinding = true;
                } else {
                    this.jmsBinding = true;
                }
            }
            if (indexEjb != -1) {
                this.ejbBinding = true;
            }
        } else if (javaWSDLParam.getTransport().equals("http")) {
            this.httpBinding = true;
        } else if (javaWSDLParam.getTransport().equals("jms")) {
            this.jmsBinding = true;
        }
    }

    public String getEarProjectName() {
        return this.earProjectName;
    }

    public IProject getHttpRouterProject() {
        return this.httpProject;
    }

    public IProject getJmsRouterProject() {
        return this.jmsProject;
    }

    public String getHttpRouterProjectName() {
        return this.httpRouterProject;
    }

    public String getJmsRouterProjectName() {
        return this.jmsRouterProject;
    }

    public void setHttpRouterProjectName(String routerProject) {
        this.httpRouterProject = routerProject;
    }

    public void setJmsRouterProjectName(String routerProject) {
        this.jmsRouterProject = routerProject;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName = earProjectName;
    }

    public void setEjbProjectName(String ejbProjectName) {
        this.ejbProjectName = ejbProjectName;
    }

    public void setEjbProject(IProject ejbProject) {
        this.ejbProject = ejbProject;
    }
}

