/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.command;

import com.ibm.etools.webservice.was.creation.ejb.common.messages.Messages;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class ValidateEJBJarXMLCommand
extends AbstractDataModelOperation {
    private String eJBProjectName;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = super.getEnvironment();
        IProject ejbProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.eJBProjectName);
        if (!J2EEUtils.isEJBProject((IProject)ejbProject)) {
            return Status.OK_STATUS;
        }
        EJBArtifactEdit artifactEdit = null;
        try {
            artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)ejbProject);
            EJBJar ejbJar = artifactEdit.getEJBJar();
            EList ejbs = ejbJar.getEnterpriseBeans();
            if (ejbs.size() == 0) {
                IStatus errorStatus = StatusUtils.errorStatus((String)Messages.bind((String)Messages.MSG_ERR_NO_EJB_DEFINED, (Object[])new String[]{this.eJBProjectName}));
                env.getStatusHandler().reportError(errorStatus);
                IStatus iStatus = errorStatus;
                return iStatus;
            }
        }
        catch (Exception e) {
            IStatus errorStatus = StatusUtils.errorStatus((Throwable)e);
            env.getStatusHandler().reportError(errorStatus);
            IStatus iStatus = errorStatus;
            return iStatus;
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    public void setEJBProjectName(String ejbProject) {
        this.eJBProjectName = ejbProject;
    }
}

