/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.command;

import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.consumption.util.WSDLUtils;
import com.ibm.etools.webservice.was.creation.ejb.common.messages.Messages;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.SessionType;
import org.eclipse.jst.j2ee.ejb.TransactionType;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class UpdateEJBJarXMLCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    private final String SUFFIX_REMOTE_INTERFACE = "_RI";
    private final String SUFFIX_HOME = "Home";
    private final String NAME_COLLISION_PORT = "_Port";
    private WebServicesParser wSParser;
    private String eJBProjectName;
    private IProject ejbProject;
    private Hashtable namespaceToPackageMapping;
    private Hashtable portTypeToSEIMapping;
    private boolean addRemoteClientView = true;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus checkInitStatus = this.checkInitialState();
        if (checkInitStatus != null) {
            return checkInitStatus;
        }
        IStatus findResourceStatus = this.findResourceFile(monitor);
        if (findResourceStatus != null) {
            return findResourceStatus;
        }
        EJBArtifactEdit artifactEdit = null;
        try {
            try {
                this.ejbProject = ResourceUtils.getWorkspaceRoot().getProject(this.eJBProjectName);
                artifactEdit = EJBArtifactEdit.getEJBArtifactEditForWrite((IProject)this.ejbProject);
                boolean isJ2ee14 = artifactEdit.getJ2EEVersion() == 14;
                org.eclipse.jst.j2ee.ejb.EJBJar ejbJar = artifactEdit.getEJBJar();
                if (ejbJar == null) {
                    ejbJar = (org.eclipse.jst.j2ee.ejb.EJBJar)artifactEdit.createModelRoot(isJ2ee14 ? 21 : 30);
                }
                EList ejbs = ejbJar.getEnterpriseBeans();
                EjbFactoryImpl ejbFactory = new EjbFactoryImpl();
                Map wsdlPort2ImplBeanMapping = this.javaWSDLParam.getWSDLPort2ImplBeanMapping();
                HashMap ns2pkgMapping = this.javaWSDLParam.getMappings();
                for (Port port : wsdlPort2ImplBeanMapping.keySet()) {
                    String ejbPackage;
                    Service service = this.getService(port);
                    PortType portType = port.getBinding().getPortType();
                    String portTypeName = portType.getQName().getLocalPart();
                    String seiName = this.getSEIName(portType.getQName().getNamespaceURI(), portType.getQName().getLocalPart());
                    portTypeName = String.valueOf(portTypeName.substring(0, 1).toUpperCase()) + portTypeName.substring(1);
                    String ejbClass = (String)wsdlPort2ImplBeanMapping.get(port);
                    String ejbName = ejbClass;
                    int index = ejbName.lastIndexOf(46);
                    if (index != -1) {
                        ejbName = ejbName.substring(index + 1);
                    }
                    if ((ejbPackage = this.getPackageName(portType.getQName().getNamespaceURI())) == null) {
                        ejbPackage = WSDLUtils.getPackageName((PortType)portType, (Map)ns2pkgMapping);
                    }
                    StringBuffer ejbInterfaceName = new StringBuffer(WSDLUtils.resolveDotInPortName((String)portTypeName));
                    if (service != null && ejbInterfaceName.toString().equals(service.getQName().getLocalPart())) {
                        String servicePackage = this.getPackageName(service.getQName().getNamespaceURI());
                        if (servicePackage == null) {
                            servicePackage = WSDLUtils.getPackageName((Service)service, (Map)ns2pkgMapping);
                        }
                        if (ejbPackage.equals(servicePackage)) {
                            if (this.javaWSDLParam.getJ2eeLevel().equals("1.3")) {
                                ejbInterfaceName.append("_Port");
                            } else {
                                ejbInterfaceName.append("_PortType");
                            }
                        }
                    }
                    String ejbHome = null;
                    String ejbRemote = null;
                    if (seiName == null) {
                        ejbHome = new StringBuffer(ejbPackage).append(".").append(ejbInterfaceName).append("Home").toString();
                        ejbRemote = new StringBuffer(ejbPackage).append(".").append(ejbInterfaceName).append("_RI").toString();
                    } else {
                        ejbHome = new StringBuffer(seiName).append("Home").toString();
                        ejbRemote = new StringBuffer(seiName).append("_RI").toString();
                    }
                    if (this.ejbExists(ejbName, ejbHome, ejbRemote, ejbClass, (List)ejbs)) continue;
                    Session sessionBean = ejbFactory.createSession();
                    sessionBean.setName(ejbName);
                    if (!isJ2ee14 || isJ2ee14 && this.addRemoteClientView) {
                        sessionBean.setHomeInterfaceName(ejbHome);
                        sessionBean.setRemoteInterfaceName(ejbRemote);
                    }
                    sessionBean.setEjbClassName(ejbClass);
                    sessionBean.setSessionType(SessionType.STATELESS_LITERAL);
                    sessionBean.setTransactionType(TransactionType.CONTAINER_LITERAL);
                    if (isJ2ee14) {
                        if (seiName == null) {
                            sessionBean.setServiceEndpointName(new StringBuffer(ejbPackage).append(".").append(ejbInterfaceName).toString());
                        } else {
                            sessionBean.setServiceEndpointName(seiName);
                        }
                    }
                    ejbs.add(sessionBean);
                }
                artifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                IStatus iStatus = StatusUtils.errorStatus((String)Messages.MSG_ERROR_EJB_JAR_XML_UPDATING, (Throwable)e);
                if (artifactEdit != null) {
                    artifactEdit.dispose();
                }
                return iStatus;
            }
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        return Status.OK_STATUS;
    }

    private Service getService(Port port) {
        Definition def;
        String wsdlURI = this.javaWSDLParam.getInputWsdlLocation();
        if (wsdlURI.indexOf(58) < 0 || wsdlURI.indexOf("platform:/resource") >= 0) {
            wsdlURI = PlatformUtils.getFileURLFromPlatform((String)wsdlURI);
        }
        if (this.wSParser == null) {
            this.wSParser = new WebServicesParserExt(wsdlURI);
        }
        if ((def = this.wSParser.getWSDLDefinition(wsdlURI)) != null) {
            Map services = def.getServices();
            for (Service service : services.values()) {
                if (service.getPort(port.getName()) == null) continue;
                return service;
            }
        }
        return null;
    }

    private boolean ejbExists(String ejbName, String ejbHome, String ejbRemote, String ejbClass, List ejbs) {
        int i = 0;
        while (i < ejbs.size()) {
            Session sessionBean;
            Object object = ejbs.get(i);
            if (object instanceof Session && ejbName.equals((sessionBean = (Session)object).getName()) && ejbHome.equals(sessionBean.getHomeInterfaceName()) && ejbRemote.equals(sessionBean.getRemoteInterfaceName()) && ejbClass.equals(sessionBean.getEjbClassName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IStatus checkInitialState() {
        boolean isEJB;
        if (this.javaWSDLParam == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
        }
        boolean bl = isEJB = this.javaWSDLParam.getServerSide() == 2;
        if (!isEJB) {
            return Status.OK_STATUS;
        }
        return null;
    }

    private IStatus findResourceFile(IProgressMonitor monitor) {
        IVirtualFile ivFile;
        this.ejbProject = ResourceUtils.getWorkspaceRoot().getProject(this.eJBProjectName);
        if (this.ejbProject == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_SERVICE_PROJECT_NOT_FOUND);
        }
        this.ejbProject.getFullPath();
        IVirtualFolder ivFolder = null;
        if (J2EEUtils.isEJBProject((IProject)this.ejbProject)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)this.ejbProject);
            ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        }
        if (!(ivFile = ivFolder.getFile("ejb-jar.xml")).exists()) {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)UpdateEJBJarXMLCommand.this.ejbProject);
                        Object model = provider.getModelObject((IPath)new Path("META-INF/ejb-jar.xml"));
                        final EJBJar ejbJar = (EJBJar)model;
                        provider.modify(new Runnable(){

                            public void run() {
                                if (ejbJar.getEnterpriseBeans() == null) {
                                    ejbJar.setEnterpriseBeans(EjbFactory.eINSTANCE.createEnterpriseBeans());
                                    System.out.println("ejb-jar.xml creation for EJB 3.0");
                                }
                            }
                        }, IModelProvider.FORCESAVE);
                    }
                }, monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public WebServicesParser getWSParser() {
        return this.wSParser;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.wSParser = parser;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    private String getPackageName(String namespace) {
        if (this.namespaceToPackageMapping != null && namespace != null) {
            return (String)this.namespaceToPackageMapping.get(namespace);
        }
        return null;
    }

    private String getSEIName(String namespace, String localPart) {
        if (this.portTypeToSEIMapping != null && namespace != null && localPart != null) {
            return (String)this.portTypeToSEIMapping.get(String.valueOf(namespace) + ":" + localPart);
        }
        return null;
    }

    public void setNamespaceToPackageMapping(Hashtable namespaceToPackageMapping) {
        this.namespaceToPackageMapping = namespaceToPackageMapping;
    }

    public void setPortTypeToSEIMapping(Hashtable portTypeToSEIMapping) {
        this.portTypeToSEIMapping = portTypeToSEIMapping;
    }

    public void setAddRemoteClientView(boolean addRemoteClientView) {
        this.addRemoteClientView = addRemoteClientView;
    }
}

