/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.util;

import com.ibm.etools.webedit.common.commands.utils.EditQueryUtil;
import com.ibm.etools.webedit.viewer.utils.ModelAdapterFactoryRegistry;
import com.ibm.etools.webedit.viewer.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.TemplateFacetInstallDataModelProvider;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.html.core.internal.modelquery.DocumentQuery;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TemplateFacetUtil {
    public static final String TEMPLATE_FACET_NAME = "web.template";
    public static final String PORTLET_JSR168_FACET_ID = "jsr168.base";

    public static boolean installTemplateFacet(IProject project) {
        return TemplateFacetUtil.installTemplateFacet(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean installTemplateFacet(IProject project, IProgressMonitor monitor) {
        IStatus result;
        block6: {
            if (project == null) {
                return false;
            }
            result = IDataModelProvider.OK_STATUS;
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)TEMPLATE_FACET_NAME);
            if (!facetedProject.hasProjectFacet(facet)) break block6;
            return true;
        }
        try {
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
            IDataModel templateModel = DataModelFactory.createDataModel((IDataModelProvider)new TemplateFacetInstallDataModelProvider());
            templateModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            map.add(templateModel);
            result = model.getDefaultOperation().execute(monitor, null);
        }
        catch (CoreException coreException) {
            return false;
        }
        catch (ExecutionException executionException) {
            return false;
        }
        catch (Exception e) {
            Logger.log(e.toString());
            return false;
        }
        return result.isOK();
    }

    public static boolean hasTemplateFacet(IProject project) {
        IFacetedProject facetedProject;
        block5: {
            if (project == null) {
                return false;
            }
            facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null) break block5;
            return false;
        }
        try {
            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)TEMPLATE_FACET_NAME);
            return facetedProject.hasProjectFacet(facet);
        }
        catch (CoreException coreException) {
            return false;
        }
        catch (Exception e) {
            Logger.log(e.toString());
            return false;
        }
    }

    public static boolean isInPortletProject(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject == null) {
                return false;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        catch (Exception e) {
            Logger.log(e.toString());
            return false;
        }
        if (ProjectFacetsManager.isProjectFacetDefined((String)PORTLET_JSR168_FACET_ID)) {
            IProjectFacet jsrPortletFacet = ProjectFacetsManager.getProjectFacet((String)PORTLET_JSR168_FACET_ID);
            return facetedProject.hasProjectFacet(jsrPortletFacet);
        }
        return false;
    }

    public static boolean hasHtmlTagInFile(IFile file) {
        boolean isFragment;
        block12: {
            if (file == null) {
                return false;
            }
            if (FileTypeHandler.getFileType(file) == "html") {
                return true;
            }
            isFragment = false;
            IStructuredModel sedModel = null;
            try {
                try {
                    IDOMDocument doc = null;
                    sedModel = StructuredModelManager.getModelManager().getModelForRead(file);
                    if (sedModel != null && ModelManagerUtil.isHTMLFamily((IStructuredModel)sedModel)) {
                        ModelAdapterFactoryRegistry.registerAdapterFactories((IStructuredModel)sedModel);
                        doc = ((IDOMModel)sedModel).getDocument();
                        DocumentQuery query = EditQueryUtil.getDocumentQuery((Node)doc);
                        if (query != null) {
                            isFragment = query.isFragment((Document)doc);
                        }
                    }
                }
                catch (Exception exception) {
                    if (sedModel != null) {
                        sedModel.releaseFromRead();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (sedModel != null) {
                    sedModel.releaseFromRead();
                }
                throw throwable;
            }
            if (sedModel != null) {
                sedModel.releaseFromRead();
            }
        }
        return !isFragment;
    }
}

