/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.readonly;

import com.ibm.etools.webpage.template.readonly.ReadOnlyController;
import java.util.Vector;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ReadOnlyNodeAdapter
implements INodeAdapter {
    public static final Class ADAPTER_KEY = ReadOnlyNodeAdapter.class;
    private boolean disable;
    private Vector updatingDocuments = new Vector(3);

    ReadOnlyNodeAdapter() {
    }

    public boolean isAdapterForType(Object type) {
        return type.equals(ADAPTER_KEY);
    }

    private static Document getSafeDocument(Object obj) {
        if (obj instanceof Node) {
            Node node = (Node)obj;
            if (node.getNodeType() == 9) {
                return (Document)obj;
            }
            return node.getOwnerDocument();
        }
        return null;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        Document doc = ReadOnlyNodeAdapter.getSafeDocument(notifier);
        if (doc != null) {
            if (this.updatingDocuments.contains(doc)) {
                return;
            }
            this.updatingDocuments.add(doc);
        }
        try {
            switch (eventType) {
                case 2: {
                    if (newValue instanceof IDOMNode) {
                        this.addAdapter((IDOMNode)newValue);
                    }
                    break;
                }
                case 3: {
                    if (oldValue instanceof IDOMNode) {
                        this.removeAdapter((IDOMNode)oldValue);
                    }
                    break;
                }
                case 4: {
                    if (notifier instanceof IDOMNode) {
                        this.setReadOnly((IDOMNode)notifier);
                    }
                    break;
                }
            }
        }
        finally {
            this.updatingDocuments.remove(doc);
        }
    }

    public void setReadOnly(IDOMDocument document) {
        this.disable = false;
        ReadOnlyController.setReadOnly(document);
    }

    public void removeReadOnly(IDOMDocument document) {
        this.disable = true;
        ReadOnlyController.removeReadOnly(document);
    }

    private void setReadOnly(IDOMNode node) {
        if (this.disable) {
            return;
        }
        ReadOnlyController.setReadOnly(node);
    }

    private void addAdapter(IDOMNode node) {
        INodeAdapter adapter = node.getExistingAdapter((Object)ADAPTER_KEY);
        if (adapter == null) {
            node.addAdapter((INodeAdapter)this);
        }
    }

    private void removeAdapter(IDOMNode node) {
        INodeAdapter adapter = node.getExistingAdapter((Object)ADAPTER_KEY);
        if (adapter != null) {
            node.removeAdapter(adapter);
        }
    }
}

