/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.readonly;

import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NodeList;

public class ReadOnlyController {
    private static final String INSERT_TAG = "tpl:insert";
    private static final String PUT_TAG = "tpl:put";
    private static final String SITE_NAVBAR = "siteedit:navbar";
    private static final String SITE_NAVTAB = "siteedit:navtab";
    private static final String SITE_NAVTRAIL = "siteedit:navtrail";
    private static final String SITE_NAVMENU = "siteedit:navmenu";
    private static final String SITE_SITEMAP = "siteedit:sitemap";

    public static void setReadOnly(IDOMDocument document) {
        ReadOnlyController.setReadOnlyForPutChildren(document.getChildNodes());
    }

    public static void setReadOnly(IDOMNode node) {
        IDOMNode parent = (IDOMNode)node.getParentNode();
        if (parent == null) {
            ReadOnlyController.setReadOnlyForPutChild(node);
        } else {
            if (ReadOnlyController.needsAttributeReadOnly(node)) {
                node.setDataEditable(false);
            }
            if (ReadOnlyController.needsChildrenReadOnly(node)) {
                node.setChildEditable(false);
                ReadOnlyController.setReadOnlyForInsertChildren(node.getChildNodes());
            } else if (ReadOnlyController.needsChildrenEditable(node)) {
                ReadOnlyController.setReadOnlyForPutChildren(node.getChildNodes());
            } else if (ReadOnlyController.needsChildrenReadOnly(parent)) {
                ReadOnlyController.setReadOnlyForInsertChild(node);
            } else if (ReadOnlyController.needsChildrenEditable(parent)) {
                ReadOnlyController.setReadOnlyForPutChild(node);
            } else if (!parent.isChildEditable() && !parent.isDataEditable()) {
                node.setEditable(false, false);
                ReadOnlyController.setReadOnlyForInsertChild(node);
            } else {
                ReadOnlyController.setReadOnlyForPutChild(node);
            }
        }
    }

    public static void removeReadOnly(IDOMDocument document) {
        IDOMNode child = (IDOMNode)document.getFirstChild();
        while (child != null) {
            child.setEditable(true, true);
            child = (IDOMNode)child.getNextSibling();
        }
    }

    private static void setReadOnlyForPutChildren(NodeList nodelist) {
        int len = nodelist.getLength();
        int i = 0;
        while (i < len) {
            IDOMNode node = (IDOMNode)nodelist.item(i);
            if (ReadOnlyController.needsAttributeReadOnly(node)) {
                node.setDataEditable(false);
            }
            if (ReadOnlyController.needsChildrenReadOnly(node)) {
                node.setChildEditable(false);
                ReadOnlyController.setReadOnlyForInsertChildren(node.getChildNodes());
            } else {
                ReadOnlyController.setReadOnlyForPutChildren(node.getChildNodes());
            }
            ++i;
        }
    }

    private static void setReadOnlyForInsertChildren(NodeList nodelist) {
        int len = nodelist.getLength();
        int i = 0;
        while (i < len) {
            IDOMNode node = (IDOMNode)nodelist.item(i);
            ReadOnlyController.setReadOnlyForInsertChild(node);
            ++i;
        }
    }

    private static void setReadOnlyForInsertChild(IDOMNode node) {
        if (ReadOnlyController.needsAttributeReadOnly(node)) {
            node.setDataEditable(false);
        }
        if (ReadOnlyController.needsChildrenReadOnly(node)) {
            node.setChildEditable(false);
            ReadOnlyController.setReadOnlyForInsertChildren(node.getChildNodes());
        } else if (ReadOnlyController.needsChildrenEditable(node)) {
            ReadOnlyController.setReadOnlyForPutChildren(node.getChildNodes());
        } else {
            node.setEditable(false, false);
            ReadOnlyController.setReadOnlyForInsertChildren(node.getChildNodes());
        }
    }

    private static void setReadOnlyForPutChild(IDOMNode node) {
        if (ReadOnlyController.needsAttributeReadOnly(node)) {
            node.setDataEditable(false);
        }
        if (ReadOnlyController.needsChildrenReadOnly(node)) {
            node.setChildEditable(false);
            ReadOnlyController.setReadOnlyForInsertChildren(node.getChildNodes());
        } else {
            ReadOnlyController.setReadOnlyForPutChildren(node.getChildNodes());
        }
    }

    private static boolean needsChildrenReadOnly(IDOMNode node) {
        if (node instanceof IDOMElement && ((IDOMElement)node).isCommentTag()) {
            String name = node.getNodeName();
            if (name.equals(INSERT_TAG) && node.getAttributes().getNamedItem("page") != null) {
                return true;
            }
            if (ReadOnlyController.isSiteTag(node)) {
                return true;
            }
        }
        return false;
    }

    private static boolean needsChildrenEditable(IDOMNode node) {
        return node.getNodeName().equals(PUT_TAG) && node instanceof IDOMElement && ((IDOMElement)node).isCommentTag() && ReadOnlyController.searchInsertPageAbove(node) == ReadOnlyController.searchPutNameAbove(node) + 1;
    }

    private static int searchPutNameAbove(IDOMNode node) {
        IDOMNode parent = (IDOMNode)node.getParentNode();
        int putNameAbove = 0;
        while (parent != null) {
            if (parent instanceof IDOMElement && ((IDOMElement)parent).isCommentTag() && parent.getNodeName().equals(PUT_TAG) && ((IDOMElement)parent).getAttributeNode("name") != null) {
                ++putNameAbove;
            }
            parent = (IDOMNode)parent.getParentNode();
        }
        return putNameAbove;
    }

    private static int searchInsertPageAbove(IDOMNode node) {
        IDOMNode parent = (IDOMNode)node.getParentNode();
        int insertPageAbove = 0;
        while (parent != null) {
            if (parent instanceof IDOMElement && ((IDOMElement)parent).isCommentTag() && parent.getNodeName().equals(INSERT_TAG) && ((IDOMElement)parent).getAttributeNode("page") != null) {
                ++insertPageAbove;
            }
            parent = (IDOMNode)parent.getParentNode();
        }
        return insertPageAbove;
    }

    private static boolean needsAttributeReadOnly(IDOMNode node) {
        if (node instanceof IDOMElement && ((IDOMElement)node).isCommentTag()) {
            if (node.getNodeName().equals(PUT_TAG) && ReadOnlyController.isInsideInsertTag(node)) {
                return true;
            }
            if (node.getNodeName().equals(INSERT_TAG) && ReadOnlyController.isInsideInsertTag(node)) {
                return true;
            }
            if (ReadOnlyController.isSiteTag(node) && ReadOnlyController.isInsideInsertTag(node)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideInsertTag(IDOMNode node) {
        return ReadOnlyController.searchInsertPageAbove(node) > ReadOnlyController.searchPutNameAbove(node);
    }

    private static boolean isSiteTag(IDOMNode node) {
        if (node instanceof IDOMElement && ((IDOMElement)node).isCommentTag()) {
            String name = node.getNodeName();
            return name.equals(SITE_NAVBAR) || name.equals(SITE_NAVTAB) || name.equals(SITE_NAVTRAIL) || name.equals(SITE_SITEMAP) || name.equals(SITE_NAVMENU);
        }
        return false;
    }
}

