/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.model.util;

import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TplContainer;
import com.ibm.etools.webpage.template.model.TplGet;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplRoot;
import com.ibm.etools.webpage.template.model.TplTemplate;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class TemplateModelUtil {
    public static void collectGetNode(TplNode node, List list) {
        TemplateModelUtil.collectTypedNode(node, list, (short)4);
    }

    public static void collectGetAndMetadataNode(TplNode node, List list) {
        TemplateModelUtil.collectTypedNode(node, list, (short)36);
    }

    public static List collectGetNode(TemplateModel model) {
        if (model == null) {
            return null;
        }
        ArrayList getNodes = new ArrayList();
        TemplateModelUtil.collectGetNode(model.getRoot(), getNodes);
        return getNodes;
    }

    public static TplGet findGetNodeOf(TemplateModel model, String name) {
        if (name == null) {
            return null;
        }
        List getNodes = TemplateModelUtil.collectGetNode(model);
        if (getNodes != null && getNodes.size() > 0) {
            for (TplGet getNode : getNodes) {
                if (!name.equals(getNode.getName())) continue;
                return getNode;
            }
        }
        return null;
    }

    public static TplNode findTemplateNodeOf(TemplateModel model) {
        return TemplateModelUtil.findTemplateNodeOf(model, true);
    }

    public static TplNode findTemplateNodeOf(TemplateModel model, boolean strict) {
        TplRoot root;
        if (model == null) {
            return null;
        }
        if (!TemplateModelUtil.hasInclusion(model.getRoot())) {
            return null;
        }
        int type = 2;
        if (!strict) {
            type = (short)(type | 0x10);
        }
        if ((root = model.getRoot()).getContentNodeList().getLength() <= 0) {
            return null;
        }
        TplNode firstNode = root.getContentNodeList().item(0);
        if ((firstNode.getNodeType() & type) != 0) {
            return firstNode;
        }
        if ((firstNode.getNodeType() & 0x20) != 0 && root.getContentNodeList().getLength() > 1) {
            return root.getContentNodeList().item(1);
        }
        return null;
    }

    public static boolean canRebuild(TemplateModel model) {
        if (model == null) {
            return false;
        }
        return TemplateModelUtil.hasInclusion(model.getRoot());
    }

    private static boolean hasInclusion(TplNode node) {
        if (node == null) {
            return false;
        }
        if ((node.getNodeType() & 9) != 0) {
            TplNodeList list = ((TplContainer)((Object)node)).getContentNodeList();
            int i = 0;
            while (i < list.getLength()) {
                if (TemplateModelUtil.hasInclusion(list.item(i))) {
                    return true;
                }
                ++i;
            }
        } else if ((node.getNodeType() & 0x12) != 0) {
            return true;
        }
        return false;
    }

    public static TplNode findTplNodeOf(TemplateModel model, Node node) {
        return TemplateModelUtil.findTplNodeOf(model.getRoot(), node);
    }

    private static TplNode findTplNodeOf(TplNode tplParent, Node node) {
        TplNodeList tplNodes = null;
        if ((tplParent.getNodeType() & 9) != 0) {
            tplNodes = ((TplContainer)((Object)tplParent)).getContentNodeList();
        } else if (tplParent.getNodeType() == 2) {
            tplNodes = ((TplTemplate)tplParent).getPutList();
        }
        if (tplNodes == null) {
            return null;
        }
        int i = 0;
        while (i < tplNodes.getLength()) {
            TplNode tplNode = tplNodes.item(i);
            if (tplNode != null && tplNode.getRefNode().getDomNode().equals(node)) {
                return tplNode;
            }
            if ((tplNode = TemplateModelUtil.findTplNodeOf(tplNode, node)) != null) {
                return tplNode;
            }
            ++i;
        }
        return null;
    }

    public static List collectPutNode(TemplateModel model) {
        if (model == null) {
            return null;
        }
        ArrayList getNodes = new ArrayList();
        TemplateModelUtil.collectPutNode(model.getRoot(), getNodes);
        return getNodes;
    }

    public static void collectPutNode(TplNode node, List list) {
        TemplateModelUtil.collectTypedNode(node, list, (short)8);
    }

    public static List collectInclusionNode(TemplateModel model) {
        if (model == null) {
            return null;
        }
        ArrayList inclusionNodes = new ArrayList();
        TemplateModelUtil.collectInclusionNode(model.getRoot(), inclusionNodes);
        return inclusionNodes;
    }

    public static void collectInclusionNode(TplNode node, List list) {
        TemplateModelUtil.collectTypedNode(node, list, (short)18);
    }

    public static void collectTypedNode(TplNode node, List list, short type) {
        if (node == null || list == null) {
            return;
        }
        TplNodeList nodeList = null;
        if ((node.getNodeType() & 9) != 0) {
            nodeList = ((TplContainer)((Object)node)).getContentNodeList();
        } else if ((node.getNodeType() & 2) != 0) {
            nodeList = ((TplTemplate)node).getPutList();
        }
        int i = 0;
        while (nodeList != null && i < nodeList.getLength()) {
            TplNode child = nodeList.item(i);
            if ((child.getNodeType() & type) != 0) {
                list.add(child);
            }
            TemplateModelUtil.collectTypedNode(child, list, type);
            ++i;
        }
    }

    public static boolean hasSyntaxError(TemplateModel model) {
        if (model == null) {
            return false;
        }
        return TemplateModelUtil.hasSyntaxError(model.getRoot());
    }

    public static boolean hasSyntaxError(TplNode node) {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != 1 && node.getRefNode().getEndNode() == null) {
            return true;
        }
        TplNodeList nodeList = null;
        if ((node.getNodeType() & 9) != 0) {
            nodeList = ((TplContainer)((Object)node)).getContentNodeList();
        } else if ((node.getNodeType() & 2) != 0) {
            nodeList = ((TplTemplate)node).getPutList();
        }
        int i = 0;
        while (nodeList != null && i < nodeList.getLength()) {
            TplNode child = nodeList.item(i);
            if (TemplateModelUtil.hasSyntaxError(child)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

