/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.model;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TplRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class TplRefNode {
    private Node domNode;
    private IStructuredDocumentRegion startNode;
    private IStructuredDocumentRegion endNode;
    private TemplateModel model;

    public TplRefNode(Node node) {
        this.domNode = node;
    }

    public TplRefNode(IStructuredDocumentRegion start, IStructuredDocumentRegion end, TemplateModel model) {
        this.domNode = null;
        this.startNode = start;
        this.endNode = end;
        this.model = model;
    }

    public Node getDomNode() {
        if (this.domNode == null && this.model.getStructuredModel() != null) {
            this.domNode = (Node)this.model.getStructuredModel().getIndexedRegion(this.startNode.getStartOffset());
        }
        return this.domNode;
    }

    public IStructuredDocumentRegion getEndNode() {
        if (this.domNode != null) {
            return ((IDOMNode)this.domNode).getEndStructuredDocumentRegion();
        }
        return this.endNode;
    }

    public IStructuredDocumentRegion getStartNode() {
        if (this.domNode != null) {
            return ((IDOMNode)this.domNode).getStartStructuredDocumentRegion();
        }
        return this.startNode;
    }

    public String getText() {
        if (this.getEndNode() == null) {
            return "";
        }
        int start = this.getStartNode().getStartOffset();
        int end = this.getEndNode().getEndOffset();
        try {
            return this.getStartNode().getParentDocument().get(start, end - start);
        }
        catch (BadLocationException e) {
            Logger.log(e);
            return "";
        }
    }

    public TplRange toRange() {
        return new TplRange(this.model.getFlatModel(), this.getStartNode(), this.getEndNode());
    }
}

