/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.model;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.internal.model.TplModelFactory;
import com.ibm.etools.webpage.template.model.TemplateModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.ProjectResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolver;

public class TemplateModelSession {
    private Map templateModels;

    public TemplateModel getTemplateModel(IFile file) {
        if (file == null) {
            return null;
        }
        Object key = TemplateModelSession.getFileKey(file);
        TemplateModel model = this.getModel(key);
        if (model != null) {
            return model;
        }
        if (!file.exists()) {
            return null;
        }
        try {
            IStructuredDocument flatModel = this.getModelManager().createStructuredDocumentFor(file);
            model = TplModelFactory.createTemplateModel(flatModel, key.toString(), this);
            this.putModel(key, model);
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TemplateModel getTemplateModel(IPath location) {
        if (location == null) {
            return null;
        }
        String key = location.toString();
        TemplateModel model = this.getModel(key);
        if (model != null) {
            return model;
        }
        IFile fileInWorkspace = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
        if (fileInWorkspace != null) {
            return this.getTemplateModel(fileInWorkspace);
        }
        InputStream inStream = null;
        ProjectResolver resolver = new ProjectResolver(null);
        resolver.setFileBaseLocation(location.toString());
        File file = location.toFile();
        try {
            inStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                if (inStream == null) return null;
                inStream.close();
                return null;
            }
            catch (IOException iOException) {}
            return null;
        }
        try {
            try {
                inStream = new BufferedInputStream(inStream, 8192);
                inStream.mark(0);
                IStructuredDocument flatModel = this.getModelManager().createStructuredDocumentFor(location.toString(), inStream, (URIResolver)resolver);
                model = TplModelFactory.createTemplateModel(flatModel, key.toString(), this);
                this.putModel(key, model);
            }
            catch (IOException iOException) {
                try {
                    if (inStream == null) return model;
                    inStream.close();
                    return model;
                }
                catch (IOException iOException2) {}
                return model;
            }
        }
        catch (Throwable throwable) {
            try {
                if (inStream == null) throw throwable;
                inStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inStream == null) return model;
            inStream.close();
            return model;
        }
        catch (IOException iOException) {}
        return model;
    }

    public TemplateModel getTemplateModel(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String baseLocation = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        TemplateModel tplModel = this.getModel(baseLocation);
        if (tplModel != null) {
            return tplModel;
        }
        tplModel = TplModelFactory.createTemplateModel(model, baseLocation, this);
        this.putModel(baseLocation, tplModel);
        return tplModel;
    }

    public TemplateModel getTemplateModel(IStructuredDocument flatModel, String location) {
        TemplateModel model = this.getModel(location);
        if (model != null) {
            return model;
        }
        model = TplModelFactory.createTemplateModel(flatModel, location, this);
        this.putModel(location, model);
        return model;
    }

    public TemplateModel getExistingTemplateModel(String location) {
        return this.getModel(location);
    }

    private static Object getFileKey(IFile file) {
        IPath path;
        String key = null;
        if (file != null && (path = file.getLocation()) != null) {
            key = path.toString();
        }
        return key;
    }

    private void putModel(Object key, TemplateModel model) {
        if (key == null) {
            return;
        }
        if (this.templateModels == null) {
            this.templateModels = new HashMap();
        }
        this.templateModels.put(key, model);
    }

    private TemplateModel getModel(Object key) {
        if (this.templateModels == null || key == null) {
            return null;
        }
        Object value = this.templateModels.get(key);
        if (value instanceof TemplateModel) {
            return (TemplateModel)value;
        }
        return null;
    }

    public void clearModel(IFile file) {
        if (this.templateModels == null || file == null) {
            return;
        }
        Object key = TemplateModelSession.getFileKey(file);
        if (key != null) {
            this.templateModels.remove(key);
        }
    }

    public IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    public void clear() {
        if (this.templateModels != null) {
            this.templateModels.clear();
        }
    }

    protected Map getTemplateModels() {
        return this.templateModels;
    }
}

