/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.validation;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.validation.IPropertyResolver;
import com.ibm.etools.webpage.template.validation.ITemplateValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;

class TemplateValidatorWrapper {
    private IConfigurationElement element;
    private String[] instanceProperties;
    private String[] templateProperties;
    private ITemplateValidator validator;
    private String type;

    TemplateValidatorWrapper(String type, IConfigurationElement element) {
        this.type = type;
        this.element = element;
        this.instanceProperties = this.split(element.getAttribute("enablementInstanceProperties"));
        this.templateProperties = this.split(element.getAttribute("enablementTemplateProperties"));
    }

    public IStatus validate(IPropertyResolver instance, IPropertyResolver template) {
        if (!this.hasAllProperties(instance, this.instanceProperties)) {
            return null;
        }
        if (!this.hasAllProperties(template, this.templateProperties)) {
            return null;
        }
        try {
            return this.getValidator().validate(this.type, instance, template);
        }
        catch (Exception e) {
            Logger.log(e);
            return null;
        }
    }

    private ITemplateValidator getValidator() throws CoreException {
        if (this.validator == null) {
            this.validator = (ITemplateValidator)this.element.createExecutableExtension("class");
        }
        return this.validator;
    }

    private boolean hasAllProperties(IPropertyResolver r, String[] props) {
        int i = 0;
        while (i < props.length) {
            if (!r.hasProperty(props[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String[] split(String s) {
        if (s != null) {
            String[] result = s.split(",");
            int i = 0;
            while (i < result.length) {
                result[i] = result[i].trim();
                ++i;
            }
            return result;
        }
        return new String[0];
    }

    String getClassName() {
        return this.element.getAttribute("class");
    }
}

