/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.validation;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.internal.validation.PropertyResolverRegistoryReader;
import com.ibm.etools.webpage.template.validation.IPropertyResolver;
import com.ibm.etools.webpage.template.validation.IPropertyResolverContributor;
import com.ibm.etools.webpage.template.validation.IPropertyResolverForContributor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PropertyResolverImpl
implements IPropertyResolver {
    private Object object;
    String type;
    private ContributorHandler[] handlers;
    private final HashMap cacheHasProperty = new HashMap();
    private final HashMap cacheProperty = new HashMap();
    private static final String TRACE_KEY = "validator/propresolver";
    private static final String TRACE_KEY_DETAIL = "validator/propresolvdetail";

    public PropertyResolverImpl(String type, Object object) {
        this.object = object;
        this.type = type;
        IPropertyResolverContributor[] contributors = PropertyResolverRegistoryReader.getInstance().getPropertyResolverContributorFor(type, object);
        ArrayList<ContributorHandler> handlers = new ArrayList<ContributorHandler>(contributors.length);
        int i = 0;
        while (i < contributors.length) {
            handlers.add(new ContributorHandler(contributors[i], i));
            ++i;
        }
        this.updateHandlers(handlers);
    }

    private void updateHandlers(List handlers) {
        int i = 0;
        while (i < handlers.size()) {
            ContributorHandler handler = (ContributorHandler)handlers.get(i);
            handler.setPiority(i);
            ++i;
        }
        this.handlers = handlers.toArray(new ContributorHandler[handlers.size()]);
    }

    public void addContributor(IPropertyResolverContributor contributor) {
        ContributorHandler newHandler;
        ArrayList<ContributorHandler> handlers = new ArrayList<ContributorHandler>(Arrays.asList(this.handlers));
        if (!handlers.contains(newHandler = new ContributorHandler(contributor, 0))) {
            handlers.add(0, newHandler);
            this.updateHandlers(handlers);
        }
    }

    @Override
    public boolean hasProperty(String propertyName) {
        Boolean b = (Boolean)this.cacheHasProperty.get(propertyName);
        if (b == null) {
            b = this.hasProperty(propertyName, 0);
            this.cacheHasProperty.put(propertyName, b);
        }
        return b;
    }

    boolean hasProperty(String propertyName, int priority) {
        return this.findHandlerFor(propertyName, priority) != null || "object".equals(propertyName);
    }

    @Override
    public Object getProperty(String propertyName) {
        if (this.cacheProperty.containsKey(propertyName)) {
            return this.cacheProperty.get(propertyName);
        }
        Object o = this.getProperty(propertyName, 0);
        this.cacheProperty.put(propertyName, o);
        return o;
    }

    public Object getProperty(String propertyName, int priority) {
        ContributorHandler handler = this.findHandlerFor(propertyName, priority);
        if (handler != null) {
            return handler.getProperty(propertyName);
        }
        if ("object".equals(propertyName)) {
            return this.object;
        }
        throw new IllegalArgumentException(propertyName);
    }

    @Override
    public void dispose() {
        this.object = null;
        this.notifyObjectChange();
    }

    private ContributorHandler findHandlerFor(String propertyName, int priority) {
        int i = priority;
        while (i < this.handlers.length) {
            if (this.handlers[i].hasProperty(propertyName)) {
                return this.handlers[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getStringProperty(String propertyName) {
        return (String)this.getProperty(propertyName);
    }

    @Override
    public void notifyObjectChange() {
        int i = 0;
        while (i < this.handlers.length) {
            this.handlers[i].clear();
            ++i;
        }
        this.cacheHasProperty.clear();
        this.cacheProperty.clear();
    }

    static void _trace(String msg) {
        Logger.trace(TRACE_KEY, msg);
    }

    static boolean _isTracing() {
        return Logger.isTracing(TRACE_KEY);
    }

    static void _traceDetail(String msg) {
        Logger.trace(TRACE_KEY_DETAIL, msg);
    }

    static boolean _isTracingDetail() {
        return Logger.isTracing(TRACE_KEY_DETAIL);
    }

    void _dump(PrintWriter out) {
        if (!PropertyResolverImpl._isTracing() || out == null) {
            return;
        }
        HashSet set = new HashSet();
        int i = 0;
        while (i < this.handlers.length) {
            ContributorHandler h = this.handlers[i];
            set.addAll(h.getProperties());
            ++i;
        }
        out.println("\tProperties for: " + this.getProperty("object"));
        ArrayList props = new ArrayList(set);
        Collections.sort(props);
        for (String p : props) {
            if (!this.hasProperty(p)) continue;
            out.println("\t  " + p + " : " + this.getProperty(p));
        }
    }

    private class ContributorHandler {
        private IPropertyResolverContributor contributor;
        private Set properties;
        int priority;
        private boolean inited;
        private boolean active;
        private IPropertyResolverForContributor resolver;

        ContributorHandler(IPropertyResolverContributor contributor, int piority) {
            this.contributor = contributor;
            this.properties = contributor.getPropertySet();
            this.priority = piority;
        }

        boolean hasProperty(String propertyName) {
            IPropertyResolverContributor c = this.getContributor();
            if (this.properties.contains(propertyName)) {
                if (!this.inited) {
                    this.active = c.init(PropertyResolverImpl.this.type, this.getResolver());
                    this.inited = true;
                }
                if (this.active) {
                    return c.hasProperty(propertyName, this.getResolver());
                }
            }
            return false;
        }

        Object getProperty(String propertyName) {
            IPropertyResolverContributor c = this.getContributor();
            if (!this.inited) {
                this.active = c.init(PropertyResolverImpl.this.type, this.getResolver());
                this.inited = true;
            }
            if (this.active) {
                return c.getProperty(propertyName, this.getResolver());
            }
            return null;
        }

        void setPiority(int piority) {
            this.priority = piority;
        }

        void clear() {
            this.inited = false;
            this.active = false;
            this.contributor.clear();
        }

        private IPropertyResolverContributor getContributor() {
            return this.contributor;
        }

        private IPropertyResolverForContributor getResolver() {
            if (this.resolver == null) {
                this.resolver = new IPropertyResolverForContributor(){

                    @Override
                    public boolean hasProperty(String propertyName) {
                        return PropertyResolverImpl.this.hasProperty(propertyName);
                    }

                    @Override
                    public Object getProperty(String propertyName) {
                        return PropertyResolverImpl.this.getProperty(propertyName);
                    }

                    @Override
                    public Object superGetProperty(String propertyName) {
                        return PropertyResolverImpl.this.getProperty(propertyName, ContributorHandler.this.priority + 1);
                    }

                    @Override
                    public boolean superHasProperty(String propertyName) {
                        return PropertyResolverImpl.this.hasProperty(propertyName, ContributorHandler.this.priority + 1);
                    }

                    @Override
                    public void dispose() {
                        throw new RuntimeException();
                    }

                    @Override
                    public String getStringProperty(String propertyName) {
                        return (String)this.getProperty(propertyName);
                    }

                    @Override
                    public void notifyObjectChange() {
                        PropertyResolverImpl.this.notifyObjectChange();
                    }
                };
            }
            return this.resolver;
        }

        public int hashCode() {
            return this.contributor.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ContributorHandler)) {
                return false;
            }
            return this.contributor == ((ContributorHandler)obj).contributor;
        }

        Collection getProperties() {
            return Collections.unmodifiableCollection(this.properties);
        }
    }
}

