/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.sample;

import com.ibm.etools.webpage.template.SampleLocator;
import com.ibm.etools.webpage.template.TemplateSampleFamily;
import com.ibm.etools.webpage.template.TemplateSampleItem;
import com.ibm.etools.webpage.template.internal.sample.TemplateRegistryReader;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TemplateSampleLocator
implements SampleLocator {
    private static TemplateSampleLocator instance;
    private List sampleItemList;
    private List sampleFamilyList;

    public static SampleLocator getInstance() {
        if (instance == null) {
            instance = new TemplateSampleLocator();
        }
        return instance;
    }

    private TemplateSampleLocator() {
        TemplateRegistryReader reader = new TemplateRegistryReader();
        this.sampleItemList = reader.getSampleItemList();
    }

    @Override
    public TemplateSampleItem[] getSampleItems() {
        if (this.sampleItemList != null) {
            TemplateSampleItem[] items = new TemplateSampleItem[this.sampleItemList.size()];
            this.sampleItemList.toArray(items);
            return items;
        }
        return new TemplateSampleItem[0];
    }

    @Override
    public TemplateSampleFamily[] getSampleFamilies() {
        if (this.sampleFamilyList == null) {
            this.sampleFamilyList = new ArrayList();
            TemplateSampleItem[] items = this.getSampleItems();
            int i = 0;
            while (i < items.length) {
                TemplateSampleItem item = items[i];
                if (!this.sampleFamilyList.contains(item.getFamily())) {
                    this.sampleFamilyList.add(item.getFamily());
                }
                ++i;
            }
            Collections.sort(this.sampleFamilyList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    TemplateSampleFamily f1 = (TemplateSampleFamily)o1;
                    TemplateSampleFamily f2 = (TemplateSampleFamily)o2;
                    int result = f1.getPriority() - f2.getPriority();
                    if (result == 0) {
                        result = Collator.getInstance().compare(f1.getName(), f2.getName());
                    }
                    return result;
                }
            });
        }
        return this.sampleFamilyList.toArray(new TemplateSampleFamily[this.sampleFamilyList.size()]);
    }
}

