/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model.comment;

import com.ibm.etools.webpage.template.internal.model.comment.FlatNodeCommentUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class CommentTagInfo {
    private final IStructuredDocumentRegion node;
    private boolean valid;
    private final String commentData;
    private boolean start;
    private String tagName;
    static final short SRCGEN_NO_CONV = 0;
    static final short SRCGEN_XML_COMMENT = 1;
    static final short SRCGEN_JSP_COMMENT = 2;
    private static final String XML_COMMENT_OPEN = "<!--";
    private static final String XML_COMMENT_CLOSE = "-->";
    private static final String JSP_COMMENT_OPEN = "<%--";
    private static final String JSP_COMMENT_CLOSE = "--%>";

    public CommentTagInfo(IStructuredDocumentRegion node) {
        this.node = node;
        this.commentData = FlatNodeCommentUtil.getCommentData(node);
        if (this.commentData == null) {
            return;
        }
        this.start = !this.commentData.startsWith("/");
        this.valid = this.commentData.startsWith("tpl:", this.start ? 0 : 1);
    }

    public String getCommentData() {
        return this.commentData;
    }

    public IStructuredDocumentRegion getFlatNode() {
        return this.node;
    }

    public boolean isStart() {
        return this.start;
    }

    public String getTagName() {
        if (this.tagName == null) {
            this.tagName = FlatNodeCommentUtil.getTagName(this.commentData.substring(this.start ? 0 : 1));
        }
        return this.tagName;
    }

    public String getAttrValue(String attrName) {
        return FlatNodeCommentUtil.getAttrValue(this.commentData.substring(this.start ? 0 : 1), attrName);
    }

    public boolean isValid() {
        return this.valid;
    }

    protected String generateSourceWith(String newTagName) {
        String nodeText = this.node.getText();
        int tagStart = nodeText.indexOf(this.commentData);
        StringBuffer buf = new StringBuffer();
        buf.append(nodeText.substring(0, tagStart += this.commentData.indexOf(this.getTagName())));
        buf.append(newTagName);
        buf.append(nodeText.substring(tagStart + this.getTagName().length()));
        return buf.toString();
    }

    public Region getAttrValueRegion(String attrName) {
        String nodeText = this.node.getText();
        int i = FlatNodeCommentUtil.getAttrValueOffset(this.commentData.substring(this.start ? 0 : 1), attrName);
        if (i < 0) {
            return null;
        }
        Region reg = new Region();
        reg.start = i + nodeText.indexOf(this.commentData);
        String attrValue = this.getAttrValue(attrName);
        reg.offset = attrValue != null ? attrValue.length() : 0;
        return reg;
    }

    String generatePutSource(short sourceType) {
        String nodeText = this.node.getText();
        int tagPos = nodeText.indexOf(this.commentData) + this.commentData.indexOf(this.getTagName());
        int attrPos = nodeText.indexOf(this.commentData) + FlatNodeCommentUtil.getAttrOffset(this.commentData, "attribute");
        int restPos = attrPos + "attribute".length();
        StringBuffer buf = new StringBuffer();
        if (sourceType == 1 && nodeText.startsWith(JSP_COMMENT_OPEN)) {
            buf.append(XML_COMMENT_OPEN);
            buf.append(nodeText.substring(JSP_COMMENT_OPEN.length(), tagPos));
        } else if (sourceType == 2 && nodeText.startsWith(XML_COMMENT_OPEN)) {
            buf.append(JSP_COMMENT_OPEN);
            buf.append(nodeText.substring(XML_COMMENT_OPEN.length(), tagPos));
        } else {
            buf.append(nodeText.substring(0, tagPos));
        }
        buf.append("tpl:put");
        if (tagPos < attrPos) {
            buf.append(nodeText.substring(tagPos + this.getTagName().length(), attrPos));
            buf.append("name");
        } else {
            restPos = tagPos + this.getTagName().length();
        }
        if (sourceType == 1 && nodeText.endsWith(JSP_COMMENT_CLOSE)) {
            buf.append(nodeText.substring(restPos, nodeText.length() - JSP_COMMENT_CLOSE.length()));
            buf.append(XML_COMMENT_CLOSE);
        } else if (sourceType == 2 && nodeText.endsWith(XML_COMMENT_CLOSE)) {
            buf.append(nodeText.substring(restPos, nodeText.length() - XML_COMMENT_CLOSE.length()));
            buf.append(JSP_COMMENT_CLOSE);
        } else {
            buf.append(nodeText.substring(restPos));
        }
        return buf.toString();
    }

    public static class Region {
        public int start;
        public int offset;
    }
}

