/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model;

import com.ibm.etools.webpage.template.internal.model.LinkUtil;
import com.ibm.etools.webpage.template.internal.model.TemplateModelImpl;
import com.ibm.etools.webpage.template.internal.model.TplNodeImpl;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateTaskReporter;
import com.ibm.etools.webpage.template.model.TplException;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.TplRange;
import com.ibm.etools.webpage.template.model.TplRefNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class TplPutImpl
extends TplNodeImpl
implements TplPut {
    protected TplPutImpl(TplRefNode refNode) {
        super(refNode);
    }

    @Override
    public short getNodeType() {
        return 8;
    }

    @Override
    public TplNodeList getContentNodeList() {
        if (this.children == null) {
            ((TemplateModelImpl)this.getModel()).getNodeFactory().parseAndCreateChidren(this);
        }
        return this;
    }

    @Override
    public void updateContent() {
        this.contentRange = null;
        this.children.clear();
        this.children = null;
    }

    @Override
    public IFile getReferedFile() {
        String ref = this.getReference();
        if (ref != null) {
            IFile thisFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.getModel().getLocation()));
            return thisFile != null ? LinkUtil.getFile(thisFile, ref, false) : null;
        }
        return null;
    }

    @Override
    public IPath getReferedFileLocation() {
        String ref = this.getReference();
        if (ref != null) {
            Path thisLocation = new Path(this.getModel().getLocation());
            LinkUtil.getFileLocation((IPath)thisLocation, ref);
        }
        return null;
    }

    @Override
    public TemplateModel getReferedModel() {
        IFile file = this.getReferedFile();
        if (file != null) {
            return ((TemplateModelImpl)this.getModel()).getSession().getTemplateModel(file);
        }
        IPath location = this.getReferedFileLocation();
        if (location != null) {
            return ((TemplateModelImpl)this.getModel()).getSession().getTemplateModel(location);
        }
        return null;
    }

    @Override
    public void setContent(String content) throws TplException {
        TplRange range = this.getContent();
        if (!range.isValid()) {
            throw new TplException(1, "Invalid content");
        }
        int start = 0;
        int length = 0;
        if (range.getStartNode() != null) {
            start = range.getStartNode().getStartOffset();
            length = range.getEndNode().getEndOffset() - start;
        } else {
            start = range.getPosition();
        }
        this.getModel().getFlatModel().replaceText(this.getModificationRequester(), start, length, content);
        this.updateContent();
    }

    @Override
    public boolean rebuildContent(TemplateTaskReporter report, boolean reportOnly) {
        boolean modified = false;
        if (this.getRefNode().getEndNode() == null) {
            this.reportTask(report, "SyntaxError", this.getRefNode().getStartNode().getStartOffset(), this.getRefNode().getStartNode().getLength());
            return modified;
        }
        if (this.getParent().getNodeType() != 2) {
            this.reportTask(report, "SyntaxError", this.getRefNode().getStartNode().getStartOffset(), this.getRefNode().getEndNode().getEndOffset() - this.getRefNode().getStartNode().getStartOffset());
            return modified;
        }
        TplNodeList list = this.getContentNodeList();
        int i = list.getLength() - 1;
        while (i >= 0) {
            boolean b = list.item(i).rebuildContent(report, reportOnly || report != null && report.getLength() > 0);
            modified |= b;
            --i;
        }
        return modified;
    }
}

