/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model;

import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.links.util.InvalidURLException;
import com.ibm.etools.webedit.links.util.URI;
import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class LinkUtil {
    public static IPath getFileLocation(IFile baseFile, String src, boolean contextRootSensitive) {
        if (src == null || baseFile == null) {
            return null;
        }
        String absURL = com.ibm.etools.webedit.viewer.utils.LinkUtil.getAbsURL((IPath)baseFile.getLocation(), (IPath)baseFile.getLocation(), (String)src, (boolean)contextRootSensitive);
        return LinkUtil.getFileLocation(absURL);
    }

    public static IPath getFileLocation(IPath baseFileLocation, String src) {
        if (src == null || baseFileLocation == null) {
            return null;
        }
        String absURL = com.ibm.etools.webedit.viewer.utils.LinkUtil.getAbsURL((IPath)baseFileLocation, (IPath)baseFileLocation, (String)src, (boolean)false);
        return LinkUtil.getFileLocation(absURL);
    }

    private static IPath getFileLocation(String absURL) {
        Path filePath = null;
        String scheme = URI.getOnlyScheme((String)absURL);
        if (scheme != null && scheme.length() > 0) {
            if (scheme.compareToIgnoreCase("file") == 0) {
                try {
                    FileURL fileURL = new FileURL(absURL);
                    filePath = fileURL.getPath();
                }
                catch (InvalidURLException e) {
                    Logger.log(e);
                }
            }
        } else {
            filePath = new Path(absURL);
        }
        return filePath;
    }

    public static IFile getFile(IFile baseFile, String src, boolean contextRootSensitive) {
        IPath location = LinkUtil.getFileLocation(baseFile, src, contextRootSensitive);
        if (location == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
    }

    public static String getResolvedNonPortalAwareURI(IVirtualComponent component, FileURL fileURL) {
        IPath docRoot = null;
        WebComponent webComp = null;
        try {
            webComp = new WebComponent(component);
            docRoot = webComp.getDocumentRoot();
            String string = LinkUtil.makeDocRootRelative(null, docRoot.toString(), fileURL.getURL(), docRoot != null ? docRoot.toString() : null, null, null, null, null, false);
            return string;
        }
        finally {
            if (webComp != null) {
                webComp.dispose();
            }
        }
    }

    public static String makeDocRootRelative(IProject project, String sourceLocation, String absoluteLink, String docRoot, String serverContextRoot, String tagname, String attributeName, String taglibURI, boolean doEncoding) {
        if (absoluteLink == null || absoluteLink.length() == 0) {
            if (absoluteLink != null) {
                return absoluteLink;
            }
            return "";
        }
        String protocol = URI.getOnlyScheme((String)absoluteLink).toLowerCase();
        if (!"".equals(protocol) && !"file".equals(protocol)) {
            return null;
        }
        IPath filePath = null;
        FileURL fileURL = null;
        try {
            fileURL = new FileURL(absoluteLink);
        }
        catch (InvalidURLException invalidURLException) {
            fileURL = new FileURL((IPath)new Path(absoluteLink));
        }
        filePath = fileURL.getPath().makeRelative();
        IPath docRootPath = new Path(docRoot).makeRelative();
        if (!LinkUtil.sameDevices(filePath, docRootPath)) {
            return null;
        }
        int docRootSegments = docRootPath.matchingFirstSegments(filePath);
        if (docRootSegments == docRootPath.segmentCount()) {
            filePath = filePath.removeFirstSegments(docRootSegments);
            if (serverContextRoot != null && serverContextRoot.length() > 0) {
                Path serverContextRootIPath = new Path(serverContextRoot);
                IPath webAppPath = serverContextRootIPath.makeAbsolute();
                filePath = filePath.setDevice(null);
                filePath = webAppPath.append(filePath);
            }
            return filePath.setDevice(null).makeAbsolute().toString();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sameDevices(IPath path1, IPath path2) {
        device1 = path1.getDevice();
        device2 = path2.getDevice();
        if (device1 == null && device2 == null) {
            return true;
        }
        if (device1 != null && device2 != null) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            device1 = device1.substring(1);
lbl8:
            // 2 sources

            ** while (device1.length() > 0 && device1.charAt((int)0) == '/')
        }
lbl9:
        // 2 sources

        while (device2.length() > 0 && device2.charAt(0) == '/') {
            device2 = device2.substring(1);
        }
        return device1.toLowerCase().equals(device2.toLowerCase());
    }
}

