/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.linkdetector;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceElementFactory;
import com.ibm.etools.references.services.providers.ILinkDetectorProvider;
import com.ibm.etools.references.services.providers.SharedModel;
import com.ibm.etools.references.web.AbstractWebProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class TemplatesLinkDetectorProvider
extends AbstractWebProvider
implements ILinkDetectorProvider {
    private static HashMap<String, String[]> nameAttributeMap = new HashMap();

    static {
        nameAttributeMap.put("TPL:INSERT", new String[]{"PAGE"});
    }

    public List<ILink> detectLinks(ReferenceElementFactory factory, SharedModel sharedModel, Set<IResolvedReference> incomingReferences) {
        ArrayList<ILink> links = new ArrayList<ILink>();
        if (sharedModel.getSharedModel() instanceof IDOMModel) {
            IDOMModel model = (IDOMModel)sharedModel.getSharedModel();
            IStructuredDocument str = model.getStructuredDocument();
            IDOMDocument document = model.getDocument();
            NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
            Node n = iter.nextNode();
            while (n != null) {
                String[] attributes;
                String nName = n.getNodeName();
                if (nName != null && (attributes = nameAttributeMap.get(nName.toUpperCase())) != null) {
                    IDOMElement domElement = (IDOMElement)n;
                    if (attributes.length != 0) {
                        NamedNodeMap attributeNodes = n.getAttributes();
                        int length = attributeNodes.getLength();
                        int i = 0;
                        while (i < length) {
                            Node item = attributeNodes.item(i);
                            String name = nName;
                            String attName = item.getNodeName();
                            String[] stringArray = attributes;
                            int n2 = attributes.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                String attribute = stringArray[n3];
                                if (attName.compareToIgnoreCase(attribute) == 0) {
                                    String linkType = this.getLinkType(nName, attName);
                                    IDOMAttr attr = (IDOMAttr)item;
                                    ILink webLink = AbstractWebProvider.createLink((ReferenceElementFactory)factory, (IStructuredDocument)str, (IDOMElement)domElement, (IDOMAttr)attr, (String)linkType, (String)name);
                                    factory.addParam(webLink, "commentLink", "true");
                                    factory.addParam(webLink, "subparse", "true");
                                    links.add(webLink);
                                    break;
                                }
                                ++n3;
                            }
                            ++i;
                        }
                    }
                }
                n = iter.nextNode();
            }
        }
        return links;
    }

    private String getLinkType(String nodeName, String attName) {
        return "webedit.tpl.insert";
    }
}

