/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder.indexer;

import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndex;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndexManager;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefInfo;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IndexedTemplateModelSession
extends TemplateModelSession {
    private List infoPool;
    private List toBeRemovedPool;

    @Override
    public void clearModel(IFile file) {
        TemplateModel model;
        if (file != null && (model = this.getExistingTemplateModel(file.getLocation().toString())) != null) {
            if (TemplateModelUtil.hasSyntaxError(model)) {
                IFile keyFile = TemplatePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(model.getLocation()));
                this.getToBeRemovedPool().add(keyFile);
            } else {
                this.getInfoPool().add(new TemplateRefInfo(model));
            }
        }
        super.clearModel(file);
    }

    @Override
    public void clear() {
        if (this.getTemplateModels() != null) {
            Collection models = this.getTemplateModels().values();
            for (Object obj : models) {
                if (!(obj instanceof TemplateModel)) continue;
                if (TemplateModelUtil.hasSyntaxError((TemplateModel)obj)) {
                    IFile keyFile = TemplatePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(((TemplateModel)obj).getLocation()));
                    this.getToBeRemovedPool().add(keyFile);
                    continue;
                }
                this.getInfoPool().add(new TemplateRefInfo((TemplateModel)obj));
            }
        }
        super.clear();
    }

    public void cleanup() {
        super.clear();
        this.getInfoPool().clear();
        this.getToBeRemovedPool().clear();
    }

    private List getInfoPool() {
        if (this.infoPool == null) {
            this.infoPool = new ArrayList();
        }
        return this.infoPool;
    }

    private List getToBeRemovedPool() {
        if (this.toBeRemovedPool == null) {
            this.toBeRemovedPool = new ArrayList();
        }
        return this.toBeRemovedPool;
    }

    public void updateIndex() {
        TemplateRefIndex lastIndex = null;
        if (this.infoPool != null) {
            for (TemplateRefInfo info : this.infoPool) {
                if (lastIndex == null || !lastIndex.getProject().equals((Object)info.getKeyFile().getProject())) {
                    lastIndex = TemplateRefIndexManager.getInstance().getIndex(info.getKeyFile().getProject());
                }
                if (lastIndex == null) continue;
                lastIndex.setReference(info);
            }
        }
        if (this.toBeRemovedPool != null) {
            for (IFile file : this.toBeRemovedPool) {
                if (file == null) continue;
                if (lastIndex == null || !lastIndex.getProject().equals((Object)file.getProject())) {
                    lastIndex = TemplateRefIndexManager.getInstance().getIndex(file.getProject());
                }
                if (lastIndex == null) continue;
                lastIndex.removeReference(file);
            }
        }
        if (this.getTemplateModels() == null) {
            return;
        }
        for (Object obj : this.getTemplateModels().values()) {
            if (!(obj instanceof TemplateModel)) continue;
            if (lastIndex == null) {
                IFile keyFile = TemplatePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(((TemplateModel)obj).getLocation()));
                lastIndex = TemplateRefIndexManager.getInstance().getIndex(keyFile.getProject());
            }
            if (lastIndex == null) continue;
            lastIndex.setReference((TemplateModel)obj);
        }
    }

    public void createNoTplNodeIndex(IFile file) {
        TemplateRefInfo info = new TemplateRefInfo(file, file.getModificationStamp(), false, new IFile[0], new short[0], "", "");
        this.getInfoPool().add(info);
    }
}

