/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder;

import com.ibm.etools.webpage.template.model.TemplateModelSession;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ValidateEditUtil {
    static boolean handleValidateReadOnly(final IFile[] readOnlyFilesArray, final TemplateModelSession session) {
        final boolean[] validateEditDone = new boolean[1];
        final boolean[] refreshed = new boolean[1];
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (shell = window.getShell()) != null) {
                        refreshed[0] = ValidateEditUtil.validateEdit(readOnlyFilesArray, shell, session);
                        validateEditDone[0] = true;
                    }
                }
            });
        }
        if (!validateEditDone[0]) {
            refreshed[0] = ValidateEditUtil.validateEdit(readOnlyFilesArray, null, session);
        }
        return refreshed[0];
    }

    static boolean validateEdit(IFile[] readOnlyFilesArray, Shell shell, TemplateModelSession session) {
        Map oldMap = ValidateEditUtil.createModificationStampMap(readOnlyFilesArray);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFilesArray, (Object)shell);
        boolean refreshed = false;
        if (status.isOK() || status.isMultiStatus()) {
            Map newMap = ValidateEditUtil.createModificationStampMap(readOnlyFilesArray);
            for (IFile file : oldMap.keySet()) {
                if (oldMap.get(file).equals(newMap.get(file))) continue;
                try {
                    file.refreshLocal(1, null);
                }
                catch (CoreException coreException) {}
                session.clearModel(file);
                refreshed = true;
            }
        }
        return refreshed;
    }

    private static Map createModificationStampMap(IFile[] files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            map.put(file, new Long(file.getModificationStamp()));
            ++i;
        }
        return map;
    }
}

