/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.internal.builder.MarkerData;
import com.ibm.etools.webpage.template.model.TplTask;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;

public class TemplateBuilderMarkerUtil {
    private static Hashtable ids = new Hashtable();
    private static Hashtable message = new Hashtable();

    static {
        ids.put("GetPutMismatch", new Integer(100));
        ids.put("SyntaxError", new Integer(102));
        message.put("GetPutMismatch", ResourceHandler._UI_Cannot_resolve_matching_between_Instance_page__s_and_Template_page__s_parameter_regions__2);
        message.put("SyntaxError", ResourceHandler._UI_Syntax_error_of_Page_Template_3);
    }

    public static IMarker createTaskError(IFile file, TplTask task) {
        if (task.type == "BrokenLink") {
            return null;
        }
        if (task.type == "UnexpectedError") {
            Logger.log("Unexpected error occured while building Page Template");
            return null;
        }
        IMarker marker = null;
        try {
            marker = file.createMarker("com.ibm.etools.webpage.template.templateerrormarker");
            marker.setAttribute("charStart", task.colStart);
            marker.setAttribute("charEnd", task.colEnd);
            marker.setAttribute("lineNumber", task.lineOffset + 1);
            marker.setAttribute("message", (Object)TemplateBuilderMarkerUtil.getMessage(task));
            marker.setAttribute("severity", 2);
            marker.setAttribute("id", TemplateBuilderMarkerUtil.getID(task));
        }
        catch (CoreException e) {
            Logger.log(e);
        }
        return marker;
    }

    public static IMarker createInfiniteReference(IFile file, MarkerData data) {
        return TemplateBuilderMarkerUtil.createMarker("com.ibm.etools.webpage.template.templateerrormarker", file, data, 101);
    }

    public static IMarker createReferencedTemplateError(IFile file, MarkerData data) {
        return TemplateBuilderMarkerUtil.createMarker("com.ibm.etools.webpage.template.templateerrormarker", file, data, 103);
    }

    public static IMarker createReferencedFragmentError(IFile file, MarkerData data) {
        return TemplateBuilderMarkerUtil.createMarker("com.ibm.etools.webpage.template.templateerrormarker", file, data, 104);
    }

    public static IMarker createWrongFileType(IFile file, MarkerData data) {
        return TemplateBuilderMarkerUtil.createMarker("com.ibm.etools.webpage.template.templateerrormarker", file, data, 105);
    }

    public static void deleteMarkers(IFile file) {
        try {
            IMarker[] markers = file.findMarkers("com.ibm.etools.webpage.template.templatemarker", true, 0);
            int i = 0;
            while (i < markers.length) {
                markers[i].delete();
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    private static int getID(TplTask task) {
        Integer ret = (Integer)ids.get(task.type);
        return ret;
    }

    private static String getMessage(TplTask task) {
        return (String)message.get(task.type);
    }

    private static IMarker createMarker(String type, IFile file, MarkerData data, int id) {
        IMarker marker = null;
        try {
            marker = file.createMarker(type);
            marker.setAttribute("charStart", data.char_start);
            marker.setAttribute("charEnd", data.char_end);
            marker.setAttribute("lineNumber", data.line_number + 1);
            marker.setAttribute("message", (Object)data.message);
            marker.setAttribute("severity", 2);
            marker.setAttribute("id", id);
        }
        catch (CoreException e) {
            Logger.log(e);
        }
        return marker;
    }
}

