/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder;

import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.internal.builder.RelationDataManager;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.IProgressMonitor;

public class ResourceDeltaVisitor
extends RelationDataManager
implements IResourceDeltaVisitor {
    public ResourceDeltaVisitor(IProgressMonitor monitor) {
        super(monitor);
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        WebComponent webComp = null;
        try {
            webComp = new WebComponent(resource);
            if (webComp.getComponent() == null) {
                return false;
            }
        }
        finally {
            if (webComp != null) {
                webComp.dispose();
            }
        }
        if (resource.getType() != 1) {
            return true;
        }
        if (!this.isValidFileType(resource)) {
            return true;
        }
        this.monitor.subTask(MessageFormat.format(ResourceHandler._UI_Template_Builder_is_checking__0__1, resource.getFullPath().toString()));
        if (this.hasTemplateNode((IFile)resource)) {
            if (this.isValidTemplateFileType(resource)) {
                if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
                    this.addChangedTemplateToTarget((IFile)resource);
                }
                this.addInstanceFiles((IFile)resource);
                this.addTemplateFiles((IFile)resource);
            } else if (this.isInstanceFile((IFile)resource)) {
                if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
                    this.addChangedInstanceToTarget((IFile)resource);
                }
            } else {
                if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
                    this.addChangedContainerToTarget((IFile)resource);
                }
                if (this.isValidFragmentFile(resource)) {
                    this.addContainerFiles((IFile)resource);
                }
            }
        } else {
            if (this.isValidFragmentFile(resource)) {
                this.addContainerFiles((IFile)resource);
            }
            this.removeFromCandidates(resource);
            this.clearModel((IFile)resource);
        }
        this.monitor.worked(1);
        return false;
    }
}

