/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder;

import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.internal.builder.MarkerData;
import com.ibm.etools.webpage.template.internal.builder.ReferenceTree;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReferenceMap {
    private Hashtable map = new Hashtable();
    public ArrayList working = new ArrayList();
    private IProgressMonitor monitor;

    public ReferenceMap() {
    }

    public ReferenceMap(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void add(IFile src, TemplateModelSession session) {
        if (this.map.containsKey(src)) {
            return;
        }
        if (!src.exists()) {
            return;
        }
        this.working.add(src);
        ReferenceTree tree = new ReferenceTree(src, this, session);
        tree.make();
        this.map.put(src, tree);
        this.working.remove(src);
    }

    public boolean hasInfiniteReference(IFile src) {
        ReferenceTree tree = this.get(src);
        if (tree == null) {
            return false;
        }
        return tree.hasInfiniteReference();
    }

    public boolean hasErrorTemplate(IFile src) {
        return this.getErrorTemplateFile(src) != null;
    }

    public boolean hasErrorFragment(IFile src) {
        return this.getErrorFragmentFile(src) != null;
    }

    public boolean hasWrongType(IFile src) {
        return this.getWrongFileTypeFile(src) != null;
    }

    public boolean hasTemplateNode(IFile src) {
        ReferenceTree tree = this.get(src);
        if (tree == null) {
            return false;
        }
        return tree.hasTemplateNode();
    }

    public MarkerData getInfiniteData(IFile src) {
        ReferenceTree tree = (ReferenceTree)this.map.get(src);
        return tree.getInfiniteData();
    }

    public MarkerData getErrorTemplateData(IFile src) {
        IFile file = this.getErrorTemplateFile(src);
        ReferenceTree tree = this.get(src);
        return tree.getErrorTemplateData(file);
    }

    public MarkerData getErrorFragmentData(IFile src) {
        IFile file = this.getErrorFragmentFile(src);
        ReferenceTree tree = this.get(src);
        return tree.getErrorFragmentData(file);
    }

    public MarkerData getWrongFileTypeData(IFile src) {
        IFile file = this.getWrongFileTypeFile(src);
        ReferenceTree tree = this.get(src);
        return tree.getWrongFileTypeData(file);
    }

    public boolean isInstanceFileFor(IFile template, IFile candidate) {
        ReferenceTree tree = (ReferenceTree)this.map.get(candidate);
        if (tree != null) {
            return tree.isInstanceFileFor(template);
        }
        return false;
    }

    public boolean isInstanceFile(IFile candidate) {
        ReferenceTree tree = (ReferenceTree)this.map.get(candidate);
        if (tree != null) {
            return tree.isInstanceFile();
        }
        return false;
    }

    public boolean isContainerFileFor(IFile fragment, IFile candidate) {
        ReferenceTree tree = (ReferenceTree)this.map.get(candidate);
        if (tree != null) {
            return tree.isContainerFileFor(fragment);
        }
        return false;
    }

    private IFile getErrorTemplateFile(IFile src) {
        ReferenceTree tree = this.get(src);
        if (tree == null) {
            return null;
        }
        for (IFile file : tree.getTemplates()) {
            try {
                IMarker[] markers;
                if (!file.exists() || (markers = file.findMarkers("com.ibm.etools.webpage.template.templatemarker", true, 0)).length <= 0) continue;
                return file;
            }
            catch (CoreException e) {
                Logger.log(e);
            }
        }
        return null;
    }

    private IFile getErrorFragmentFile(IFile src) {
        ReferenceTree tree = this.get(src);
        if (tree == null) {
            return null;
        }
        for (IFile file : tree.getFragments()) {
            try {
                IMarker[] markers;
                if (!file.exists() || (markers = file.findMarkers("com.ibm.etools.webpage.template.templatemarker", true, 0)).length <= 0) continue;
                return file;
            }
            catch (CoreException e) {
                Logger.log(e);
            }
        }
        return null;
    }

    private IFile getWrongFileTypeFile(IFile src) {
        ReferenceTree tree = this.get(src);
        if (tree == null) {
            return null;
        }
        String fileType = FileTypeHandler.getFileType(src);
        if (fileType.equals("jsp") || fileType.equals("jtpl")) {
            return null;
        }
        for (IFile file : tree.getTemplates()) {
            fileType = FileTypeHandler.getFileType(file);
            if (!fileType.equals("jsp") && !fileType.equals("jtpl")) continue;
            return file;
        }
        for (IFile file : tree.getFragments()) {
            fileType = FileTypeHandler.getFileType(file);
            if (!fileType.equals("jsp") && !fileType.equals("jtpl")) continue;
            return file;
        }
        return null;
    }

    public ReferenceTree get(IFile src) {
        return (ReferenceTree)this.map.get(src);
    }

    public boolean isWorking(IFile src) {
        return this.working.contains(src);
    }

    IProgressMonitor getMonitor() {
        return this.monitor;
    }
}

