/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder;

import com.ibm.etools.webpage.template.internal.builder.ReferenceMap;
import com.ibm.etools.webpage.template.internal.builder.TemplateBuilderMarkerUtil;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TemplateTaskReporter;
import java.util.Collection;
import org.eclipse.core.resources.IFile;

public class RebuildMarkerUtil {
    private ReferenceMap referenceMap;

    public RebuildMarkerUtil(ReferenceMap referenceMap) {
        this.referenceMap = referenceMap;
    }

    public boolean createMarkersBeforeBuild(IFile target) {
        this.deleteMarkers(target);
        if (this.hasInfiniteReference(target)) {
            this.createInfiniteReferenceMarker(target);
            return true;
        }
        if (this.hasErrorTemplate(target)) {
            this.createErrorTemplateMarker(target);
            return true;
        }
        if (this.hasErrorFragment(target)) {
            this.createErrorFragmentMarker(target);
            return true;
        }
        if (this.hasWrongFileType(target)) {
            this.createWrongFileTypeMarker(target);
            return true;
        }
        return false;
    }

    public boolean createMarkersAfterBuild(IFile target, TemplateTaskReporter reporter) {
        if (this.isError(reporter)) {
            this.createMarker(target, reporter);
            return true;
        }
        return false;
    }

    public void rebuildMarker(Collection rebuildFiles) {
        TemplateModelSession session = new TemplateModelSession();
        for (IFile target : rebuildFiles) {
            TemplateModel tplmodel;
            if (!target.exists() || this.createMarkersBeforeBuild(target) || (tplmodel = session.getTemplateModel(target)) == null) continue;
            TemplateTaskReporter reporter = new TemplateTaskReporter();
            tplmodel.getRebuildingContentReport(reporter);
            this.createMarkersAfterBuild(target, reporter);
        }
    }

    private void deleteMarkers(IFile target) {
        TemplateBuilderMarkerUtil.deleteMarkers(target);
    }

    private boolean hasInfiniteReference(IFile src) {
        return this.referenceMap.hasInfiniteReference(src);
    }

    private void createInfiniteReferenceMarker(IFile target) {
        TemplateBuilderMarkerUtil.createInfiniteReference(target, this.referenceMap.getInfiniteData(target));
    }

    private void createErrorTemplateMarker(IFile target) {
        TemplateBuilderMarkerUtil.createReferencedTemplateError(target, this.referenceMap.getErrorTemplateData(target));
    }

    private void createErrorFragmentMarker(IFile target) {
        TemplateBuilderMarkerUtil.createReferencedFragmentError(target, this.referenceMap.getErrorFragmentData(target));
    }

    private void createWrongFileTypeMarker(IFile target) {
        TemplateBuilderMarkerUtil.createWrongFileType(target, this.referenceMap.getWrongFileTypeData(target));
    }

    private boolean hasErrorTemplate(IFile target) {
        return this.referenceMap.hasErrorTemplate(target);
    }

    private boolean hasErrorFragment(IFile target) {
        return this.referenceMap.hasErrorFragment(target);
    }

    private boolean hasWrongFileType(IFile target) {
        return this.referenceMap.hasWrongType(target);
    }

    private boolean isError(TemplateTaskReporter reporter) {
        return reporter.getLength() != 0;
    }

    private void createMarker(IFile target, TemplateTaskReporter reporter) {
        int i = 0;
        while (i < reporter.getLength()) {
            TemplateBuilderMarkerUtil.createTaskError(target, reporter.get(i));
            ++i;
        }
    }
}

