/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.internal.builder.AbortBuildException;
import com.ibm.etools.webpage.template.internal.builder.BuildResourceVisitor;
import com.ibm.etools.webpage.template.internal.builder.ResourceDeltaVisitor;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateHasTplNodeIndexForFullBuild;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndexManager;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class PageTemplateBuilder
extends IncrementalProjectBuilder {
    private static final String BUILDER_TASK_NAME = ResourceHandler._UI_Template_Builder_build_process_1;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) {
        IResourceDelta delta = null;
        if (kind != 6) {
            delta = this.getDelta(this.getProject());
        }
        if (delta == null) {
            this.fullBuild(monitor);
        } else {
            this.incrementalBuild(delta, monitor);
        }
        return null;
    }

    private void fullBuild(IProgressMonitor monitor) {
        int totalTask = this.estimateTotalTask();
        if (totalTask == 0) {
            return;
        }
        IContainer webcontent = this.getWebContentFolder();
        BuildResourceVisitor visitor = new BuildResourceVisitor(monitor);
        visitor.setHasTplNodeIndex(new TemplateHasTplNodeIndexForFullBuild(this.getProject()));
        TemplateRefIndexManager.getInstance().clear(this.getProject());
        boolean canceled = false;
        try {
            try {
                monitor.beginTask(BUILDER_TASK_NAME, totalTask);
                webcontent.accept((IResourceVisitor)visitor);
                visitor.build();
                visitor.getSession().updateIndex();
                visitor.getSession().cleanup();
            }
            catch (AbortBuildException abortBuildException) {
                this.forgetLastBuiltState();
                monitor.setCanceled(true);
                canceled = true;
                throw new OperationCanceledException();
            }
            catch (Exception e) {
                Logger.log(e);
                if (!canceled) {
                    monitor.done();
                }
            }
        }
        finally {
            if (!canceled) {
                monitor.done();
            }
        }
    }

    private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) {
        int totalTask = this.estimateTotalTask();
        if (totalTask == 0) {
            return;
        }
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(monitor);
        boolean canceled = false;
        try {
            try {
                monitor.beginTask(BUILDER_TASK_NAME, totalTask);
                delta.accept((IResourceDeltaVisitor)visitor);
                visitor.build();
                visitor.getSession().updateIndex();
                visitor.getSession().cleanup();
            }
            catch (AbortBuildException abortBuildException) {
                this.forgetLastBuiltState();
                monitor.setCanceled(true);
                canceled = true;
                throw new OperationCanceledException();
            }
            catch (Exception e) {
                Logger.log(e);
                if (!canceled) {
                    monitor.done();
                }
            }
        }
        finally {
            if (!canceled) {
                monitor.done();
            }
        }
    }

    private IContainer getWebContentFolder() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        return component != null ? component.getRootFolder().getUnderlyingFolder() : null;
    }

    private int estimateTotalTask() {
        int totalTask = 0;
        IContainer webcontent = this.getWebContentFolder();
        if (webcontent == null || !webcontent.exists()) {
            return totalTask;
        }
        try {
            IResource[] members = webcontent.members();
            totalTask += this.countFileNumber(members, 0) * 2;
        }
        catch (CoreException coreException) {}
        return totalTask;
    }

    private int countFileNumber(IResource[] members, int number) {
        int i = 0;
        while (i < members.length) {
            if (members[i].exists()) {
                if (members[i].getType() == 2) {
                    IContainer subfolder = (IContainer)members[i];
                    try {
                        IResource[] submembers = subfolder.members();
                        number += this.countFileNumber(submembers, 0);
                    }
                    catch (CoreException coreException) {
                        number += 0;
                    }
                } else if (members[i].getType() == 1) {
                    ++number;
                }
            }
            ++i;
        }
        return number;
    }
}

