/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder;

import com.ibm.etools.webedit.viewer.internal.utils.WebComponent;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.internal.builder.RelationDataManager;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildResourceVisitor
extends RelationDataManager
implements IResourceVisitor {
    public BuildResourceVisitor(IProgressMonitor monitor) {
        super(monitor);
    }

    public boolean visit(IResource resource) {
        WebComponent webComp = null;
        try {
            webComp = new WebComponent(resource);
            if (webComp.getComponent() == null) {
                return false;
            }
        }
        finally {
            if (webComp != null) {
                webComp.dispose();
            }
        }
        int type = resource.getType();
        if (type != 1) {
            return true;
        }
        if (!this.isValidFileType(resource)) {
            return false;
        }
        this.monitor.subTask(MessageFormat.format(ResourceHandler._UI_Template_Builder_is_checking__0__1, resource.getFullPath().toString()));
        if (this.hasTemplateNode((IFile)resource)) {
            if (this.isValidTemplateFileType(resource)) {
                this.addTemplateToTarget((IFile)resource);
            } else if (this.isInstanceFile((IFile)resource)) {
                this.addInstanceToTarget((IFile)resource);
            } else {
                this.addContainerToTarget((IFile)resource);
            }
        } else {
            this.removeFromCandidates(resource);
            this.clearModel((IFile)resource);
        }
        this.monitor.worked(1);
        return false;
    }
}

